/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.cs;

import java.awt.geom.Point2D;

public class CSUtils {
    static final double earthRadius = 6372795.0;

    public static Point2D getPointAtBearing(Point2D point, double dist, double bearing) {
        Point2D.Double pt = new Point2D.Double();
        CSUtils.getRadiansFromLatLon(point, pt);
        double lon1 = ((Point2D)pt).getX();
        double lat1 = ((Point2D)pt).getY();
        double d = dist / 6372795.0;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(d) + Math.cos(lat1) * Math.sin(d) * Math.cos(bearing));
        double lon2 = lon1 + Math.atan2(Math.sin(bearing) * Math.sin(d) * Math.cos(lat1), Math.cos(d) - Math.sin(lat1) * Math.sin(lat2));
        CSUtils.getLatLonFromRadians(new Point2D.Double(lon2, lat2), pt);
        return pt;
    }

    public static void getRadiansFromLatLon(Point2D point, Point2D pointOut) {
        double lon;
        double lat = point.getY();
        for (lon = point.getX(); lon < -180.0; lon += 360.0) {
        }
        while (lon > 180.0) {
            lon -= 360.0;
        }
        lon = lon * Math.PI / 180.0;
        lat = lat * Math.PI / 180.0;
        pointOut.setLocation(lon, lat);
    }

    public static void getLatLonFromRadians(Point2D point, Point2D pointOut) {
        double lon = point.getX();
        double lat = point.getY();
        lat = lat * 180.0 / Math.PI;
        lon = lon * 180.0 / Math.PI;
        pointOut.setLocation(lon, lat);
    }

    public static double getGreatCircleDistance(Point2D point1, Point2D point2) {
        Point2D.Double point1_ = new Point2D.Double();
        Point2D.Double point2_ = new Point2D.Double();
        CSUtils.getRadiansFromLatLon(point1, point1_);
        CSUtils.getRadiansFromLatLon(point2, point2_);
        double lonDif = ((Point2D)point2_).getX() - ((Point2D)point1_).getX();
        double latDif = ((Point2D)point2_).getY() - ((Point2D)point1_).getY();
        double slat = Math.sin(latDif / 2.0);
        double slon = Math.sin(lonDif / 2.0);
        double a = slat * slat + Math.cos(point1.getY()) * Math.cos(point2.getY()) * slon * slon;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6372795.0;
    }

    public static double getGreatCircleLength(double[] ords) {
        double length = 0.0;
        for (int i = 0; i < ords.length - 2; i += 2) {
            length += CSUtils.getGreatCircleDistance(new Point2D.Double(ords[i], ords[i + 1]), new Point2D.Double(ords[i + 2], ords[i + 3]));
        }
        return length;
    }
}

