/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.TileLayerConfig;
import oracle.maps.cs.CSTransformer;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.XFViewPort;

public class MapRegion {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected MapCanvas canvas = null;
    protected Rectangle2D dataWindow = null;
    protected XFViewPort xfm = new XFViewPort();
    protected int mapSrid;
    protected SRS mapSRS = null;
    protected int dataWindowSrid = 0;
    protected int userSrid = 0;
    protected EventListenerList listenerList = new EventListenerList();

    public MapRegion(MapCanvas canvas) {
        this.canvas = canvas;
        canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle2D.Double deviceWindow = new Rectangle2D.Double(0.0, 0.0, MapRegion.this.getMapCanvas().getWidth(), MapRegion.this.getMapCanvas().getHeight());
                MapRegion.this.xfm.setDeviceView((Rectangle2D)deviceWindow);
                Rectangle2D dataWin = MapRegion.this.getDataWindow();
                MapRegion.this.setDataWindow(dataWin);
            }
        });
    }

    private MapCanvas getMapCanvas() {
        return this.canvas;
    }

    public void setDataWindowByHeight(double centerX, double centerY, double height) {
        double dw = this.canvas.getWidth();
        double dh = this.canvas.getHeight();
        double upp = height / dh;
        double width = dw * upp;
        this.setDataWindow(new Rectangle2D.Double(centerX - width / 2.0, centerY - height / 2.0, width, height));
        log.finest("Map Region:\nXmin(" + (centerX - width / 2.0) + ") Ymin(" + (centerY - height / 2.0) + ") Xmax(" + (centerX + width / 2.0) + ") Ymax(" + (centerY + height / 2.0) + ")");
    }

    public void setDataWindowByScale(double centerX, double centerY, double scale) throws Exception {
        if (this.mapSRS == null) {
            throw new Exception("Can not set region by scale with null SRS.");
        }
        double screeninchScale = this.mapSRS.getScreenInchScale(scale, (Point2D)new Point2D.Double(centerX, centerY));
        if (screeninchScale == -1.0) {
            throw new Exception("Can not set region by scale with SRID = " + this.mapSRS.getSRID());
        }
        double height = screeninchScale * (double)this.canvas.getHeight() / SRS.getDPI();
        this.setDataWindowByHeight(centerX, centerY, height);
    }

    public int getMapSrid() {
        return this.mapSrid;
    }

    public void setMapSrid(int mapSrid) {
        this.mapSrid = mapSrid;
    }

    public Rectangle2D getDataWindow() {
        return this.dataWindow;
    }

    private AffineTransform getAppliedTransform(Rectangle2D before, Rectangle2D after) {
        if (before == null || after == null) {
            return null;
        }
        Point2D.Double bul = new Point2D.Double(before.getMinX(), before.getMinY());
        Point2D.Double bur = new Point2D.Double(before.getMaxX(), before.getMinY());
        Point2D.Double bdl = new Point2D.Double(before.getMinX(), before.getMaxY());
        Point2D.Double bc = new Point2D.Double(before.getCenterX(), before.getCenterY());
        Point2D.Double aul = new Point2D.Double(after.getMinX(), after.getMinY());
        Point2D.Double aur = new Point2D.Double(after.getMaxX(), after.getMinY());
        Point2D.Double adl = new Point2D.Double(after.getMinX(), after.getMaxY());
        Point2D.Double ac = new Point2D.Double(after.getCenterX(), after.getCenterY());
        double sX = aul.distance(aur) / bul.distance(bur);
        double sY = aul.distance(adl) / bul.distance(bdl);
        double tX = ((Point2D)ac).getX() - ((Point2D)bc).getX();
        double tY = ((Point2D)ac).getY() - ((Point2D)bc).getY();
        double angle = Math.atan2(((Point2D)aur).getY() - ((Point2D)aul).getY(), ((Point2D)aur).getX() - ((Point2D)aul).getX());
        AffineTransform res = new AffineTransform();
        res.translate(tX + ((Point2D)bc).getX(), tX + ((Point2D)bc).getY());
        res.rotate(angle);
        res.scale(sX, sX);
        res.translate(-((Point2D)bc).getX(), -((Point2D)bc).getY());
        return res;
    }

    public void setDataWindow(Rectangle2D dataWindow) {
        this.setDataWindow(dataWindow, 0);
    }

    public void setDataWindow(Rectangle2D dataWindow, int zoomLevelDif) {
        Rectangle2D oldWindow = this.getDataWindow();
        AffineTransform oldXFM = null;
        if (oldWindow != null) {
            oldXFM = this.getViewportTransform();
        }
        if (this.setDataWindowQuietly(dataWindow, zoomLevelDif)) {
            this.fireStateChanged(new MapRegionEvent(this, oldXFM, this.getViewportTransform(), oldWindow, this.getDataWindow()));
        }
    }

    boolean setDataWindowQuietly(Rectangle2D newDataWindow) {
        return this.setDataWindowQuietly(newDataWindow, 0);
    }

    boolean setDataWindowQuietly(Rectangle2D newDataWindow, int zoomLevelDif) {
        if (newDataWindow != null) {
            double y;
            double x;
            double h;
            double w;
            if (this.canvas.getWidth() != 0 && this.canvas.getHeight() != 0) {
                double aspectRatio = (double)this.canvas.getWidth() / (double)this.canvas.getHeight();
                w = Math.max(newDataWindow.getWidth(), newDataWindow.getHeight() * aspectRatio);
                h = w / aspectRatio;
                x = newDataWindow.getCenterX() - w / 2.0;
                y = newDataWindow.getCenterY() - h / 2.0;
            } else {
                x = newDataWindow.getX();
                y = newDataWindow.getY();
                w = newDataWindow.getWidth();
                h = newDataWindow.getHeight();
            }
            newDataWindow = new Rectangle2D.Double(x, y, w, h);
            TileLayerConfig tileConfig = this.canvas.getTileLayerConfig();
            if (tileConfig != null) {
                int scaleId;
                int tileLayerSrid = tileConfig.getSrid();
                if (this.getDataWindow() != null && this.getDataWindowSrid() != tileLayerSrid) {
                    Rectangle2D dataWinInTileSrid = CSTransformer.transform(newDataWindow, new int[]{this.getDataWindowSrid(), tileLayerSrid});
                    if (dataWinInTileSrid != null) {
                        newDataWindow = dataWinInTileSrid;
                        this.setDataWindowSrid(tileLayerSrid);
                        this.setMapSrid(tileLayerSrid);
                    } else {
                        System.err.println("Failed to transform data window to tile layer SRID: " + this.dataWindowSrid + " -> " + tileLayerSrid);
                        return false;
                    }
                }
                if ((scaleId = tileConfig.getClosestScaleID(newDataWindow, this.canvas.getHeight())) != -1) {
                    scaleId += zoomLevelDif;
                    scaleId = Math.max(0, scaleId);
                    scaleId = Math.min(tileConfig.getZoomLevelCount() - 1, scaleId);
                    double nsw = (double)this.canvas.getWidth() / tileConfig.getPixelsPerXUnit(scaleId);
                    double nsh = (double)this.canvas.getHeight() / tileConfig.getPixelsPerYUnit(scaleId);
                    Rectangle2D snapWin = this.zoomWindow(newDataWindow, null, nsw / newDataWindow.getWidth(), nsh / newDataWindow.getHeight());
                    if (snapWin != null) {
                        newDataWindow = snapWin;
                    }
                }
            }
        }
        Rectangle2D oldWindow = this.dataWindow;
        this.dataWindow = newDataWindow;
        if (newDataWindow != null) {
            this.xfm.setDataView(newDataWindow);
        }
        return this.dataWindow == null && oldWindow != null || this.dataWindow != null && oldWindow == null || oldWindow != null && !oldWindow.equals(this.dataWindow);
    }

    public int getDataWindowSrid() {
        return this.dataWindowSrid;
    }

    public void setDataWindowSrid(int dataWindowSrid) {
        this.dataWindowSrid = dataWindowSrid;
    }

    public double getMapScale() {
        return 1.0;
    }

    public AffineTransform getViewportTransform() {
        return this.xfm.getAffineTransform();
    }

    public AffineTransform getTransformDifference(AffineTransform oldXFM) {
        AffineTransform newXFM = this.getViewportTransform();
        AffineTransform diff = null;
        if (oldXFM != null && newXFM != null) {
            try {
                diff = new AffineTransform(oldXFM.createInverse());
                diff.preConcatenate(newXFM);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return diff;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged(ChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(evt);
        }
    }

    public void zoomBox(Rectangle2D window) {
        if (window == null || window.getWidth() == 0.0 || window.getHeight() == 0.0) {
            return;
        }
        try {
            Rectangle2D dWin = this.getViewportTransform().createInverse().createTransformedShape(window).getBounds2D();
            this.setDataWindow(dWin);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    private Rectangle2D zoomWindow(Rectangle2D window, Point2D deviceAnchor, double xFactor, double yFactor) {
        AffineTransform at = null;
        Point2D.Double dataAnchor = new Point2D.Double(window.getCenterX(), window.getCenterY());
        if (deviceAnchor != null) {
            try {
                at = this.getViewportTransform().createInverse();
                at.transform(deviceAnchor, dataAnchor);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            at = new AffineTransform();
        }
        at.setToTranslation(((Point2D)dataAnchor).getX(), ((Point2D)dataAnchor).getY());
        at.scale(xFactor, yFactor);
        at.translate(-((Point2D)dataAnchor).getX(), -((Point2D)dataAnchor).getY());
        return at.createTransformedShape(window).getBounds2D();
    }

    public void zoomIn() {
        this.zoomIn(null);
    }

    public void zoomIn(Point2D deviceAnchor) {
        this.zoom(deviceAnchor, 0.6666666666666666, 1);
    }

    public void zoomOut() {
        this.zoomOut(null);
    }

    public void zoomOut(Point2D deviceAnchor) {
        this.zoom(deviceAnchor, 1.5, -1);
    }

    public void zoom(Point2D deviceAnchor, double factor, int level) {
        if (this.getDataWindow() == null) {
            return;
        }
        Rectangle2D zoomedWindow = null;
        TileLayerConfig tlConfig = this.canvas.getTileLayerConfig();
        zoomedWindow = tlConfig != null ? this.getDataWindow() : this.zoomWindow(this.getDataWindow(), deviceAnchor, factor, factor);
        if (zoomedWindow == null) {
            return;
        }
        this.setDataWindow(zoomedWindow, level);
    }

    public void pan(int tx, int ty) {
        if (this.dataWindow == null) {
            return;
        }
        double xl = this.dataWindow.getMinX();
        double yl = this.dataWindow.getMinY();
        double w = this.dataWindow.getWidth();
        double h = this.dataWindow.getHeight();
        double xRes = this.dataWindow.getWidth() / (double)this.canvas.getWidth();
        double yRes = this.dataWindow.getHeight() / (double)this.canvas.getHeight();
        double translateX = xRes * (double)tx;
        double translateY = yRes * (double)ty;
        this.setDataWindow(new Rectangle2D.Double(xl + translateX, yl + translateY, w, h));
    }

    public void setSRS(SRS srs) {
        this.mapSRS = srs;
    }

    public SRS getSRS() {
        return this.mapSRS;
    }

    public double getCurrentRatioScale() {
        double centerY;
        double centerX;
        Point2D.Double center;
        if (this.mapSRS == null || this.dataWindow == null) {
            return Double.NaN;
        }
        double inches = (double)this.canvas.getHeight() / SRS.getDPI();
        double inchesScale = this.dataWindow.getHeight() / inches;
        double rscale = this.mapSRS.getRatioScale(inchesScale, (Point2D)(center = new Point2D.Double(centerX = this.dataWindow.getCenterX(), centerY = this.dataWindow.getCenterY())));
        if (rscale != -1.0) {
            return rscale;
        }
        return Double.NaN;
    }

    public int getUserSrid() {
        return this.userSrid;
    }

    public void setUserSrid(int userSrid) {
        this.userSrid = userSrid;
    }
}

