/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ideri.util.Product;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.extender.evaluator.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowProviderCallback;

class WindowManager {
    private Map<Integer, WindowProviderCallback> debuggerWindowProviders = new LinkedHashMap<Integer, WindowProviderCallback>();
    private Set<String> notInRaptor = new HashSet<String>();

    WindowManager() {
        this.notInRaptor.add("Debugger.ThreadsWindow");
        this.notInRaptor.add("Debugger.HeapWindow");
        this.notInRaptor.add("Debugger.ClassesWindow");
        this.notInRaptor.add("Debugger.MonitorsWindow");
    }

    void reinstallWindows(Set<String> windowIDs) {
        for (String windowID : windowIDs) {
            this.installWindow(windowID);
        }
    }

    WindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider, boolean customWindow) {
        WindowProviderCallback callback = new WindowProviderCallback(this, provider, customWindow);
        int ID = System.identityHashCode(provider);
        this.debuggerWindowProviders.put(ID, callback);
        return callback;
    }

    boolean hasDebuggerWindowProvider(DebuggerWindowProvider provider) {
        return this.debuggerWindowProviders.containsKey(System.identityHashCode(provider));
    }

    void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        int ID = System.identityHashCode(provider);
        this.debuggerWindowProviders.remove(ID);
    }

    DockableWindow getDebuggerWindow(String windowID) {
        DebuggerWindowProvider provider = this.getDebuggerWindowProvider(windowID);
        if (provider != null) {
            if (provider instanceof DebuggerWindow) {
                return ((DebuggerWindow)provider).getCoreDebuggerWindow();
            }
            System.out.println("WindowManager.getDebuggerWindow called for non-core window " + windowID);
            return provider.getWindow();
        }
        return null;
    }

    DebuggerWindowProvider getDebuggerWindowProvider(String windowID) {
        for (WindowProviderCallback wpc : this.debuggerWindowProviders.values()) {
            DebuggerWindowProvider provider = wpc.getProvider();
            if (!(provider instanceof DebuggerWindow ? ((DebuggerWindow)provider).getId().equals(windowID) : provider.getWindow() != null && provider.getWindow().getId().equals(windowID))) continue;
            return provider;
        }
        return null;
    }

    void installWindow(String windowID) {
        if (Product.isRaptor() && this.notInRaptor.contains(windowID)) {
            return;
        }
        DebuggerWindowProvider provider = this.getDebuggerWindowProvider(windowID);
        if (provider != null) {
            ViewId viewId;
            DockStation ds = DockStation.getDockStation();
            DebugDockableFactory factory = (DebugDockableFactory)ds.lookupFactory(viewId = new ViewId(windowID));
            if (factory == null) {
                IllegalArgumentException iae = new IllegalArgumentException("viewID " + viewId + " has no configured DebugDockableFactorymaking it impossible to install window " + windowID);
                FeedbackManager.reportException((String)"LookupFactory for View returned null", (Throwable)iae);
                return;
            }
            LogWindow tabbedWith = null;
            int position = 0;
            switch (provider.getPosition()) {
                case SOUTH: {
                    tabbedWith = LogManager.getIdeLogWindow();
                    position = 3;
                    break;
                }
                case WEST: {
                    tabbedWith = ds.findDockable(ExplorerManager.getExplorerManager().getDefaultViewId());
                    position = 0;
                    break;
                }
                case EAST: {
                    if (!windowID.equals("Debugger.ClassesWindow")) {
                        tabbedWith = ds.findDockable(new ViewId("Debugger.ClassesWindow"));
                    }
                    position = 1;
                    break;
                }
                case FLOATING: {
                    if (provider instanceof DebuggerWindow) {
                        factory.floatWindow(windowID, ((DebuggerWindow)provider).getCoreDebuggerWindow(), provider.getFloatingPosition());
                    } else {
                        factory.floatWindow(windowID, provider.getWindow(), provider.getFloatingPosition());
                    }
                    return;
                }
            }
            if (provider instanceof DebuggerWindow) {
                factory.installWindow(windowID, ((DebuggerWindow)provider).getCoreDebuggerWindow(), (Dockable)tabbedWith, position);
            } else {
                factory.installWindow(windowID, provider.getWindow(), (Dockable)tabbedWith, position);
            }
        }
    }

    @Deprecated
    void installCustomWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            this.installCustomWindow(callback);
        }
    }

    @Deprecated
    void installCustomWindow(WindowProviderCallback callback) {
        if (callback.isCustomWindow() && callback.getProvider().installByDefault()) {
            this.installWindow(callback.getProvider().getWindow().getId());
        }
    }

    void setDebuggerWindowProvidersContext(Context context) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().setContext(context);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows(EvaluatorProxy evaluator, DebuggingProcess process) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            if (!callback.isCustomWindow()) continue;
            try {
                long milliTime = System.currentTimeMillis();
                if (evaluator != null && process != null) {
                    EvaluatorHandle.EvaluatorHandleVersion12 handle = EvaluatorHandle.createEvaluatorHandleVersion12(evaluator, process, callback.getCustomDataProvider());
                    callback.getProvider().setEvaluator((DebuggerEvaluator)handle);
                }
                callback.getProvider().refresh();
                if (!JDebugger.logger.isEnabled()) continue;
                JDebugger.logger.trace("Refresh window: " + callback.getProvider().getClass().getName() + " in " + (System.currentTimeMillis() - milliTime) + " msecs");
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows() {
        this.refreshCustomWindows(null, null);
    }

    void shutdownWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().shutDown();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }
}

