/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WatchController;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;

final class WatchPanel
extends EvaluatorPanel {
    WatchPanel(WatchWindow watchWindow, WatchWindowSettings watchWindowSettings) {
        super(watchWindow, watchWindowSettings.getDataPanelSettings());
    }

    @Override
    protected Component adjustGUI(Component defaultGui) {
        String ACTION_DELETE_KEY = "ActionDelete";
        this.getDataTable().getTable().getInputMap().put(KeyStroke.getKeyStroke(127, 0), "ActionDelete");
        this.getDataTable().getTable().getActionMap().put("ActionDelete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Context context = WatchPanel.this.getController().getContext(e);
                ((WatchController)WatchPanel.this.getController()).delete(context);
            }
        });
        this.getDataTable().addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WatchController.actionRemoveWatch.updateAction();
            }
        });
        this.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("DataItemExpression")) {
                    WatchPanel.this.updateHistory(evt.getNewValue().toString());
                    WatchPanel.this.getController().everythingChanged();
                }
            }
        });
        return defaultGui;
    }

    @Override
    protected void checkDrag(DropTargetDragEvent e) {
        int action;
        if ((e.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || e.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor()) || e.isDataFlavorSupported(DataItem.getExpressionFlavor()) || e.isDataFlavorSupported(DataFlavor.stringFlavor)) && ((action = e.getSourceActions()) == 1 || action == 3)) {
            e.acceptDrag(action);
            return;
        }
        super.checkDrag(e);
    }

    @Override
    protected void checkDrop(DropTargetDropEvent e) {
        if (e.isLocalTransfer()) {
            if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                    JDebugger.getInstance().addWatch(data.getName());
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception t) {}
            } else if (e.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getInterfaceFlavor());
                    JDebugger.getInstance().addWatch(data.getName());
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception t) {}
            } else if (e.isDataFlavorSupported(DataItem.getExpressionFlavor())) {
                try {
                    Transferable t = e.getTransferable();
                    Expression expression = (Expression)t.getTransferData(DataItem.getExpressionFlavor());
                    JDebugger.getInstance().addWatch(new EvaluatorItem(expression));
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception t) {}
            } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    Transferable t = e.getTransferable();
                    String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                    JDebugger.getInstance().addWatch(s);
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.checkDrop(e);
    }

    @Override
    protected DataController createController(DataPanelSettings dataPanelSettings) {
        return new WatchController(dataPanelSettings, this);
    }

    @Override
    String getWindowId() {
        return "Debugger.WatchWindow";
    }

    @Override
    public DebuggerWindowOptions.WindowId getWindowIdEnum() {
        return DebuggerWindowOptions.WindowId.WatchWindow;
    }

    @Override
    protected Toolbar createToolbar() {
        ActionMenuToolButton deleteButton = new ActionMenuToolButton((Action)WatchController.actionRemoveWatch);
        deleteButton.setMenuActions(new Action[]{WatchController.actionRemoveWatch, WatchController.actionRemoveAllWatches});
        Toolbar toolbar = super.createToolbar();
        int i = 0;
        toolbar.add((Component)toolbar.newSeparator(), i++);
        toolbar.add((Component)new ToolButton((Action)WatchController.actionAddNewWatch), i++);
        toolbar.add((Component)deleteButton, i++);
        toolbar.add((Component)toolbar.newSeparator(), i++);
        toolbar.add((Component)this.createHistoryButton(), i++);
        return toolbar;
    }

    protected JComponent createHistoryButton() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                JDebugger.getInstance().addWatch(item.getText());
            }
        };
        return super.createHistoryButton(listener);
    }
}

