/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.HeapController;
import oracle.jdevimpl.runner.debug.HeapPanel;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.Utils;

final class HeapWindow
extends DataWindow {
    static final String HEAP_WINDOW_ID = "Debugger.HeapWindow";
    private HeapPanel heapPanel;
    private Boolean useFilters;
    private Component gui;

    HeapWindow() {
        super(HEAP_WINDOW_ID, DbgArb.getString(564), "f1_deb_heapwindow_html");
    }

    @Override
    protected final DataPanel getDataPanel(boolean forceCreate) {
        if (this.heapPanel == null && forceCreate) {
            this.heapPanel = new HeapPanel(this, HeapWindowSettings.getInstance());
            if (this.useFilters != null) {
                this.heapPanel.setUseFilters(this.useFilters);
            }
        }
        return this.heapPanel;
    }

    @Override
    final void setUseFilters(boolean useFilters) {
        if (this.heapPanel != null) {
            this.heapPanel.setUseFilters(useFilters);
        } else {
            this.useFilters = useFilters;
        }
    }

    @Override
    @Deprecated
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    @Deprecated
    public boolean installByDefault() {
        return true;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.heapPanel != null) {
            ((HeapController)this.heapPanel.getController()).saveClasses((PropertyAccess)Ide.getIdeProperties());
        }
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        DebuggerDataWindowOptions options = this.getDataPanel(true).getController().getDebuggerWindowOptions();
        if (options != null) {
            return options.getTabIcon();
        }
        return OracleIcons.getIcon((String)"debugger/heap.png");
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return this.title;
    }

    @Override
    public Component getGUI() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        if (this.gui == null) {
            HeapWindowSettings heapSettings = HeapWindowSettings.getInstance();
            heapSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        HeapWindow.this.heapWindowSettingsChanged(true);
                    }
                }
            });
            this.gui = super.getGUI();
        }
        return this.gui;
    }

    void heapWindowSettingsChanged(boolean changed) {
        if (changed) {
            this.everythingChanged();
        }
    }

    void addHeapClass(String name) {
        ((HeapController)this.getDataPanel(true).getController()).addClass(name);
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        DataPanel dataPanel;
        if (this.getController() != null) {
            ((HeapController)this.getController()).processFinished(debuggingProcess);
        }
        if ((dataPanel = this.getDataPanel(false)) != null) {
            dataPanel.processFinished(debuggingProcess);
        }
        super.processFinished(debuggingProcess);
    }
}

