/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;

public class EvaluatorItem
implements DebugPinListener {
    private String expression;
    private Map<DebuggingProcess, DebugPinnedInfo> pinned;
    private Map<DebuggingProcess, DebugPinnedInfo> discarded;
    private String name;
    private boolean showPinnedDiscarded;
    private DebuggingProcess temporary;
    private boolean canUnpin;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public EvaluatorItem(String expression) {
        this.expression = expression;
        this.name = null;
        this.showPinnedDiscarded = true;
        this.canUnpin = true;
    }

    EvaluatorItem(Expression expression) {
        this(expression.getExpression());
        this.setOptions(expression.getName(), expression.isShowPinnedDiscarded(), expression.getTemporary());
    }

    public void addPropertyChangeSupport(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeSupport(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    void pin(DebuggingProcess debuggingProcess, DebugDataCompositeInfo datac) {
        DebugPinnedInfo pin = datac.pinObject(this);
        if (pin != null) {
            if (this.pinned == null) {
                this.pinned = new HashMap<DebuggingProcess, DebugPinnedInfo>();
            }
            this.pinned.put(debuggingProcess, pin);
        }
    }

    public void setOptions(String name, boolean showPinnedDiscarded, DebuggingProcess temporary) {
        this.name = name;
        this.showPinnedDiscarded = showPinnedDiscarded;
        this.temporary = temporary;
    }

    public String getName() {
        return this.name;
    }

    public boolean isShowPinnedDiscarded() {
        return this.showPinnedDiscarded;
    }

    public DebuggingProcess getTemporary() {
        return this.temporary;
    }

    void setCanUnpin(boolean canUnpin) {
        this.canUnpin = canUnpin;
    }

    boolean canUnpin(DebuggingProcess debuggingProcess) {
        return this.canUnpin && this.isPinned(debuggingProcess);
    }

    void unpin(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.pinned != null && (p = this.pinned.remove(debuggingProcess)) != null) {
            p.unpinObject();
        }
        if (this.discarded != null) {
            this.discarded.remove(debuggingProcess);
        }
    }

    void unpinForAll() {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
        if (this.discarded != null) {
            for (DebuggingProcess debuggingProcess : this.discarded.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
    }

    @Override
    public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                DebugPinnedInfo p;
                if (debuggingProcess.getVM() != vm || !(p = this.pinned.get(debuggingProcess)).equals(pin)) continue;
                this.pinned.remove(debuggingProcess);
                if (this.discarded == null) {
                    this.discarded = new HashMap<DebuggingProcess, DebugPinnedInfo>();
                }
                this.discarded.put(debuggingProcess, pin);
                return;
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        String oldValue = this.expression;
        this.expression = expression;
        this.name = expression;
        if (this.pinned != null) {
            this.pinned.clear();
        }
        if (this.discarded != null) {
            this.discarded.clear();
        }
        this.propertySupport.firePropertyChange("expression", oldValue, expression);
    }

    boolean isPinned(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo o;
        if (this.pinned != null && (o = this.pinned.get(debuggingProcess)) != null) {
            return true;
        }
        return this.isDiscarded(debuggingProcess);
    }

    private long getPinnedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.pinned != null && (p = this.pinned.get(debuggingProcess)) != null) {
            return p.getUniqueID();
        }
        return 0L;
    }

    private boolean isDiscarded(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo o;
        return this.discarded != null && (o = this.discarded.get(debuggingProcess)) != null;
    }

    long getDiscardedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.discarded != null && (p = this.discarded.get(debuggingProcess)) != null) {
            return p.getUniqueID();
        }
        return 0L;
    }

    Object evaluate(DebuggingProcess debuggingProcess, EvaluatorProxy evaluator) {
        if (this.isDiscarded(debuggingProcess)) {
            return null;
        }
        if (this.isPinned(debuggingProcess)) {
            DebugPinnedInfo p = this.pinned.get(debuggingProcess);
            return p.getDataInfo();
        }
        return evaluator.evaluate(this.expression);
    }

    public String getName(DebuggingProcess debuggingProcess) {
        String baseName = this.name != null ? this.name : this.expression;
        if (this.showPinnedDiscarded) {
            long id = this.getPinnedId(debuggingProcess);
            if (id != 0L) {
                return baseName + " " + DbgArb.format(591, Long.toHexString(id).toUpperCase());
            }
            id = this.getDiscardedId(debuggingProcess);
            if (id != 0L) {
                return baseName + " " + DbgArb.format(592, Long.toHexString(id).toUpperCase());
            }
        }
        return baseName;
    }

    public void watch() {
        JDebugger.getInstance().addWatch(this);
    }

    public void inspect() {
        JDebugger.getInstance().inspect(this);
    }
}

