/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Runner;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class DebuggingListener
extends BaseElement
implements DebugConnectionListener {
    private DebuggingProcess debuggingProcess;
    private boolean keepListening;
    private Workspace workspace;
    private Project project;
    private RunConfiguration runConfiguration;
    private DebugConfiguration debugConfiguration;
    private DebugConnector connector;
    private DebugConnectArg[] connectArgs;
    private String connectArgsLabel;

    public DebuggingListener(DebuggingProcess debuggingProcess, boolean keepListening) {
        JDebugger.getInstance().makeDebuggingListenerActions();
        this.debuggingProcess = debuggingProcess;
        this.keepListening = keepListening;
        this.project = debuggingProcess.getProject();
        this.workspace = debuggingProcess.getWorkspace();
        this.runConfiguration = debuggingProcess.getRunConfiguration();
        this.debugConfiguration = debuggingProcess.getDebugConfiguration();
        this.setIcon(OracleIcons.getIcon((String)"debugger/deb_ltnr.gif"));
    }

    public boolean startListening() {
        return this.startListening(null);
    }

    public boolean startListening(String listenPort) {
        this.connector = DebugFactory.newInstance(DebugFactory.FACTORY_JPDA_Listen);
        this.connectArgs = this.connector.getConnectArgs();
        int count = this.connectArgs.length;
        boolean errorOccurred = false;
        while (true) {
            DebugConnectArg connectArg;
            int i;
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                boolean needDialog = !MessageDialog.getPersistence().isHidden("RemoteConnectDialog");
                for (i = 0; i < count; ++i) {
                    connectArg = this.connectArgs[i];
                    String value = this.debugConfiguration.getRemoteParameterValue("jpdalisten", connectArg.getName(), connectArg.getValue());
                    if (value != null) {
                        connectArg.setValue(value);
                        if (value.length() != 0 || connectArg.allowBlank()) continue;
                        needDialog = true;
                        continue;
                    }
                    needDialog = true;
                }
                if (errorOccurred) {
                    needDialog = true;
                }
                if (needDialog) {
                    String title = DbgArb.getString(182);
                    String helpId = "f1_deb_listen_jpda_html";
                    boolean[] save = !Product.isRaptor() ? new boolean[1] : null;
                    boolean ok = RemoteConnectDialog.showRemoteConnectDialog(title, this.connectArgs, save, helpId);
                    if (!ok) {
                        return false;
                    }
                    for (int i2 = 0; i2 < count; ++i2) {
                        DebugConnectArg connectArg2 = this.connectArgs[i2];
                        if (save != null && !save[0] && !this.debugConfiguration.isCustom()) continue;
                        this.debugConfiguration.putRemoteParameterValue("jpdalisten", connectArg2.getName(), connectArg2.getValue());
                    }
                }
            } else {
                Assert.check((listenPort != null ? 1 : 0) != 0);
                DebugConnectArg connectArg3 = DebugShared.findConnectArg(this.connectArgs, "port");
                if (connectArg3 != null) {
                    connectArg3.setValue(listenPort);
                }
            }
            try {
                this.connector.startListening(this.connectArgs, this);
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < count; ++i) {
                    connectArg = this.connectArgs[i];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(connectArg.getLabel());
                    sb.append("=");
                    sb.append(connectArg.getValue());
                }
                this.connectArgsLabel = sb.toString();
                return true;
            }
            catch (Exception sb) {
                block14: {
                    int answer;
                    if (!this.runConfiguration.isRemoteDebuggingProfiling()) break block14;
                    errorOccurred = true;
                    String[] messages = new String[]{DbgArb.getString(184), DbgArb.getString(185)};
                    if ((answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, DbgArb.getString(186), 0)) != 1) continue;
                }
                return false;
            }
            break;
        }
    }

    public void stopListening() {
        try {
            this.connector.stopListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void listeningStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDebugger.getInstance().listenerStarted(DebuggingListener.this);
                Runner.getRunner().getRunManagerFolder().add((Element)DebuggingListener.this);
            }
        });
    }

    @Override
    public boolean connectionEstablished(final DebugVirtualMachine vm) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingProcess debuggingProcessForAccept = DebuggingListener.this.debuggingProcess;
                DebuggingListener.this.debuggingProcess = null;
                if (debuggingProcessForAccept == null) {
                    Context context = ContextBuilder.buildContext(null, (View)Runner.getRunner().getRunManagerWindow(), null, DebuggingListener.this.workspace, DebuggingListener.this.project);
                    debuggingProcessForAccept = new DebuggingProcess(context);
                }
                debuggingProcessForAccept.accept(vm, DebuggingListener.this.connectArgs);
            }
        });
        return this.keepListening;
    }

    @Override
    public void listeningStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DebuggingListener.this.debuggingProcess != null) {
                    DebuggingListener.this.debuggingProcess.listenerStopped();
                    DebuggingListener.this.debuggingProcess = null;
                }
                JDebugger.getInstance().listenerStopped(DebuggingListener.this);
                Runner.getRunner().getRunManagerFolder().remove((Element)DebuggingListener.this);
            }
        });
    }

    public String getShortLabel() {
        if (this.connectArgsLabel != null && this.connectArgsLabel.length() > 0) {
            return DbgArb.format(146, this.connectArgsLabel);
        }
        return DbgArb.getString(145);
    }
}

