/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

public final class DebugWindowSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox toolTipCheckBox;
    private JCheckBox toolbarCheckBox;
    private JLabel connectionRetriesLabel;
    private NumericSpinBox connectionRetriesBox;
    private JCheckBox promptHostDatabaseCheckBox;
    private JCheckBox detectMethodEvalDeadlocksCheckBox;
    private JCheckBox localPortRangeCheckBox;
    private JLabel localPortRangeMinLabel;
    private NumericSpinBox localPortRangeMinBox;
    private JLabel localPortRangeMaxLabel;
    private NumericSpinBox localPortRangeMaxBox;
    private JRadioButton startRunningRadio;
    private JRadioButton startStepOverRadio;
    private JRadioButton startStepIntoRadio;
    private JCheckBox enableChangeTrackingCheckbox;
    private CustomColorChoice changedCellForegroundColorChoice;
    private CustomColorChoice changedCellBackgroundColorChoice;
    private JCheckBox useToStringForValueCheckBox;
    private JCheckBox useToStringOnlyIfOverriddenCheckBox;
    private JCheckBox useToStringOnlyWhenNoExpressionCheckBox;
    private ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();

    public DebugWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_projset_debugwin_html");
        this.toolTipCheckBox = new JCheckBox();
        this.toolbarCheckBox = new JCheckBox();
        this.connectionRetriesLabel = new JLabel();
        this.connectionRetriesBox = new NumericSpinBox(0, 1000);
        this.promptHostDatabaseCheckBox = new JCheckBox();
        this.detectMethodEvalDeadlocksCheckBox = new JCheckBox();
        this.localPortRangeCheckBox = new JCheckBox();
        this.localPortRangeMinLabel = new JLabel();
        this.localPortRangeMinBox = new NumericSpinBox(0, 65535);
        this.localPortRangeMaxLabel = new JLabel();
        this.localPortRangeMaxBox = new NumericSpinBox(0, 65535);
        this.startRunningRadio = new JRadioButton();
        this.startStepOverRadio = new JRadioButton();
        this.startStepIntoRadio = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.startRunningRadio);
        group.add(this.startStepOverRadio);
        group.add(this.startStepIntoRadio);
        this.enableChangeTrackingCheckbox = new JCheckBox();
        this.changedCellForegroundColorChoice = new CustomColorChoice();
        this.changedCellBackgroundColorChoice = new CustomColorChoice();
        this.useToStringForValueCheckBox = new JCheckBox();
        this.useToStringOnlyIfOverriddenCheckBox = new JCheckBox();
        this.useToStringOnlyWhenNoExpressionCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.toolTipCheckBox, (String)DbgArb.getString(630));
        ResourceUtils.resButton((AbstractButton)this.toolbarCheckBox, (String)DbgArb.getString(631));
        ResourceUtils.resLabel((JLabel)this.connectionRetriesLabel, (Component)this.connectionRetriesBox, (String)DbgArb.getString(632));
        ResourceUtils.resButton((AbstractButton)this.promptHostDatabaseCheckBox, (String)DbgArb.getString(633));
        ResourceUtils.resButton((AbstractButton)this.detectMethodEvalDeadlocksCheckBox, (String)DbgArb.getString(850));
        ResourceUtils.resButton((AbstractButton)this.localPortRangeCheckBox, (String)DbgArb.getString(634));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMinLabel, (Component)this.localPortRangeMinBox, (String)DbgArb.getString(635));
        ResourceUtils.resLabel((JLabel)this.localPortRangeMaxLabel, (Component)this.localPortRangeMaxBox, (String)DbgArb.getString(636));
        ResourceUtils.resButton((AbstractButton)this.startRunningRadio, (String)DbgArb.getString(317));
        ResourceUtils.resButton((AbstractButton)this.startStepOverRadio, (String)DbgArb.getString(318));
        ResourceUtils.resButton((AbstractButton)this.startStepIntoRadio, (String)DbgArb.getString(319));
        ResourceUtils.resButton((AbstractButton)this.enableChangeTrackingCheckbox, (String)DbgArb.getString(638));
        ResourceUtils.resButton((AbstractButton)this.changedCellForegroundColorChoice, (String)DbgArb.getString(639));
        ResourceUtils.resButton((AbstractButton)this.changedCellBackgroundColorChoice, (String)DbgArb.getString(640));
        ResourceUtils.resButton((AbstractButton)this.useToStringForValueCheckBox, (String)DbgArb.getString(641));
        ResourceUtils.resButton((AbstractButton)this.useToStringOnlyIfOverriddenCheckBox, (String)DbgArb.getString(642));
        ResourceUtils.resButton((AbstractButton)this.useToStringOnlyWhenNoExpressionCheckBox, (String)DbgArb.getString(643));
        this.localPortRangeCheckBox.addItemListener(this);
        this.useToStringForValueCheckBox.addItemListener(this);
        this.setSpinBuddyAlignment(this.connectionRetriesBox);
        this.setSpinBuddyAlignment(this.localPortRangeMinBox);
        this.setSpinBuddyAlignment(this.localPortRangeMaxBox);
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(this.toolTipCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.useToStringForValueCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 1), 0, 0));
        this.add(this.useToStringOnlyIfOverriddenCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 25, 0, 1), 0, 0));
        this.add(this.useToStringOnlyWhenNoExpressionCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 25, 0, 5), 0, 0));
        this.add(this.toolbarCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.makeConnectionRetriesPanel(), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.promptHostDatabaseCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.detectMethodEvalDeadlocksCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.makeLocalPortRangePanel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.makeStartPanel(), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.makeChangeTrackingPanel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setSpinBuddyAlignment(NumericSpinBox box) {
        SpinBuddy buddy = box.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
    }

    private JPanel makeConnectionRetriesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.connectionRetriesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.connectionRetriesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeLocalPortRangePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)this.localPortRangeCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.localPortRangeMinLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 25, 0, 0), 0, 0));
        panel.add((Component)this.localPortRangeMinBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        panel.add((Component)this.localPortRangeMaxLabel, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0));
        panel.add((Component)this.localPortRangeMaxBox, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeStartPanel() {
        JPanel startPanel = new JPanel(new GridBagLayout());
        JLabel startLabel = new JLabel(DbgArb.getString(316));
        int y = 0;
        startPanel.add((Component)startLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        startPanel.add((Component)this.startRunningRadio, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        startPanel.add((Component)this.startStepOverRadio, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        startPanel.add((Component)this.startStepIntoRadio, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        startPanel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return startPanel;
    }

    private JPanel makeChangeTrackingPanel() {
        JPanel changeTrackingPanel = new JPanel(new GridBagLayout());
        int y = 0;
        changeTrackingPanel.add((Component)this.enableChangeTrackingCheckbox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        changeTrackingPanel.add((Component)this.changedCellForegroundColorChoice, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        changeTrackingPanel.add((Component)this.changedCellBackgroundColorChoice, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 2, 0), 0, 0));
        changeTrackingPanel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return changeTrackingPanel;
    }

    private void enableLocalPortRange() {
        boolean enabled = this.localPortRangeCheckBox.isSelected();
        this.localPortRangeMinLabel.setEnabled(enabled);
        this.localPortRangeMinBox.setEnabled(enabled);
        this.localPortRangeMaxLabel.setEnabled(enabled);
        this.localPortRangeMaxBox.setEnabled(enabled);
    }

    private DebugWindowSettings getSettings(TraversableContext tc) {
        return DebugWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        DebugWindowSettings settings = this.getSettings(tc);
        this.toolTipCheckBox.setSelected(settings.isShowToolTipInCodeEditor());
        DataValueToStringBehavior toStringBehavior = this.objectPreferences.getUseToStringBehavior("*");
        this.useToStringForValueCheckBox.setSelected(toStringBehavior.isUseToString());
        this.useToStringOnlyIfOverriddenCheckBox.setSelected(toStringBehavior.isUseToStringOnlyWhenOverridden());
        this.useToStringOnlyIfOverriddenCheckBox.setEnabled(this.useToStringForValueCheckBox.isSelected());
        this.useToStringOnlyWhenNoExpressionCheckBox.setSelected(toStringBehavior.isUseToStringOnlyWhenNoExpressionSpecified());
        this.useToStringOnlyWhenNoExpressionCheckBox.setEnabled(this.useToStringForValueCheckBox.isSelected());
        this.toolbarCheckBox.setSelected(settings.isShowActionButtonsOnToolbar());
        this.connectionRetriesBox.setIntValue(settings.getConnectionRetries());
        this.promptHostDatabaseCheckBox.setSelected(settings.isPromptForDebuggerHostForDatabaseDebugging());
        this.detectMethodEvalDeadlocksCheckBox.setSelected(settings.isDetectMethodEvalDeadlocks());
        this.localPortRangeCheckBox.setSelected(settings.isLocalPortRange());
        this.localPortRangeMinBox.setIntValue(settings.getLocalPortRangeMin());
        this.localPortRangeMaxBox.setIntValue(settings.getLocalPortRangeMax());
        this.enableLocalPortRange();
        this.startRunningRadio.setSelected(false);
        this.startStepOverRadio.setSelected(false);
        this.startStepIntoRadio.setSelected(false);
        String startOption = settings.getStartOption();
        if (startOption.equals("stepover")) {
            this.startStepOverRadio.setSelected(true);
        } else if (startOption.equals("stepinto")) {
            this.startStepIntoRadio.setSelected(true);
        } else {
            this.startRunningRadio.setSelected(true);
        }
        this.enableChangeTrackingCheckbox.setSelected(settings.isChangeTrackingEnabled());
        this.changedCellForegroundColorChoice.setClosestSelectedColor(settings.getChangedCellForegroundColor());
        this.changedCellBackgroundColorChoice.setClosestSelectedColor(settings.getChangedCellBackgroundColor());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (this.localPortRangeCheckBox.isSelected() && this.localPortRangeMinBox.getIntValue() > this.localPortRangeMaxBox.getIntValue()) {
            throw new TraversalException(DbgArb.getString(637));
        }
        DebugWindowSettings settings = this.getSettings(tc);
        settings.setShowToolTipInCodeEditor(this.toolTipCheckBox.isSelected());
        DataValueToStringBehavior toStringBehavior = new DataValueToStringBehavior();
        toStringBehavior.setUseToString(this.useToStringForValueCheckBox.isSelected());
        toStringBehavior.setUseToStringOnlyWhenOverridden(this.useToStringOnlyIfOverriddenCheckBox.isSelected());
        toStringBehavior.setUseToStringOnlyWhenNoExpressionSpecified(this.useToStringOnlyWhenNoExpressionCheckBox.isSelected());
        this.objectPreferences.setUseToStringBehavior("*", toStringBehavior);
        settings.setShowActionButtonsOnToolbar(this.toolbarCheckBox.isSelected());
        settings.setConnectionRetries(this.connectionRetriesBox.getIntValue());
        settings.setPromptForDebuggerHostForDatabaseDebugging(this.promptHostDatabaseCheckBox.isSelected());
        settings.setDetectMethodEvalDeadlocks(this.detectMethodEvalDeadlocksCheckBox.isSelected());
        settings.setLocalPortRange(this.localPortRangeCheckBox.isSelected());
        settings.setLocalPortRangeMin(this.localPortRangeMinBox.getIntValue());
        settings.setLocalPortRangeMax(this.localPortRangeMaxBox.getIntValue());
        String startOption = this.startStepOverRadio.isSelected() ? "stepover" : (this.startStepIntoRadio.isSelected() ? "stepinto" : "running");
        settings.setStartOption(startOption);
        settings.setChangeTrackingEnabled(this.enableChangeTrackingCheckbox.isSelected());
        settings.setChangedCellBackgroundColor(this.changedCellBackgroundColorChoice.getSelectedColor());
        settings.setChangedCellForegroundColor(this.changedCellForegroundColorChoice.getSelectedColor());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.localPortRangeCheckBox) {
            this.enableLocalPortRange();
        }
        if (source == this.useToStringForValueCheckBox) {
            boolean enabled = this.useToStringForValueCheckBox.isSelected();
            this.useToStringOnlyIfOverriddenCheckBox.setEnabled(enabled);
            this.useToStringOnlyWhenNoExpressionCheckBox.setEnabled(enabled);
        }
    }
}

