/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.debugger.support.DebugConnectorAttributes;
import oracle.jdevimpl.runner.SourceHook;

public final class DebugConnectorHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/jdev-runner", "debug-connector-hook");
    private static final String DEBUG_CONNECTOR_ATTRIBUTES = "debug-connector-attributes";
    private static HashStructureHook hook;
    private static Map<String, ToolDescription> _debugConnectors;
    private static Set<String> _emittedErrors;
    private static int retrievedCount;

    public static synchronized boolean addDebugConnector(DebugConnectorAttributes debugConnectorAttributes) {
        if (debugConnectorAttributes == null) {
            assert (debugConnectorAttributes != null) : "Need a valid DebugConnectorAttributes argument";
            return false;
        }
        DebugConnectorHook.primeHook();
        return DebugConnectorHook.addTool(debugConnectorAttributes, _debugConnectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<DebugConnectorAttributes> getNewDebugConnectors() {
        Class<DebugConnectorHook> clazz = DebugConnectorHook.class;
        // MONITORENTER : oracle.jdevimpl.runner.debug.DebugConnectorHook.class
        DebugConnectorHook.primeHook();
        if (retrievedCount == _debugConnectors.size()) {
            // MONITOREXIT : clazz
            return Collections.emptyList();
        }
        // MONITOREXIT : clazz
        ArrayList<DebugConnectorAttributes> newTools = new ArrayList<DebugConnectorAttributes>();
        int x = 0;
        while (x < 10) {
            Class<DebugConnectorHook> clazz2 = DebugConnectorHook.class;
            // MONITORENTER : oracle.jdevimpl.runner.debug.DebugConnectorHook.class
            ArrayList<ToolDescription> copy = new ArrayList<ToolDescription>(_debugConnectors.values());
            int copySize = copy.size();
            // MONITOREXIT : clazz2
            for (ToolDescription desc : copy) {
                if (desc.hasBeenRetrieved()) continue;
                ++retrievedCount;
                DebugConnectorAttributes tool = desc.getTool();
                if (tool == null) continue;
                newTools.add(tool);
            }
            clazz2 = DebugConnectorHook.class;
            // MONITORENTER : oracle.jdevimpl.runner.debug.DebugConnectorHook.class
            if (copySize == _debugConnectors.size()) {
                // MONITOREXIT : clazz2
                return newTools;
            }
            // MONITOREXIT : clazz2
            ++x;
        }
        return newTools;
    }

    private static Map<String, ToolDescription> primeTools(Map<String, ToolDescription> tools) {
        if (tools == null) {
            return new LinkedHashMap<String, ToolDescription>();
        }
        return tools;
    }

    private static void primeHook() {
        if (hook == null) {
            _debugConnectors = DebugConnectorHook.primeTools(_debugConnectors);
            hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hook == null) {
                return;
            }
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getCombinedHashStructure());
                }

                private void addItemsFromHook(HashStructure hashStructure) {
                    DebugConnectorHook.updateToolsFromHook(hashStructure, _debugConnectors);
                }
            });
        }
    }

    private static synchronized <T> void updateToolsFromHook(HashStructure hashStructure, Map<String, ToolDescription> knownTools) {
        List definitions = hashStructure.getAsList(DEBUG_CONNECTOR_ATTRIBUTES);
        if (definitions != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                HashStructure hash = (HashStructure)definition;
                String extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
                ToolDescription desc = new ToolDescription(extensionId, hash);
                if (!desc.isValidDescription()) continue;
                String className = desc.getClassName();
                if (!knownTools.containsKey(className)) {
                    knownTools.put(className, desc);
                    continue;
                }
                DebugConnectorHook.logDuplicateError(className, extensionId);
            }
        }
    }

    private static boolean addTool(DebugConnectorAttributes tool, Map<String, ToolDescription> knownTools) {
        String className = tool.getClass().getName();
        String id = Integer.toString(System.identityHashCode(tool));
        if (knownTools.containsKey(id)) {
            DebugConnectorHook.logError("Duplicate class, name: " + className + ", id: " + id, DEBUG_CONNECTOR_ATTRIBUTES, null);
            return false;
        }
        knownTools.put(id, new ToolDescription(className, tool));
        return true;
    }

    private static void logDuplicateError(String className, String extensionId) {
        DebugConnectorHook.logError("Duplicate class name: " + className, DEBUG_CONNECTOR_ATTRIBUTES, extensionId);
    }

    private static void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static class ToolDescription {
        private HashStructure hash;
        private String className;
        private DebugConnectorAttributes tool;
        private String extensionId;
        private boolean retrieved;

        private ToolDescription(String extensionId, HashStructure hash) {
            this.extensionId = extensionId;
            this.hash = hash;
        }

        private ToolDescription(String className, DebugConnectorAttributes tool) {
            this.className = className;
            this.tool = tool;
        }

        private boolean hasBeenRetrieved() {
            return this.retrieved;
        }

        private boolean isValidDescription() {
            return this.getClassName() != null;
        }

        private String getClassName() {
            if (this.className == null) {
                this.className = this.getStringAttribute("class");
            }
            return this.className;
        }

        private String getStringAttribute(String name) {
            if (!this.hash.containsKey(name)) {
                DebugConnectorHook.logError("Missing '" + name + "' attribute", DebugConnectorHook.DEBUG_CONNECTOR_ATTRIBUTES, this.extensionId);
            } else {
                Object object = this.hash.getObject(name);
                if (!(object instanceof String)) {
                    DebugConnectorHook.logError("Incorrectly typed '" + name + "' attribute", DebugConnectorHook.DEBUG_CONNECTOR_ATTRIBUTES, this.extensionId);
                } else {
                    return object.toString();
                }
            }
            return null;
        }

        private synchronized DebugConnectorAttributes getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = this.getClassLoader();
                MetaClass metaClass = new MetaClass(classLoader, this.getClassName());
                try {
                    this.tool = (DebugConnectorAttributes)metaClass.newInstance();
                }
                catch (Exception ex) {
                    DebugConnectorHook.logError("Failed to create instance from class " + this.getClassName(), DebugConnectorHook.DEBUG_CONNECTOR_ATTRIBUTES, this.extensionId);
                }
            }
            this.retrieved = true;
            return this.tool;
        }

        private ClassLoader getClassLoader() {
            ClassLoader loader = null;
            if (this.extensionId != null) {
                loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extensionId);
            }
            if (loader == null) {
                loader = SourceHook.class.getClass().getClassLoader();
            }
            return loader;
        }
    }
}

