/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.debug.DataBreadcrumbsTable;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSelectionTracker;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTableSwitcher;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataTreeTable;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public abstract class DataPanel
implements DragGestureListener,
ContextMenuListener,
UpdateableDataWindow {
    protected DockableWindow dockableWindow;
    private String title;
    private DataController controller;
    private DataTableSwitcher dataTable;
    private JPanel gui;
    static final String TABLE_TABLE = "TABLE_TABLE";
    static final String TREE_TABLE = "TREE_TABLE";
    private boolean skippedUpdate = true;
    private DebugVirtualMachine skippedUpdateVM;
    private DebuggingProcess skippedUpdateDebuggingProcess;
    private DebugThreadInfo skippedUpdateThreadInfo;
    private DebugStackFrameInfo skippedUpdateStackFrameInfo;
    protected boolean useFilters;
    protected boolean selectFirstRowIfNoPreviousSelection = false;
    protected DataPanelSettings dataPanelSettings;
    private StructureChangeListener settingsListener;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_VALUE = 1;
    static final int COLUMN_ACTUAL_TYPE = 2;
    static final int COLUMN_DECLARED_TYPE = 3;
    static final int COLUMN_HEX_VALUE = 4;
    static final int COLUMN_ADDRESS = 5;
    static final int COLUMN_ID = 6;
    static final int COLUMN_INSTANCE_COUNT = 7;
    static final int NUMBER_OF_COLUMNS = 8;
    protected boolean canUpdateData = true;
    private DataPanelSelectionTracker selectionTracker = new DataPanelSelectionTracker();
    private DropTargetListener dropTargetL = new DropTargetL();
    private Toolbar toolbar;
    private boolean isShowing;

    protected DataPanel(String title, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.title = title;
    }

    DataPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.dockableWindow = dockableWindow;
    }

    private DataPanel(DataPanelSettings dataPanelSettings) {
        this.dataPanelSettings = dataPanelSettings;
        this.controller = this.createController(dataPanelSettings);
        JDebugger jdebugger = JDebugger.getInstance();
        jdebugger.getContextMenu().addContextMenuListener((ContextMenuListener)this);
        this.settingsListener = new SettingsListener();
        dataPanelSettings.addStructureChangeListener(this.settingsListener);
    }

    void setShowing(boolean isShowing) {
        this.isShowing = isShowing;
    }

    boolean isShowing() {
        return this.isShowing;
    }

    String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.dockableWindow != null) {
            return this.dockableWindow.getTitleName();
        }
        return "";
    }

    protected abstract DataController createController(DataPanelSettings var1);

    public DebuggerWindowOptions.WindowId getWindowIdEnum() {
        return DebuggerWindowOptions.WindowId.NOT_CUSTOMIZABLE;
    }

    protected final DataController getController() {
        return this.controller;
    }

    protected final DataTreeTableModel getModel() {
        return this.controller.getModel();
    }

    private void createGUI() {
        HashMap<Object, DataTable> dataTableMap = new HashMap<Object, DataTable>();
        dataTableMap.put(TREE_TABLE, new DataTreeTable(this));
        dataTableMap.put(TABLE_TABLE, new DataBreadcrumbsTable(this));
        this.dataTable = new DataTableSwitcher(dataTableMap);
        this.dataTable.setCurrentDataTable(TABLE_TABLE);
        this.dataTable.dataPanelSettingsChanged(this, this.dataPanelSettings);
        this.gui = new JPanel(new BorderLayout());
        Toolbar toolbar = this.getToolbar();
        if (toolbar != null) {
            this.gui.add((Component)toolbar, "North");
        }
        this.gui.add(this.adjustGUI(this.dataTable.getGUI()), "Center");
    }

    protected Component adjustGUI(Component defaultGui) {
        return defaultGui;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.createGUI();
        }
        return this.gui;
    }

    DockableWindow getDockableWindow() {
        return this.dockableWindow;
    }

    public DebuggingProcess getDebuggingProcess() {
        return this.getModel().getDebuggingProcess();
    }

    DataTable getDataTable() {
        return this.dataTable;
    }

    private JTable getTable() {
        return this.dataTable == null ? null : this.dataTable.getTable();
    }

    void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        if (this.getTable() == null) {
            return;
        }
        this.useFilters = dbgSettings.isUseFilters();
    }

    void dataPanelSettingsChanged() {
        if (this.dataTable == null || this.dataTable.getTable() == null) {
            return;
        }
        DebugVirtualMachine vm = this.getController().getVm();
        if (vm != null) {
            String vmName = vm.getID();
            if (WindowSettingsColumnManager.getActiveDataView(this.dataPanelSettings.getHash(), vmName, this.dockableWindow.getUniqueName()) == TREE_TABLE) {
                this.dataTable.setCurrentDataTable(TREE_TABLE);
            } else {
                this.dataTable.setCurrentDataTable(TABLE_TABLE);
            }
        }
        this.dataTable.dataPanelSettingsChanged(this, this.dataPanelSettings);
        Toolbar toolbar = this.getToolbar();
        if (toolbar != null && toolbar.isVisible() != this.dataPanelSettings.isShowingToolbar()) {
            toolbar.setVisible(this.dataPanelSettings.isShowingToolbar());
        }
    }

    void selectionChanged() {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (e.getDragAction() == 1) {
            TreePath treePath;
            DataItem dataItem;
            Point pt = e.getDragOrigin();
            int row = this.getTable().rowAtPoint(pt);
            if (row == -1) {
                return;
            }
            if (this.getTable().isEditing()) {
                this.getTable().getCellEditor().stopCellEditing();
            }
            if ((dataItem = DataPanel.getDataItemForTreePath(treePath = this.dataTable.getPathForRow(row))) == null) {
                return;
            }
            DataFlavor[] transferFlavors = dataItem.canDrag(treePath);
            if (transferFlavors != null) {
                try {
                    BufferedImage dragImage = new BufferedImage(1, 1, 6);
                    dragImage.setRGB(0, 0, -16777216);
                    Point imageOffset = new Point(0, 0);
                    e.startDrag(null, dragImage, imageOffset, dataItem, new DragSourceAdapter(){});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void checkDrag(DropTargetDragEvent e) {
        e.rejectDrag();
    }

    protected void checkDrop(DropTargetDropEvent e) {
        e.rejectDrop();
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.getTable() != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.getTable()) || Helpers.contextMatchesSource(context, this.dataTable.getScrollPane()))) {
            this.getController().addPopupMenuItemsForNew(popup, context);
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                this.getController().addPopupMenuItemsForDataItem(popup, context);
            }
            this.getController().addPopupMenuItemsForData(popup, context);
            this.getController().addPopupMenuItemsForTreeTable(popup, context);
            this.getController().addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, this.dockableWindow, this.getTable());
    }

    void setSkippedUpdate(boolean updateSkipped) {
        this.skippedUpdate = updateSkipped;
        if (!updateSkipped) {
            this.skippedUpdateDebuggingProcess = null;
            this.skippedUpdateVM = null;
            this.skippedUpdateThreadInfo = null;
            this.skippedUpdateStackFrameInfo = null;
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.getTable().isEnabled()) {
            this.updateData(this.skippedUpdateDebuggingProcess, this.skippedUpdateVM, this.skippedUpdateThreadInfo, this.skippedUpdateStackFrameInfo);
        }
    }

    void setUseFilters(boolean useFilters) {
        this.useFilters = useFilters;
        DebugWindowSettings.getInstance().setUseFilters(useFilters);
        this.getController().everythingChanged();
    }

    @Override
    public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        boolean showing;
        if (this.getTable() != null) {
            this.getTable().setEnabled(true);
        }
        boolean bl = showing = this.dataTable != null && this.dataTable.getTable().isShowing();
        if (!showing) {
            this.skippedUpdateDebuggingProcess = debuggingProcess;
            this.skippedUpdateVM = vm;
            this.skippedUpdateThreadInfo = thread;
            this.skippedUpdateStackFrameInfo = frame;
            this.setSkippedUpdate(true);
            return;
        }
        if (this.gui == null) {
            this.gui = (JPanel)this.getGUI();
        }
        this.getController().updateData(debuggingProcess, vm, thread, frame);
        this.canUpdateData = true;
        if (this.getTable() != null) {
            this.getController().everythingChanged();
        }
    }

    @Override
    public void clearData() {
        this.canUpdateData = false;
        if (this.getDataTable() == null || this.getTable() == null) {
            return;
        }
        this.getTable().setEnabled(false);
        this.selectionTracker.saveSelection(this.dataTable, this.getDebuggingProcess());
        this.getController().clearData();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.selectionTracker.clearSelection();
        if (this.dataTable != null) {
            this.dataTable.removeAll(debuggingProcess);
        }
        if (this.getDebuggingProcess() == debuggingProcess) {
            this.getModel().setDebuggingProcess(null);
            this.canUpdateData = true;
            if (this.getTable() != null) {
                this.getTable().setEnabled(true);
                this.getController().everythingChanged();
            }
        }
    }

    void collapseAll() {
        this.dataTable.collapseAll();
    }

    int getNumberOfColumns() {
        DebuggerDataWindowOptions options;
        if (this.getController() != null && (options = this.getController().getDebuggerWindowOptions()) != null) {
            return options.getNumberOfColumns();
        }
        return 8;
    }

    protected String getNameOfColumn(int column) {
        if (this.getController() != null && this.getController().getDebuggerWindowOptions() != null) {
            return this.getController().getDebuggerWindowOptions().getColumnInfo(column).getColumnName();
        }
        return DataPanel.getDefaultColumnName(column);
    }

    protected static String getDefaultColumnName(int column) {
        switch (column) {
            case 0: {
                return DbgArb.getString(248);
            }
            case 2: {
                return DbgArb.getString(249);
            }
            case 3: {
                return DbgArb.getString(250);
            }
            case 1: {
                return DbgArb.getString(251);
            }
            case 4: {
                return DbgArb.getString(252);
            }
            case 5: {
                return DbgArb.getString(253);
            }
            case 6: {
                return DbgArb.getString(254);
            }
            case 7: {
                return DbgArb.getString(255);
            }
        }
        return "INVALID_COLUMN";
    }

    protected List<Integer> getDataTipModelIndices() {
        ArrayList<Integer> dataTipModelIndexList = new ArrayList<Integer>();
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int i = column.getModelIndex();
            dataTipModelIndexList.add(i);
        }
        return dataTipModelIndexList;
    }

    TableColumn getColumnByModelIndex(int modelIndex) {
        if (this.getTable() == null) {
            return null;
        }
        TableColumnModel tcm = this.getTable().getColumnModel();
        if (tcm == null) {
            return null;
        }
        Enumeration<TableColumn> columnEnum = tcm.getColumns();
        while (columnEnum.hasMoreElements()) {
            TableColumn tc = columnEnum.nextElement();
            if (tc.getModelIndex() != modelIndex) continue;
            return tc;
        }
        return null;
    }

    protected void addTopDataItem(DataItem dataItem) {
        this.addTopDataItem(dataItem, true);
    }

    protected void addTopDataItem(DataItem dataItem, boolean selection) {
        if (!selection) {
            this.selectionTracker.saveSelection(this.dataTable, this.getDebuggingProcess());
        }
        int i = this.getModel().getRoot().size();
        this.getModel().addTopDataItem(dataItem);
        if (selection) {
            this.selectTopDataItem(i);
        } else {
            this.selectionTracker.restoreSelection(this.dataTable, this.getModel(), false, this.selectFirstRowIfNoPreviousSelection);
        }
    }

    protected void removeTopDataItem(int i) {
        this.selectionTracker.saveSelection(this.dataTable, this.getDebuggingProcess());
        this.getModel().removeTopDataItem(i);
        this.selectionTracker.restoreSelection(this.dataTable, this.getModel(), false, this.selectFirstRowIfNoPreviousSelection);
    }

    protected void selectTopDataItem(int i) {
        Object root;
        Object[] path = new Object[2];
        path[0] = root = this.getModel().getRoot();
        if (root.size() == 0) {
            return;
        }
        try {
            path[1] = root.size() < i + 1 ? root.get(root.size() - 1) : root.get(i);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return;
        }
        TreePath treePath = new TreePath(path);
        DataTableUtils.selectTreeTablePath((DataTable)this.dataTable, treePath, true);
    }

    protected void selectTopDataItem(String expression) {
        Object root = this.getModel().getRoot();
        try {
            for (int i = 0; i < root.size(); ++i) {
                if (!((DataItem)root.get(i)).getDisplayName().equals(expression)) continue;
                this.selectTopDataItem(i);
                return;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            return;
        }
    }

    TreePath getSelectedTreePath() {
        return this.dataTable.getSelectionPath();
    }

    DataItem getSelectedDataItem() {
        if (this.getTable() != null) {
            return DataPanel.getDataItemForTreePath(this.getSelectedTreePath());
        }
        return null;
    }

    DataItem getDataItemForRow(int row) {
        TreePath treePath = this.dataTable.getPathForRow(row);
        if (treePath != null) {
            return DataPanel.getDataItemForTreePath(treePath);
        }
        return null;
    }

    static final DataItem getDataItemForTreePath(TreePath treePath) {
        Object node;
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof DataItem) {
            return (DataItem)node;
        }
        return null;
    }

    void saveSelection() {
        this.selectionTracker.saveSelection(this.dataTable, this.getDebuggingProcess());
    }

    void restoreSelection(boolean scrollToVisible) {
        try {
            this.selectionTracker.restoreSelection(this.dataTable, this.getModel(), scrollToVisible, this.selectFirstRowIfNoPreviousSelection);
        }
        catch (DataExpiredException dataExpiredException) {
            // empty catch block
        }
    }

    final DropTargetListener getDropTargetListener() {
        return this.dropTargetL;
    }

    Toolbar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = this.createToolbar();
            if (this.toolbar != null) {
                this.toolbar.setVisible(this.dataPanelSettings.isShowingToolbar());
            }
        }
        return this.toolbar;
    }

    protected Toolbar createToolbar() {
        return null;
    }

    protected void setDataTableView(Object dataTableKey) {
        this.dataTable.setCurrentDataTable(dataTableKey);
    }

    private class SettingsListener
    extends StructureChangeListener {
        private SettingsListener() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            if (Utils.structureReallyChanged(e)) {
                DataPanel.this.dataPanelSettingsChanged();
                if (DataPanel.this.dataTable != null && DataPanel.this.dataTable.getTable().isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DataPanel.this.getController().everythingChanged();
                        }
                    });
                }
            }
        }
    }

    private class DropTargetL
    extends DropTargetAdapter {
        DropTargetL() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            DataPanel.this.checkDrag(e);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            DataPanel.this.checkDrag(e);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            DataPanel.this.checkDrop(e);
        }
    }
}

