/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;

abstract class DataCellEditor
extends AbstractTableCellEditor
implements Controller {
    protected final DataPanel dataPanel;
    private int lastRowRendered;

    DataCellEditor(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        this.lastRowRendered = -1;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastRowRendered = row;
        DataItem dataItem = this.dataPanel.getDataItemForRow(row);
        return this.getTableCellEditorComponent(table, value, isSelected, dataItem);
    }

    protected abstract Component getTableCellEditorComponent(JTable var1, Object var2, boolean var3, DataItem var4);

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    protected final DataItem getCurrentDataItem() {
        DataItem dataItem = this.dataPanel.getSelectedDataItem();
        if (dataItem != null) {
            return dataItem;
        }
        if (this.lastRowRendered >= 0) {
            return this.dataPanel.getDataItemForRow(this.lastRowRendered);
        }
        return null;
    }
}

