/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.builders.BreadcrumbsTableBuilder;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;

class DataBreadcrumbMaker
implements BreadcrumbsTableBuilder.BreadcrumbMaker {
    private DataPanel dataPanel;
    private static final Font boldFont = UIManager.getFont("Label.font").deriveFont(1);

    public DataBreadcrumbMaker(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
    }

    public BreadcrumbsTableBuilder.TableBreadcrumb createBreadcrumb(Object node) {
        DataTableBreadcrumb crumb = new DataTableBreadcrumb(node);
        return crumb;
    }

    class DataTableBreadcrumb
    implements BreadcrumbsTableBuilder.TableBreadcrumb {
        private Object node;

        private DataTableBreadcrumb(Object node) {
            this.node = node;
        }

        public Object getUserObject() {
            return this.node;
        }

        public StyledTextModel getShortName() {
            String text = this.node.equals(DataBreadcrumbMaker.this.dataPanel.getModel().getRoot()) ? "" : this.node.toString();
            StyledTextAttribute attr = new StyledTextAttribute(boldFont, null);
            StyledTextModel textModel = new StyledTextModel(text, attr);
            return textModel;
        }

        public StyledTextModel getLongName() {
            return this.getShortName();
        }

        public boolean hasChildren() {
            return !DataBreadcrumbMaker.this.dataPanel.getModel().isLeaf(this.node);
        }

        List<PopupItem> getChildren() {
            ArrayList<PopupItem> list = new ArrayList<PopupItem>();
            Iterator<DataItem> it = DataBreadcrumbMaker.this.dataPanel.getModel().getChildren(this.node);
            while (it.hasNext()) {
                DataItem item = it.next();
                if (DataBreadcrumbMaker.this.dataPanel.getModel().isLeaf(item)) continue;
                PopupItem popupItem = new PopupItem();
                popupItem.setName(item.getDisplayName());
                popupItem.setIcon(item.getIcon());
                popupItem.setUserObject((Object)item);
                popupItem.setBreadcrumb((Breadcrumb)this);
                list.add(popupItem);
            }
            return list;
        }
    }
}

