/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.plugin.evaluator;

import java.util.HashMap;
import java.util.Map;
import oracle.jdeveloper.debugger.evaluator.EvaluatorContext;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class PluginEvaluatorContext
implements EvaluatorContext {
    private DebugVirtualMachine vm;
    private DebugThreadInfo thread;
    private DebugStackFrameInfo frame;
    private DebugDataObjectInfo dataObject;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public boolean setDebugContext(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (this.vm != vm || this.thread != thread || this.frame != frame || this.dataObject != null) {
            this.vm = vm;
            this.thread = thread;
            this.frame = frame;
            this.dataObject = null;
            this.clearVariables();
            return true;
        }
        return false;
    }

    public boolean setDebugContext(DebugDataObjectInfo dataObject) {
        DebugVirtualMachine vm = dataObject.getVM();
        if (this.vm != vm || this.thread != null || this.frame != null || this.dataObject != dataObject) {
            this.vm = vm;
            this.thread = null;
            this.frame = null;
            this.dataObject = dataObject;
            this.clearVariables();
            return true;
        }
        return false;
    }

    void clearVariables() {
        this.variables.clear();
    }

    void addVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    void removeVariable(String name) {
        this.variables.remove(name);
    }

    Map<String, Object> getVariables() {
        return this.variables;
    }

    DebugDataObjectInfo getDataObject() {
        return this.dataObject;
    }

    @Override
    public DebugVirtualMachine getVM() {
        return this.vm;
    }

    @Override
    public DebugStackFrameInfo getFrame() {
        return this.frame;
    }

    @Override
    public DebugThreadInfo getThread() {
        return this.thread;
    }
}

