/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import oracle.ide.insight.InsightItem;
import oracle.ide.insight.filter.CamelCaseInsightSorter;
import oracle.ide.insight.filter.InsightSorter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class JavaInsightOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "JavaInsightOptions";
    private static final String BOLDDECLAREDMEMBERSOPTION = "boldDeclaredMembersOption";
    private static final String ITALICLOCALVARIABLESOPTION = "italicLocalVariablesOption";
    private static final String SHOWTOPLEVELPACKAGESOPTION = "showTopLevelPackagesOption";
    private static final String SHOWIMPORTEDCLASSESOPTION = "showImportedClassesOption";
    private static final String SHOWOBJECTMETHODSOPTION = "showObjectMethodsOption";
    private static final String SHOWDEFININGCLASSOPTION = "showDefiningClassOption";
    private static final String AUTOIMPORTOPTION = "autoImportOption";
    private static final String SHOWDEPRECATEDOPTION = "showDeprecatedOption";
    private static final String STRIKETHRUDEPRECATEDOPTION = "strikethruDeprecatedOption";
    private static final String SHOWACCESSICONSOPTION = "showAccessIconsOption";
    private static final String INSERTPARAMETERVALUES = "insertParameterValues";
    private static CamelCaseInsightSorter<InsightItem> camelCaseInsightInputSorter = new CamelCaseInsightSorter();
    private static final String DEFAULT_DETAIL_TAB = "filterByContains";
    private static final String SHOW_METHOD_DEFINITIONS = "showMethodDefinitons";

    public JavaInsightOptions() {
        super(HashStructure.newInstance());
    }

    private JavaInsightOptions(HashStructure hash) {
        super(hash);
    }

    public static JavaInsightOptions getInstance(PropertyStorage prefs) {
        return new JavaInsightOptions(JavaInsightOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public boolean getBoldDeclaredMembers() {
        return this._hash.getBoolean(BOLDDECLAREDMEMBERSOPTION, true);
    }

    public boolean getItalicLocalVariables() {
        return this._hash.getBoolean(ITALICLOCALVARIABLESOPTION, true);
    }

    public boolean getShowTopLevelPackages() {
        return this._hash.getBoolean(SHOWTOPLEVELPACKAGESOPTION, false);
    }

    public boolean getShowImportedClasses() {
        return this._hash.getBoolean(SHOWIMPORTEDCLASSESOPTION, true);
    }

    public boolean getShowObjectMethods() {
        return this._hash.getBoolean(SHOWOBJECTMETHODSOPTION, true);
    }

    public boolean getShowDefiningClass() {
        return this._hash.getBoolean(SHOWDEFININGCLASSOPTION, false);
    }

    public boolean getAutoImport() {
        return this._hash.getBoolean(AUTOIMPORTOPTION, true);
    }

    public boolean getShowDeprecated() {
        return this._hash.getBoolean(SHOWDEPRECATEDOPTION, true);
    }

    public boolean getStrikethruDeprecated() {
        return this._hash.getBoolean(STRIKETHRUDEPRECATEDOPTION, true);
    }

    public boolean getShowAccessIcons() {
        return this._hash.getBoolean(SHOWACCESSICONSOPTION, true);
    }

    public boolean getInsertParameterValues() {
        return this._hash.getBoolean(INSERTPARAMETERVALUES, true);
    }

    public InsightSorter<InsightItem> getSorter() {
        return camelCaseInsightInputSorter;
    }

    public String getDefaultDetailTab() {
        return this._hash.getString(DEFAULT_DETAIL_TAB);
    }

    public boolean getShowMethodDefinitions() {
        return this._hash.getBoolean(SHOW_METHOD_DEFINITIONS, true);
    }
}

