/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.debugger.support;

public class DebuggerWindowColumnOptions {
    private final String columnName;
    private final String columnNameInPrefencePane;
    private final boolean numeric;
    private final boolean visibleInTree;
    private final boolean visibleInTable;
    private final int orderInTree;
    private final int orderInTable;

    public DebuggerWindowColumnOptions(String name, boolean isNumeric, boolean isVisible) {
        this(name, null, isNumeric, isVisible, isVisible, -1, -1);
    }

    public DebuggerWindowColumnOptions(String name, String nameInPrefPane, boolean isNumeric, boolean isVisible) {
        this(name, nameInPrefPane, isNumeric, isVisible, isVisible, -1, -1);
    }

    public DebuggerWindowColumnOptions(String name, String nameInPrefPane, boolean isNumeric, boolean isVisibleInTree, boolean isVisibleInTable, int treeOrder, int tableOrder) {
        this.columnName = name;
        this.columnNameInPrefencePane = nameInPrefPane;
        this.numeric = isNumeric;
        this.visibleInTree = isVisibleInTree;
        this.visibleInTable = isVisibleInTable;
        this.orderInTree = treeOrder;
        this.orderInTable = tableOrder;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isVisibleInTreeViewByDefault() {
        return this.visibleInTree;
    }

    public boolean isVisibleByDefault() {
        return this.visibleInTable;
    }

    public int getOrderInTree() {
        return this.orderInTree;
    }

    public int getOrderInTable() {
        return this.orderInTable;
    }

    public String getColumnNameInPrefencePane() {
        if (this.columnNameInPrefencePane != null) {
            return this.columnNameInPrefencePane;
        }
        return this.columnName;
    }
}

