/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DigestRandomBitsSource;
import oracle.security.crypto.core.MD5RandomBitsSource;
import oracle.security.crypto.core.SHA1RandomBitsSource;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.DSIGInitializer;
import oracle.security.xmlsec.util.DocOrderComparator;
import oracle.security.xmlsec.util.ENCInitializer;
import oracle.security.xmlsec.util.IDCache;
import oracle.security.xmlsec.util.NodeSetReader;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final String PROPERTY_USE_JSR105 = "osdt.useJSR105";
    public static final String PROPERTY_USE_JSR106 = "osdt.useJSR106";
    public static final String PROPERTY_USE_OLD_C14N = "osdt.useOldC14n";
    public static final String PROPERTY_USE_LINE_BREAKS = "osdt.useLineBreaks";
    public static final String PROPERTY_C14N_NS_FILTERED_OUT = "osdt.c14nNsFilteredOut";
    public static final String PROPERTY_C14N_PARSER = "osdt.c14nParser";
    public static final String PROPERTY_C14N_SPARSE_THRESHOLD = "osdt.c14nSparseThreshold";
    public static final String PROPERTY_USE_MTOM = "osdt.useMTOM";
    public static final String PROPERTY_DEBUG_VERIFY = "xml.debug.verify";
    public static final String PROPERTY_USE_EXPLICIT_C14N11 = "osdt.useExcplitC14n11";
    public static final String PROPERTY_MAX_TRANSFORMS = "osdt.max.transforms";
    public static final String PROPERTY_ALLOW_EXTERNAL_REF = "osdt.allow.externalRef";
    public static final String PROPERTY_ALLOW_XSLT_TRANSFORM = "osdt.allow.XSLTTransform";
    public static final String PROPERTY_ALLOW_ALL = "osdt.allow.all";
    public static final String PROPERTY_ALLOW_UNVALIDATED_CERT = "osdt.allow.unvalidatedCert";
    public static final String PROPERTY_ALLOW_RETRIEVAL_METHOD = "osdt.allow.retrievalMethod";
    public static final String PROPERTY_DISABLE_ID_CACHING = "osdt.disable.idCaching";
    public static final String FIPS_140_2_MODE_SYSTEM_PROPERTY = "FIPS_140_2_MODE";
    private static DocumentBuilderFactory docBuilderFactory;
    private static final Object docBuilderFactoryLock;
    private static int MAX_TRANSFORMS_DEFAULT;
    private static DocumentBuilder docBuilder;
    private static final Object docBuilderLock;
    private static TransformerFactory transformerFactory;
    private static final Object transformerFactoryLock;
    private static final String[] typeNames;
    private static final boolean xmlDebugNode;
    private static DigestRandomBitsSource nonCryptoRBS;
    private static final Object nonCryptoRBSLock;
    private static final ConcurrentHashMap idAttrMap;
    private static DocumentNavigator docNavigator;

    public static int getMaxTrans() {
        int maxTrans = MAX_TRANSFORMS_DEFAULT;
        String maxTransStr = System.getProperty(PROPERTY_MAX_TRANSFORMS);
        if (maxTransStr != null) {
            try {
                maxTrans = Integer.parseInt(maxTransStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Wrong format for osdt.max.transforms, (it should be an integer):" + maxTransStr);
            }
        }
        return maxTrans;
    }

    public static boolean getXSLTFlag() {
        return System.getProperty(PROPERTY_ALLOW_XSLT_TRANSFORM) != null || System.getProperty(PROPERTY_ALLOW_ALL) != null;
    }

    public static boolean getExternalRefFlag() {
        return System.getProperty(PROPERTY_ALLOW_EXTERNAL_REF) != null || System.getProperty(PROPERTY_ALLOW_ALL) != null;
    }

    public static boolean getAllowUnvalidatedCertFlag() {
        return System.getProperty(PROPERTY_ALLOW_UNVALIDATED_CERT) != null || System.getProperty(PROPERTY_ALLOW_ALL) != null;
    }

    public static boolean getAllowRetrievalMethodFlag() {
        return System.getProperty(PROPERTY_ALLOW_RETRIEVAL_METHOD) != null || System.getProperty(PROPERTY_ALLOW_ALL) != null;
    }

    public static boolean getAllowAllFlag() {
        return System.getProperty(PROPERTY_ALLOW_ALL) != null;
    }

    private static boolean getFIPSmodeSystemProperty() {
        boolean isFips_140_2_Mode = false;
        String isFips_140_2_ModeString = null;
        try {
            isFips_140_2_ModeString = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(XMLUtils.FIPS_140_2_MODE_SYSTEM_PROPERTY);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        if (null != isFips_140_2_ModeString) {
            isFips_140_2_Mode = Boolean.valueOf(isFips_140_2_ModeString);
        }
        return isFips_140_2_Mode;
    }

    public static DocumentBuilder createDocBuilder() {
        if (docBuilderFactory != null) {
            try {
                return docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        Object object = docBuilderFactoryLock;
        synchronized (object) {
            if (docBuilderFactory == null) {
                docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
            }
            try {
                return docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocument() {
        Object object = docBuilderLock;
        synchronized (object) {
            if (docBuilder == null) {
                docBuilder = XMLUtils.createDocBuilder();
            }
            return docBuilder.newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransformerFactory getTransformerFactory(Node n) {
        if (transformerFactory == null) {
            Object object = transformerFactoryLock;
            synchronized (object) {
                if (transformerFactory == null) {
                    transformerFactory = TransformerFactory.newInstance();
                }
            }
        }
        return transformerFactory;
    }

    public static Transformer createTransformer(Node n) {
        try {
            return XMLUtils.getTransformerFactory(n).newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Transformer createTransformer() {
        return XMLUtils.createTransformer((Node)null);
    }

    public static Transformer createTransformer(Source s) {
        return XMLUtils.createTransformer(null, s);
    }

    public static Transformer createTransformer(Node n, Source s) {
        try {
            return XMLUtils.getTransformerFactory(n).newTransformer(s);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getNodeTypeName(short type) {
        if (type < 0 || type >= typeNames.length) {
            return typeNames[0] + "(" + type + ")";
        }
        return typeNames[type];
    }

    public static String getNodeTypeName(Node node) {
        return XMLUtils.getNodeTypeName(node.getNodeType());
    }

    public static Document getOwnerDocument(Node node) {
        short type = node.getNodeType();
        Document doc = (Document)(type == 9 ? node : node.getOwnerDocument());
        if (doc == null && type == 2) {
            doc = ((Attr)node).getOwnerElement().getOwnerDocument();
        }
        return doc;
    }

    public static String toStringNode(Node node) {
        if (node == null) {
            return "null";
        }
        short type = node.getNodeType();
        StringBuffer buf = new StringBuffer();
        buf.append(XMLUtils.getNodeTypeName(type));
        buf.append('(');
        switch (type) {
            case 2: 
            case 13: {
                buf.append(node.getNodeName());
                buf.append('=');
                buf.append(node.getNodeValue());
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: {
                buf.append(node.getNodeName());
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                String value = node.getNodeValue().replace('\n', ' ');
                if (value.length() > 32) {
                    buf.append(value.substring(0, 32));
                    buf.append("...");
                    break;
                }
                buf.append(value);
                break;
            }
            case 7: {
                buf.append(((ProcessingInstruction)node).getTarget());
                break;
            }
            default: {
                buf.append(node.getNodeName());
            }
        }
        if (xmlDebugNode) {
            switch (type) {
                case 2: {
                    buf.append(" owner=" + XMLUtils.toStringNode(((Attr)node).getOwnerElement()));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    buf.append(" parent=" + XMLUtils.toStringNode(node.getParentNode()));
                    break;
                }
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static String toStringNodes(Collection c) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Iterator it = c.iterator();
        while (it.hasNext()) {
            buf.append(XMLUtils.toStringNode((Node)it.next()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public static Node getXPathParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public static void computeAncestors(Node node, ArrayList lastNodeAncestors) {
        Node parentNode = XMLUtils.getXPathParentNode(node);
        for (int i = 1; i < 3 && lastNodeAncestors.size() >= i; ++i) {
            if (lastNodeAncestors.get(lastNodeAncestors.size() - i) != parentNode) continue;
            for (int j = 1; j < i; ++j) {
                lastNodeAncestors.remove(lastNodeAncestors.size() - 1);
            }
            lastNodeAncestors.add(node);
            return;
        }
        lastNodeAncestors.clear();
        lastNodeAncestors.add(node);
        while (parentNode != null) {
            lastNodeAncestors.add(0, parentNode);
            parentNode = XMLUtils.getXPathParentNode(parentNode);
        }
    }

    public static String toStringXML(Collection c, boolean generateDummyRoot) throws TransformerException {
        Transformer t = XMLUtils.createTransformer();
        StringWriter sw = new StringWriter();
        StreamResult res = new StreamResult(sw);
        InputSource dummy = new InputSource();
        SAXSource src = new SAXSource(new NodeSetReader(c, generateDummyRoot), dummy);
        t.transform(src, res);
        return sw.toString();
    }

    public static String toStringXML(XMLNode xmlNode, boolean indent, boolean xmlDecl) throws TransformerException {
        return XMLUtils.toStringXML(xmlNode.getNode(), indent, xmlDecl);
    }

    public static String toStringXML(Node node, boolean indent, boolean xmlDecl) throws TransformerException {
        if (node == null) {
            return "";
        }
        Transformer t = XMLUtils.createTransformer();
        t.setOutputProperty("indent", indent ? "yes" : "no");
        t.setOutputProperty("omit-xml-declaration", xmlDecl ? "no" : "yes");
        DOMSource src = new DOMSource(node);
        StringWriter sw = new StringWriter();
        StreamResult res = new StreamResult(sw);
        t.transform(src, res);
        return sw.toString();
    }

    public static byte[] toBytesXML(XMLNode xmlNode, boolean indent, boolean xmlDecl) throws TransformerException {
        return XMLUtils.toBytesXML(xmlNode.getNode(), indent, xmlDecl);
    }

    public static byte[] toBytesXML(Node node, boolean indent, boolean xmlDecl) throws TransformerException {
        if (node == null) {
            return null;
        }
        Transformer t = XMLUtils.createTransformer();
        t.setOutputProperty("indent", indent ? "yes" : "no");
        t.setOutputProperty("omit-xml-declaration", xmlDecl ? "no" : "yes");
        DOMSource src = new DOMSource(node);
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
        StreamResult res = new StreamResult((OutputStream)bos);
        t.transform(src, res);
        return bos.toByteArray();
    }

    public static void toStreamXML(OutputStream os, XMLNode xmlNode, boolean indent, boolean xmlDecl) throws TransformerException, IOException {
        XMLUtils.toStreamXML(os, xmlNode.getNode(), indent, xmlDecl);
    }

    public static void toStreamXML(OutputStream os, Node node, boolean indent, boolean xmlDecl) throws TransformerException, IOException {
        if (node == null) {
            return;
        }
        Transformer t = XMLUtils.createTransformer();
        t.setOutputProperty("indent", indent ? "yes" : "no");
        t.setOutputProperty("omit-xml-declaration", xmlDecl ? "no" : "yes");
        DOMSource src = new DOMSource(node);
        StreamResult res = new StreamResult(os);
        t.transform(src, res);
    }

    public static String readString(Reader reader) throws IOException {
        StringBuffer sBuf = new StringBuffer();
        char[] cBuf = new char[1024];
        int i = -1;
        while ((i = reader.read(cBuf)) != -1) {
            sBuf.append(cBuf, 0, i);
        }
        return sBuf.toString();
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int i = -1;
        while ((i = is.read(buf)) != -1) {
            bos.write(buf, 0, i);
        }
        return bos.toByteArray();
    }

    public static byte[] readBytes(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        byte[] buf = XMLUtils.readBytes(is);
        is.close();
        return buf;
    }

    public static String stripWS(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f' || c == '\u000b') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static List toDocumentOrderList(Collection nodes) {
        ArrayList list = new ArrayList(nodes);
        Collections.sort(list, new DocOrderComparator());
        return list;
    }

    public static XMLElement getInstance(NodeList nodes, String tag, String ns) {
        if (nodes == null || tag == null || ns == null) {
            throw new IllegalArgumentException();
        }
        XMLElement e = null;
        int y = nodes.getLength();
        for (int x = 0; x < y && e == null; ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            e = XMLUtils.getInstance((Element)node, tag, ns);
        }
        return e;
    }

    public static XMLElement getInstance(Collection nodes, String tag, String ns) {
        if (nodes == null || tag == null || ns == null) {
            throw new IllegalArgumentException();
        }
        XMLElement e = null;
        Iterator iter = nodes.iterator();
        while (e == null && iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.getNodeType() != 1) continue;
            e = XMLUtils.getInstance((Element)node, tag, ns);
        }
        return e;
    }

    public static XMLElement getInstance(Element element, String tag, String ns) {
        XMLElement result = null;
        try {
            String xsiType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String xsiLocal = null;
            String xsiNS = null;
            if (xsiType != null && xsiType.length() > 0) {
                xsiLocal = QName.getLocalPart(xsiType);
                xsiNS = QName.resolvePrefix(xsiType, element);
            }
            String nodeName = element.getNodeName();
            String tagLocal = element.getLocalName();
            String tagNS = element.getNamespaceURI();
            TagManager tagMgr = TagManager.getTagManager();
            Class<? extends XMLElement> c = null;
            if (tag != null && ns != null) {
                c = tagMgr.getClassForTag(ns, tag);
            } else {
                if (xsiNS != null && xsiLocal != null) {
                    c = tagMgr.getClassForTag(xsiNS, xsiLocal);
                }
                if (c == null && tagNS != null && tagLocal != null) {
                    c = tagMgr.getClassForTag(tagNS, tagLocal);
                }
            }
            if (c != null) {
                Constructor<? extends XMLElement> x = c.getConstructor(Element.class);
                result = x.newInstance(element);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result;
    }

    public static XMLElement getInstance(Element element, String tag) {
        return XMLUtils.getInstance(element, tag, null);
    }

    public static XMLElement getInstance(Element element) {
        return XMLUtils.getInstance(element, null, null);
    }

    public static void copyNSPrefix(Element source, Element target) throws DOMException {
        String oldPref;
        String dstURI;
        String newPref = source.getPrefix();
        if (newPref == null || newPref.length() == 0) {
            return;
        }
        String srcURI = source.getNamespaceURI();
        if ((srcURI == (dstURI = target.getNamespaceURI()) || srcURI != null && srcURI.equals(dstURI)) && ((oldPref = target.getPrefix()) == null || oldPref.length() == 0)) {
            target.setPrefix(newPref);
        }
    }

    public static String canonicalize(Node input, boolean withComments) throws CanonicalizationException {
        Canonicalizer can = Canonicalizer.getInstance(true, withComments);
        byte[] result = can.canonicalize(input);
        return Utils.fromUTF8((byte[])result);
    }

    public static String canonicalize(NodeList input, boolean withComments) throws CanonicalizationException {
        Canonicalizer can = Canonicalizer.getInstance(true, withComments);
        byte[] result = can.canonicalize(input);
        return Utils.fromUTF8((byte[])result);
    }

    public static String canonicalize(Collection nodeSet, boolean withComments) throws CanonicalizationException {
        Canonicalizer can = Canonicalizer.getInstance(true, withComments);
        byte[] result = can.canonicalize(nodeSet);
        return Utils.fromUTF8((byte[])result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String randomName() {
        if (nonCryptoRBS == null) {
            Object object = nonCryptoRBSLock;
            synchronized (object) {
                if (nonCryptoRBS == null) {
                    boolean isFips_140_2_Mode = XMLUtils.getFIPSmodeSystemProperty();
                    nonCryptoRBS = isFips_140_2_Mode ? new SHA1RandomBitsSource(false) : new MD5RandomBitsSource(false);
                    nonCryptoRBS.seed((Object)new Date());
                }
            }
        }
        return Base64.toBase64(nonCryptoRBS.randomBytes(new byte[16]), false).replace('+', '0').replace('/', '1').replace('=', '2');
    }

    public static String fixURL(String urlStr, String systemId) {
        if (urlStr == null || urlStr.length() == 0) {
            return urlStr;
        }
        try {
            new URL(urlStr);
            return urlStr;
        }
        catch (MalformedURLException malformedURLException) {
            URL baseURL = null;
            if (systemId != null) {
                try {
                    baseURL = new URL(systemId);
                }
                catch (MalformedURLException malformedURLException2) {}
            } else {
                try {
                    String dir = System.getProperty("user.dir");
                    if (dir != null) {
                        char driveLetter;
                        if ((dir = dir.replace(File.separatorChar, '/')).length() >= 2 && dir.charAt(1) == ':' && (driveLetter = Character.toUpperCase(dir.charAt(0))) >= 'A' && driveLetter <= 'Z') {
                            dir = "/" + dir;
                        }
                        if (!dir.endsWith("/")) {
                            dir = dir + "/";
                        }
                        try {
                            baseURL = new URL("file://" + dir);
                        }
                        catch (MalformedURLException malformedURLException3) {}
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (baseURL != null) {
                try {
                    return new URL(baseURL, urlStr).toString();
                }
                catch (MalformedURLException malformedURLException4) {
                    // empty catch block
                }
            }
            return urlStr;
        }
    }

    public static String fixURL(String urlStr) {
        return XMLUtils.fixURL(urlStr, null);
    }

    public static String getIdFromURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (uri.startsWith("#xpointer(id(")) {
            char c;
            String s = uri.substring("#xpointer(id(".length() + 1);
            int n = s.length();
            for (int i = 0; i < n && (c = s.charAt(i)) != '\'' && c != '\"'; ++i) {
                buf.append(c);
            }
        } else if (uri.startsWith("#")) {
            buf.append(uri.substring(1));
        }
        if (buf.length() != 0) {
            return buf.toString();
        }
        return null;
    }

    public static Element getElementById(Document doc, String id) {
        Element element = doc.getElementById(id);
        if (element != null) {
            return element;
        }
        if (IDCache.isIDCacheEnabled(doc)) {
            return IDCache.getElementById(doc, id);
        }
        return XMLUtils.findElementById(doc.getDocumentElement(), id);
    }

    private static Element findElementById(Element elem, String idValue) {
        if (XMLUtils.matchesId(elem, idValue)) {
            return elem;
        }
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element foundElem;
            if (n.getNodeType() != 1 || (foundElem = XMLUtils.findElementById((Element)n, idValue)) == null) continue;
            return foundElem;
        }
        return null;
    }

    private static boolean matchesId(Element elem, String idValue) {
        if (elem.getAttributes().getLength() == 0) {
            return false;
        }
        String elemNs = elem.getNamespaceURI();
        if (elemNs != null && (elemNs.equals("http://www.w3.org/2000/09/xmldsig#") || elemNs.equals("http://www.w3.org/2001/04/xmlenc#") ? elem.getAttribute("Id").equals(idValue) : elemNs.equals("http://www.w3.org/1999/xhtml") && elem.getAttribute("id").equals(idValue))) {
            return true;
        }
        if (elem.getAttributeNS("http://schemas.xmlsoap.org/soap/security/2000-12", "id").equals(idValue) || elem.getAttributeNS("http://schemas.xmlsoap.org/ws/2002/07/utility", "Id").equals(idValue) || elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id").equals(idValue) || elem.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id").equals(idValue) || elem.getAttribute("AssertionID").equals(idValue) || elem.getAttribute("Id").equals(idValue) || elem.getAttribute("ID").equals(idValue)) {
            return true;
        }
        for (String attrNs : idAttrMap.keySet()) {
            ArrayList v = (ArrayList)idAttrMap.get(attrNs);
            for (String attrName : v) {
                if (!elem.getAttributeNS(attrNs, attrName).equals(idValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addIdAttribute(String namespaceURI, String attrName) {
        ArrayList<String> nsList = (ArrayList<String>)idAttrMap.get(namespaceURI);
        if (nsList == null) {
            nsList = new ArrayList<String>();
        }
        if (!nsList.contains(attrName)) {
            nsList.add(attrName);
        }
        idAttrMap.put(namespaceURI, nsList);
    }

    public static Enumeration idAttributeNamespaces() {
        return idAttrMap.keys();
    }

    public static ArrayList getIdAttributes(String namespaceURI) {
        ArrayList nsList = (ArrayList)idAttrMap.get(namespaceURI);
        if (nsList == null) {
            nsList = new ArrayList();
        }
        return nsList;
    }

    public static Map getIdAttributesMap() {
        return idAttrMap;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        calendar.setTime(date);
        StringBuffer sb = new StringBuffer();
        sb.append(calendar.get(1));
        sb.append('-');
        sb.append(XMLUtils.formatDateInt(calendar.get(2) + 1));
        sb.append('-');
        sb.append(XMLUtils.formatDateInt(calendar.get(5)));
        return sb.append('Z').toString();
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        calendar.setTime(date);
        StringBuffer sb = new StringBuffer();
        int hour = calendar.get(10);
        if (calendar.get(9) == 1) {
            hour += 12;
        }
        sb.append(XMLUtils.formatDateInt(hour));
        sb.append(':');
        sb.append(XMLUtils.formatDateInt(calendar.get(12)));
        sb.append(':');
        sb.append(XMLUtils.formatDateInt(calendar.get(13)));
        return sb.append('Z').toString();
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(XMLUtils.formatDate(date));
        sb.replace(sb.length() - 1, sb.length(), "T");
        sb.append(XMLUtils.formatTime(date));
        return sb.toString();
    }

    private static String formatDateInt(int n) {
        String s = Integer.toString(n);
        if (s.length() == 2) {
            return s;
        }
        return "0" + s;
    }

    public static Date parseDateTime(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        int off = -2;
        int year = 100 * XMLUtils.parseDateInt(s, off += 2);
        year += XMLUtils.parseDateInt(s, off += 2);
        int month = XMLUtils.parseDateInt(s, off += 3);
        int day = XMLUtils.parseDateInt(s, off += 3);
        int hour = XMLUtils.parseDateInt(s, off += 3);
        int minute = XMLUtils.parseDateInt(s, off += 3);
        int second = XMLUtils.parseDateInt(s, off += 3);
        int milli = 0;
        char ch = s.charAt(off += 2);
        if (ch == '.') {
            int p = 100;
            while (off + 1 < s.length()) {
                ch = s.charAt(off + 1);
                if (ch != 'Z' && ch != '+' && ch != '-' && p > 0) {
                    milli += p * (ch - 48);
                    p /= 10;
                }
                ++off;
            }
        }
        int tzOffset = 0;
        if (off < s.length() && s.charAt(off) != 'Z') {
            int hrOff = XMLUtils.parseDateInt(s, off + 1);
            int minOff = XMLUtils.parseDateInt(s, off + 3);
            tzOffset = (hrOff * 60 + minOff) * 60 * 1000;
            if (s.charAt(off) == '-') {
                tzOffset = -tzOffset;
            }
        }
        SimpleTimeZone tz = new SimpleTimeZone(tzOffset, "");
        Calendar c = Calendar.getInstance(tz);
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, milli);
        return c.getTime();
    }

    private static int parseDateInt(String s, int offset) {
        return 10 * (s.charAt(offset) - 48) + (s.charAt(offset + 1) - 48);
    }

    public static String collectText(Node node) {
        StringBuffer buf = new StringBuffer();
        NodeList nList = node.getChildNodes();
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Node n = nList.item(i);
            if (n.getNodeType() != 3) continue;
            buf.append(((Text)n).getData());
        }
        return buf.toString();
    }

    public static String resolveNSPrefix(String prefix, Node context) {
        if (prefix != null) {
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            short type = context.getNodeType();
            if (type == 2) {
                context = ((Attr)context).getOwnerElement();
            } else if (type == 13) {
                context = context.getParentNode();
            }
            return XMLUtils.getDocumentNavigator().translateNamespacePrefixToUri(prefix, (Object)context);
        }
        return null;
    }

    public static String getNamespaceURI(Node node) {
        short type = node.getNodeType();
        if (type == 1 || type == 2) {
            String prefix = QName.getPrefixPart(node.getNodeName());
            if (type == 2 && prefix.length() == 0) {
                return null;
            }
            String nsURI = XMLUtils.resolveNSPrefix(prefix, node);
            if (nsURI != null) {
                return nsURI;
            }
            return node.getNamespaceURI();
        }
        return null;
    }

    public static NamespaceContext createNamespaceContext(Node nsContextNode) throws XPathException {
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
        if (nsContextNode != null) {
            String xpathStr = nsContextNode.getNodeType() == 9 ? "//namespace::*" : ".//namespace::*";
            List nsList = null;
            try {
                DOMXPath xpath = new DOMXPath(xpathStr);
                nsList = xpath.selectNodes((Object)nsContextNode);
            }
            catch (JaxenException ex) {
                throw new XPathException(ex);
            }
            Object[] nsArray = nsList.toArray();
            for (int i = 0; i < nsArray.length; ++i) {
                NamespaceNode ns = (NamespaceNode)nsArray[i];
                String nsPrefix = ns.getNodeName();
                if (nsPrefix == null || nsPrefix.length() <= 0) continue;
                nsContext.addNamespace(nsPrefix, ns.getNodeValue());
            }
        }
        return nsContext;
    }

    public static Map<String, String> getAncestorNamespaces(Element elem) {
        ArrayList<Element> parents = new ArrayList<Element>();
        for (Node parent = elem; parent != null && parent instanceof Element; parent = parent.getParentNode()) {
            parents.add(0, (Element)parent);
        }
        LinkedHashMap<String, String> nsMap = new LinkedHashMap<String, String>();
        for (Element p : parents) {
            NamedNodeMap attrs = p.getAttributes();
            if (attrs == null) continue;
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getNodeName();
                if (name.equals("xmlns")) {
                    nsMap.put("", attr.getNodeValue());
                    continue;
                }
                if (!name.startsWith("xmlns:")) continue;
                nsMap.put(name.substring(6), attr.getNodeValue());
            }
        }
        return nsMap;
    }

    public static void removeChildren(Element parent, String ns, String tag) {
        NodeList nList = XMLElement.getChildElementsByTagNameNS(parent, ns, tag);
        for (int i = nList.getLength(); i > 0; --i) {
            parent.removeChild(nList.item(i - 1));
        }
    }

    public static void insertChild(XMLElement parent, XMLElement child, String[] ns, String[] tag, int pos) throws DOMException {
        XMLUtils.insertChild((Element)parent.getNode(), (Element)child.getNode(), ns, tag, pos);
    }

    public static void insertChild(Element parent, Element child, String[] ns, String[] tag, int pos) throws DOMException {
        Node after = null;
        if (tag != null && ns != null) {
            if (tag.length != ns.length) {
                throw new IllegalArgumentException("Tag list and namespace list must correspond");
            }
            for (int i = pos; i >= 0 && after == null; --i) {
                NodeList nList = XMLElement.getChildElementsByTagNameNS(parent, ns[i], tag[i]);
                if (nList.getLength() <= 0) continue;
                after = nList.item(nList.getLength() - 1);
            }
        } else if (tag == null ^ ns == null) {
            throw new IllegalArgumentException("Tag list and namespace list must correspond");
        }
        Node before = null;
        before = after != null ? after.getNextSibling() : parent.getFirstChild();
        if (before != null) {
            parent.insertBefore(child, before);
        } else {
            parent.appendChild(child);
        }
    }

    public static void insertChild(Element parent, Element child, String[] namespaces, String[] localNames) throws DOMException {
        String childNS = XMLUtils.getNamespaceURI(child);
        if (childNS == null) {
            throw new DOMException(14, "Could not resolve namespace for child element");
        }
        String childTag = QName.getLocalPart(child.getNodeName());
        Node after = null;
        Node before = null;
        if (localNames != null && namespaces != null) {
            if (localNames.length != namespaces.length) {
                throw new IllegalArgumentException("Lists of local names and namespaces must correspond");
            }
            int pos = -1;
            for (int i = namespaces.length - 1; i >= 0 && after == null; --i) {
                NodeList nList;
                String ns = namespaces[i];
                String tag = localNames[i];
                if (childNS.equals(ns) && childTag.equals(tag)) {
                    pos = i;
                }
                if (pos == -1 || (nList = XMLElement.getChildElementsByTagNameNS(parent, ns, tag)).getLength() <= 0) continue;
                after = nList.item(nList.getLength() - 1);
            }
            if (pos == -1) {
                throw new DOMException(3, "Element with local name \"" + childTag + "\" and namespace \"" + childNS + "is not a valid child element for the given parent.");
            }
        } else if (localNames == null ^ namespaces == null) {
            throw new IllegalArgumentException("Lists of local names and namespaces must correspond");
        }
        if ((before = after != null ? after.getNextSibling() : parent.getFirstChild()) != null) {
            parent.insertBefore(child, before);
        } else {
            parent.appendChild(child);
        }
    }

    public static Element insertChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, String text, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)contextElement.getNode(), child);
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)contextElement.getNode(), namespaceURI, localName);
        }
        XMLUtils.insertChild((Element)contextElement.getNode(), child, namespaceURIs, localNames);
        return child;
    }

    public static void insertChild(XMLElement parent, XMLElement child, String[] namespaces, String[] localNames) throws DOMException {
        XMLUtils.insertChild((Element)parent.getNode(), (Element)child.getNode(), namespaces, localNames);
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element createElement(Document doc, String tag, String nsURI, String prefix) {
        String qName = prefix == null ? tag : prefix + ":" + tag;
        Element elem = doc.createElementNS(nsURI, qName);
        if (prefix != null) {
            elem.setPrefix(prefix);
        }
        return elem;
    }

    public static String getAttributeValue(Element elem, String name) {
        Attr attr = elem.getAttributeNodeNS(null, name);
        return attr == null ? null : attr.getValue();
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling;
        for (sibling = node.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public static void removeAllChildren(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            node.removeChild(children.item(i));
        }
    }

    public static String removeWhiteSpaces(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, " \n\r\t", false);
        StringBuffer svBuf = new StringBuffer(str.length());
        while (tokenizer.hasMoreElements()) {
            svBuf.append(tokenizer.nextToken());
        }
        return svBuf.toString();
    }

    public static byte[] decodeDEROctets(byte[] der) {
        int pos;
        if (der == null || der.length < 2 || der[0] != 4) {
            return null;
        }
        int length = 0;
        if ((der[1] & 0x80) == 0) {
            length = der[1];
            pos = 2;
        } else {
            for (pos = 2; pos < 2 + (der[1] & 0x7F); ++pos) {
                length = (length << 8) + der[pos];
            }
        }
        if (der.length - pos < length) {
            length = der.length - pos;
        }
        byte[] octets = new byte[length];
        System.arraycopy(der, 2, octets, 0, length);
        return octets;
    }

    public static byte[] getSKI(X509Certificate cert) {
        byte[] derSki = cert.getExtensionValue("2.5.29.14");
        return XMLUtils.decodeDEROctets(XMLUtils.decodeDEROctets(derSki));
    }

    public static void indent(Element elem, String indent) {
        String newIndent = indent + "  ";
        Document doc = elem.getOwnerDocument();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getPreviousSibling() != null && node.getPreviousSibling().getNodeType() == 3) continue;
            Text textNode = doc.createTextNode(newIndent);
            elem.insertBefore(textNode, node);
            XMLUtils.indent((Element)node, newIndent);
        }
        if (elem.getLastChild() == null || elem.getLastChild().getNodeType() != 3) {
            Text textNode = doc.createTextNode(indent);
            elem.appendChild(textNode);
        }
    }

    public static void setProperty(String name, String value) {
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static URI transformReference(URI Base, URI R) throws URISyntaxException {
        String path;
        if (R.getScheme() != null) {
            return new URI(R.getScheme(), R.getAuthority(), XMLUtils.removeDotSegments(R.getPath()), R.getQuery());
        }
        if (R.getAuthority() != null) {
            return new URI(Base.getScheme(), R.getAuthority(), XMLUtils.removeDotSegments(R.getPath()), R.getQuery());
        }
        if (R.getPath() == null || R.getPath().equals("")) {
            if (R.getQuery() != null) {
                return new URI(Base.getScheme(), Base.getAuthority(), Base.getPath(), R.getQuery());
            }
            return new URI(Base.getScheme(), Base.getAuthority(), Base.getPath(), Base.getQuery());
        }
        if (R.getPath().startsWith("/")) {
            return new URI(Base.getScheme(), Base.getAuthority(), XMLUtils.removeDotSegments(R.getPath()), R.getQuery());
        }
        if (Base.getAuthority() != null && (Base.getPath() == null || Base.getPath().equals(""))) {
            path = "/" + R.getPath();
        } else {
            int i = -1;
            path = Base.getPath();
            if (path == null) {
                path = "";
            }
            if (path.equals("..") || path.endsWith("/..")) {
                path = path + "/";
            }
            path = (i = path.lastIndexOf(47)) == -1 ? R.getPath() : path.substring(0, i + 1) + R.getPath();
        }
        return new URI(Base.getScheme(), Base.getAuthority(), XMLUtils.removeDotSegments(path), R.getQuery());
    }

    public static String joinXmlBaseURI(ArrayList xmlBaseUriList) throws URISyntaxException {
        Iterator i = xmlBaseUriList.iterator();
        URI base = new URI((String)i.next());
        while (i.hasNext()) {
            URI u = new URI((String)i.next());
            base = XMLUtils.transformReference(base, u);
        }
        return base.toString();
    }

    public static String removeDotSegments(String inp) {
        String[] segments = inp.split("/", -1);
        LinkedList<String> segmentStack = new LinkedList<String>();
        int lastDirectoryIndex = -1;
        int ndotdots = 0;
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].length() == 0 || segments[i].equals(".")) continue;
            if (segments[i].equals("..")) {
                if (segmentStack.size() > 0) {
                    segmentStack.removeLast();
                    continue;
                }
                ++ndotdots;
                continue;
            }
            segmentStack.addLast(segments[i]);
            boolean isDirectory = i < segments.length - 1;
            lastDirectoryIndex = isDirectory ? segmentStack.size() - 1 : segmentStack.size() - 2;
        }
        StringBuffer outp = new StringBuffer();
        if (inp.startsWith("/")) {
            outp.append('/');
            if (ndotdots > 0) {
                return "/";
            }
        }
        for (int i = 0; i < ndotdots; ++i) {
            outp.append("../");
        }
        Iterator i = segmentStack.iterator();
        while (i.hasNext()) {
            String seg = (String)i.next();
            outp.append(seg);
            if (!i.hasNext()) continue;
            outp.append("/");
        }
        if (segmentStack.size() > 0 && segmentStack.size() - 1 <= lastDirectoryIndex) {
            outp.append("/");
        }
        return outp.toString();
    }

    public static String escapeTextNode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer buf = null;
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '&' || c[i] == '<' || c[i] == '>' || c[i] == '\r') {
                if (buf == null) {
                    buf = new StringBuffer(c.length);
                    buf.append(c, 0, i);
                }
                if (c[i] == '&') {
                    buf.append("&amp;");
                    continue;
                }
                if (c[i] == '<') {
                    buf.append("&lt;");
                    continue;
                }
                if (c[i] == '>') {
                    buf.append("&gt;");
                    continue;
                }
                if (c[i] != '\r') continue;
                buf.append("&#xD;");
                continue;
            }
            if (buf == null) continue;
            buf.append(c[i]);
        }
        if (buf == null) {
            return text;
        }
        return buf.toString();
    }

    public static Object resolveReference(ObjectReference ref) throws ReferenceException, AlgorithmIdentifierException, TransformationException {
        XMLContainer data = ObjectReference.dereference(ref.getURI(), ref.getOwnerDocument(), ref.getElement(), ref.getSystemId());
        if (data.subTreeAvailable()) {
            XSAlgorithmIdentifier transform;
            Vector transformList = ref.getTransforms();
            int size = transformList.size();
            if (size > 0 && ((transform = (XSAlgorithmIdentifier)transformList.elementAt(size - 1)).getAlgorithm().equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || transform.getAlgorithm().equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || transform.getAlgorithm().equals("http://www.w3.org/2001/10/xml-exc-c14n#") || transform.getAlgorithm().equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
                --size;
            }
            for (int i = 0; i < size; ++i) {
                XSAlgorithmIdentifier transform2 = (XSAlgorithmIdentifier)transformList.elementAt(i);
                XSTransformer tran = XSTransformer.getInstance(transform2);
                if (transform2.getAlgorithm().equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || transform2.getAlgorithm().equals("http://www.w3.org/2002/06/xmldsig-filter2") || transform2.getAlgorithm().equals("http://www.w3.org/2002/07/decrypt#XML") || transform2.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                    data = tran.transform(data);
                    continue;
                }
                if (transform2.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#base64")) {
                    if (i != size - 1) {
                        throw new TransformationException("Base64DecodeTransform should be the last transform");
                    }
                    data = tran.transform(data);
                    continue;
                }
                throw new TransformationException("This transformation is not allowed" + transform2.getAlgorithm());
            }
            try {
                if (data.subTreeAvailable()) {
                    return data.getSubTree();
                }
                if (data.nodeSetAvailable()) {
                    return data.getNodeSet();
                }
                if (data.octetsAvailable()) {
                    return XMLUtils.readBytes(data.getOctetStream());
                }
                throw new ReferenceException("Internal error, either subtree, nodeset, or octets must be available");
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
            catch (SAXException ex) {
                throw new ReferenceException(ex);
            }
            catch (XPathException ex) {
                throw new ReferenceException(ex);
            }
        }
        return ref.getURI();
    }

    public static List resolveReferences(XSSignature sig) throws ReferenceException, AlgorithmIdentifierException, TransformationException {
        Vector refs = sig.getSignedInfo().getReferences();
        ArrayList<Object> resolvedObjects = new ArrayList<Object>(refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            resolvedObjects.add(i, XMLUtils.resolveReference((ObjectReference)refs.get(i)));
        }
        return resolvedObjects;
    }

    public static DocumentNavigator getDocumentNavigator() {
        if (docNavigator == null) {
            docNavigator = new DocumentNavigator();
        }
        return docNavigator;
    }

    static {
        docBuilderFactoryLock = new Object();
        MAX_TRANSFORMS_DEFAULT = 5;
        docBuilderLock = new Object();
        transformerFactoryLock = new Object();
        typeNames = new String[]{"unknown", "Element", "Attr", "Text", "CDATA", "EntityRef", "Entity", "ProcInstr", "Comment", "Document", "DocType", "DocFragment", "Notation", "Namespace"};
        xmlDebugNode = System.getProperty("xml.debug.node") != null;
        nonCryptoRBSLock = new Object();
        idAttrMap = new ConcurrentHashMap();
        DSIGInitializer.initialize();
        ENCInitializer.initialize();
    }
}

