/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import javax.xml.transform.TransformerException;
import oracle.security.xmlsec.util.GenericXMLElement;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLNode {
    protected Node node;
    protected String systemId;

    protected XMLNode(Node node) throws DOMException {
        this(node, null);
    }

    protected XMLNode(Node node, String systemId) throws DOMException {
        Class<? extends XMLElement> c;
        String tagNS;
        String tagLocal;
        short nodeType = node.getNodeType();
        String xsiType = null;
        String xsiLocal = null;
        String xsiNS = null;
        if (nodeType == 1 && (xsiType = ((Element)node).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null && xsiType.length() > 0) {
            xsiLocal = QName.getLocalPart(xsiType);
            xsiNS = QName.resolvePrefix(xsiType, node);
        }
        String nodeName = node.getNodeName();
        if (nodeType == 1) {
            tagLocal = node.getLocalName();
            tagNS = node.getNamespaceURI();
        } else {
            tagLocal = QName.getLocalPart(nodeName);
            tagNS = XMLUtils.getNamespaceURI(node);
        }
        boolean xsiOK = false;
        if (xsiLocal != null && xsiNS != null && (c = TagManager.getTagManager().getClassForTag(xsiNS, xsiLocal)) != null && c.isAssignableFrom(this.getClass())) {
            xsiOK = true;
        }
        boolean tagOK = false;
        if (tagLocal != null && tagNS != null) {
            Class<? extends XMLElement> c2 = TagManager.getTagManager().getClassForTag(tagNS, tagLocal);
            if (c2 != null && c2.isAssignableFrom(this.getClass())) {
                tagOK = true;
            }
        } else if (tagLocal != null && nodeType != 1 && nodeType != 2 && !(this instanceof XMLElement)) {
            tagOK = true;
        }
        if (!(xsiOK || tagOK || GenericXMLElement.class.isAssignableFrom(this.getClass()))) {
            throw new DOMException(9, "<" + nodeName + (xsiLocal != null ? " xsi:type=\"" + xsiType + "\"" : "") + "/> invalid for instance of " + this.getClass().getName());
        }
        this.node = node;
        this.systemId = systemId;
    }

    public Node getNode() {
        return this.node;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void appendTo(Node node) throws DOMException {
        node.appendChild(this.node);
    }

    public String toStringXML() throws TransformerException {
        return XMLUtils.toStringXML(this, false, false);
    }

    public byte[] toBytesXML() throws TransformerException {
        return XMLUtils.toBytesXML(this, false, false);
    }

    public Node insertBefore(XMLNode newChild, Node refChild) throws DOMException {
        return this.node.insertBefore(newChild.node, refChild);
    }

    public Node replaceChild(XMLNode newChild, Node oldChild) throws DOMException {
        return this.node.replaceChild(newChild.node, oldChild);
    }

    public Node removeChild(XMLNode oldChild) throws DOMException {
        return this.node.removeChild(oldChild.node);
    }

    public Node appendChild(XMLNode newChild) throws DOMException {
        return this.node.appendChild(newChild.node);
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.node.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.node.getNodeType();
    }

    public Node getParentNode() {
        return this.node.getParentNode();
    }

    public NodeList getChildNodes() {
        return this.node.getChildNodes();
    }

    public Node getFirstChild() {
        return this.node.getFirstChild();
    }

    public Node getLastChild() {
        return this.node.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.node.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.node.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.node.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.node.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.node.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.node.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.node.cloneNode(deep);
    }

    public void normalize() {
        this.node.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.node.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }
}

