/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.security.xmlsec.util.DSIGInitializer;
import oracle.security.xmlsec.util.ENCInitializer;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.SOAPInitializer;
import oracle.security.xmlsec.util.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLElement
extends XMLNode {
    private static final String CLASSNAME = XMLElement.class.getName();
    private static final Logger TRACE = Logger.getLogger(CLASSNAME);
    private static Hashtable prefixMap = new Hashtable();

    protected XMLElement(Element element) throws DOMException {
        this(element, null);
    }

    protected XMLElement(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected XMLElement(Document owner, String nsURI, String localName) throws DOMException {
        this(owner, nsURI, localName, null);
    }

    protected XMLElement(Document owner, String nsURI, String localName, String systemId) throws DOMException {
        super(owner.createElementNS(nsURI, localName), systemId);
        String prefix = XMLElement.getDefaultNSPrefix(nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setPrefix(prefix);
        }
    }

    public NodeList getChildElementsByTagName(String name) {
        return XMLElement.getChildElementsByTagName((Element)this.node, name);
    }

    public NodeList getChildElementsByTagNameNS(String namespaceURI, String name) {
        return XMLElement.getChildElementsByTagNameNS((Element)this.node, namespaceURI, name);
    }

    public static NodeList getChildElementsByTagName(Element parent, String name) {
        NodeList list = parent.getChildNodes();
        NodeListImpl nodes = new NodeListImpl();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !name.equals("*") && !name.equals(node.getNodeName())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static NodeList getChildElementsByTagNameNS(Element parent, String namespaceURI, String name) {
        NodeListImpl nodes = new NodeListImpl();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !namespaceURI.equals("*") && !namespaceURI.equals(node.getNamespaceURI()) || !name.equals("*") && !name.equals(node.getLocalName())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static void setDefaultNSPrefix(String nsURI, String prefix) {
        if (prefix != null) {
            prefixMap.put(nsURI, prefix);
        } else {
            prefixMap.remove(nsURI);
        }
    }

    public static String getDefaultNSPrefix(String nsURI) {
        return (String)prefixMap.get(nsURI);
    }

    public static void addNSPrefixAttr(Element element, String prefix, String nsURI) throws DOMException {
        if (prefix != null && prefix.length() > 0) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        }
    }

    public static void addNSPrefixAttrDefault(Element element, String nsURI) throws DOMException {
        XMLElement.addNSPrefixAttr(element, XMLElement.getDefaultNSPrefix(nsURI), nsURI);
    }

    public void addNSPrefixAttr(String prefix, String nsURI) throws DOMException {
        XMLElement.addNSPrefixAttr((Element)this.node, prefix, nsURI);
    }

    public void addNSPrefixAttrDefault(String nsURI) throws DOMException {
        this.addNSPrefixAttr(XMLElement.getDefaultNSPrefix(nsURI), nsURI);
    }

    public String getTagName() {
        return ((Element)this.node).getTagName();
    }

    public String getAttribute(String name) {
        return ((Element)this.node).getAttribute(name);
    }

    public void setAttribute(String name, String value) throws DOMException {
        ((Element)this.node).setAttribute(name, value);
    }

    public void removeAttribute(String name) throws DOMException {
        ((Element)this.node).removeAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        return ((Element)this.node).getAttributeNode(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return ((Element)this.node).setAttributeNode(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return ((Element)this.node).removeAttributeNode(oldAttr);
    }

    public NodeList getElementsByTagName(String name) {
        return ((Element)this.node).getElementsByTagName(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.node).getAttributeNS(namespaceURI, localName);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        ((Element)this.node).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        ((Element)this.node).removeAttributeNS(namespaceURI, localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return ((Element)this.node).getAttributeNodeNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return ((Element)this.node).setAttributeNodeNS(newAttr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return ((Element)this.node).getElementsByTagNameNS(namespaceURI, localName);
    }

    public boolean hasAttribute(String name) {
        return ((Element)this.node).hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.node).hasAttributeNS(namespaceURI, localName);
    }

    static void init() {
        TRACE.log(Level.FINEST, "Calling XMLElement init");
    }

    public Element getElement() {
        return (Element)this.getNode();
    }

    static {
        DSIGInitializer.initialize();
        ENCInitializer.initialize();
        SOAPInitializer.initialize();
    }
}

