/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.Iterator;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class NodeReaderForSAX
extends NodeReader {
    char[] text;
    int textStart;
    int textLength;
    int eventType;
    String nsURI;
    String prefix;
    String localName;
    String target;
    String data;
    Attributes atts;
    DefaultHandler2 saxHandler = new SAXHandler();
    private AttributeIterator iter = new AttributeIterator();

    public DefaultHandler2 getSAXHandler() {
        return this.saxHandler;
    }

    @Override
    public boolean hasNext() throws NodeReaderException {
        return false;
    }

    @Override
    public int next() throws NodeReaderException {
        return 0;
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getNamespaceURI() {
        return this.nsURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public char[] getText() {
        return this.text;
    }

    @Override
    public int getTextStart() {
        return this.textStart;
    }

    @Override
    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public String getPIData() {
        return this.data;
    }

    @Override
    public String getPITarget() {
        return this.target;
    }

    @Override
    public Iterator getAttributes() {
        this.iter.init(this.atts);
        return this.iter;
    }

    private class SAXHandler
    extends DefaultHandler2 {
        private SAXHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            NodeReaderForSAX.this.text = ch;
            NodeReaderForSAX.this.textStart = start;
            NodeReaderForSAX.this.textLength = length;
            NodeReaderForSAX.this.eventType = 4;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            NodeReaderForSAX.this.text = ch;
            NodeReaderForSAX.this.textStart = start;
            NodeReaderForSAX.this.textLength = length;
            NodeReaderForSAX.this.eventType = 4;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            NodeReaderForSAX.this.text = ch;
            NodeReaderForSAX.this.textStart = start;
            NodeReaderForSAX.this.textLength = length;
            NodeReaderForSAX.this.eventType = 5;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void processingInstruction(String target1, String data1) throws SAXException {
            NodeReaderForSAX.this.target = target1;
            NodeReaderForSAX.this.data = data1;
            NodeReaderForSAX.this.eventType = 3;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            NodeReaderForSAX.this.eventType = 7;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            NodeReaderForSAX.this.eventType = 8;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startElement(String uri, String localName1, String qName, Attributes atts1) throws SAXException {
            int i = qName.indexOf(58);
            if (i > -1) {
                NodeReaderForSAX.this.prefix = qName.substring(0, i - 1);
                NodeReaderForSAX.this.localName = qName.substring(i + 1);
            } else {
                NodeReaderForSAX.this.prefix = "";
                NodeReaderForSAX.this.localName = qName;
            }
            NodeReaderForSAX.this.atts = atts1;
            NodeReaderForSAX.this.eventType = 1;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            NodeReaderForSAX.this.eventType = 2;
            try {
                NodeReaderForSAX.this.fireConsumeNode();
            }
            catch (NodeReaderException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }
    }

    private class AttributeIterator
    implements Iterator {
        Attributes alist;
        int index;
        int count;

        private AttributeIterator() {
        }

        private void init(Attributes alist) {
            this.alist = alist;
            this.index = 0;
            this.count = alist.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public Object next() {
            String qName = this.alist.getQName(this.index);
            int i = qName.indexOf(58);
            StreamingC14NImpl.AttrObj attr = i > -1 ? new StreamingC14NImpl.AttrObj(this.alist.getURI(this.index), qName.substring(0, i), qName.substring(i + 1), qName, this.alist.getValue(this.index)) : new StreamingC14NImpl.AttrObj(this.alist.getURI(this.index), "", qName, qName, this.alist.getValue(this.index));
            ++this.index;
            return attr;
        }

        @Override
        public void remove() {
        }
    }
}

