/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import oracle.security.xmlsec.util.XMLUtils;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NodeReaderForNodeset
extends NodeReader {
    private static final Object DUMMY = new Object();
    private Set nodeset;
    private IdentityHashMap elementToNodeObj = null;
    private IdentityHashMap missingParents = null;
    private static final NamespaceNode EMPTY_DEFAULTNS = new NamespaceNode(null, "", "");
    private static final TreeMap EMPTY_ATTRIB_MAP = new TreeMap();
    private static final HashMap EMPTY_NS_MAP = new HashMap();
    private static StreamingC14NImpl.AttrComparator aComparator;
    private boolean areNamespacesMissing;
    private boolean isSparse;
    private static final ArrayList IN_NODESET;
    private ArrayList nsStack = new ArrayList();
    private boolean eof = false;
    private Document doc;
    private Node currentNode;
    private int eventType;
    private boolean attrPopulated;
    private TreeMap attrMap;
    private char[] text;
    private AttributeIterator iter = new AttributeIterator();

    public NodeReaderForNodeset(Collection sourceNodes, boolean areNamespacesMissing, boolean isSparse) {
        this.areNamespacesMissing = areNamespacesMissing;
        this.isSparse = isSparse;
        this.nodeset = sourceNodes instanceof Set ? (Set)sourceNodes : new HashSet(sourceNodes);
        if (sourceNodes.size() == 0) {
            this.eof = true;
        } else {
            Node firstNode = (Node)this.nodeset.iterator().next();
            this.doc = firstNode.getNodeType() == 9 ? (Document)firstNode : firstNode.getOwnerDocument();
        }
        this.currentNode = this.doc;
        this.eventType = 7;
        if (areNamespacesMissing || isSparse) {
            this.elementToNodeObj = new IdentityHashMap();
        }
        if (isSparse) {
            this.missingParents = new IdentityHashMap();
        }
        if (!areNamespacesMissing && !isSparse) {
            return;
        }
        if (sourceNodes.size() == 0) {
            this.eof = true;
            return;
        }
        for (Node n : this.nodeset) {
            Node parent;
            if (n.getNodeType() == 13) {
                NodeObject nObj;
                NamespaceNode ns;
                if (!areNamespacesMissing || (ns = (NamespaceNode)n).getLocalName() == null || ns.getLocalName().equals("xml") && ns.getNodeValue().equals("http://www.w3.org/XML/1998/namespace")) continue;
                Element parentElem = (Element)n.getParentNode();
                if (!this.nodeset.contains(parentElem) && isSparse) {
                    this.populateMissingParents(parentElem);
                }
                if ((nObj = (NodeObject)this.elementToNodeObj.get(parentElem)) == null) {
                    nObj = new NodeObject(parentElem);
                    this.elementToNodeObj.put(parentElem, nObj);
                }
                if (nObj.nsMap == null) {
                    nObj.nsMap = new LinkedHashMap();
                    nObj.nsMap.put("", EMPTY_DEFAULTNS);
                }
                nObj.nsMap.put(ns.getLocalName(), ns);
                continue;
            }
            if (n.getNodeType() == 2) {
                NodeObject nObj;
                if (!isSparse) continue;
                Element parentElem = ((Attr)n).getOwnerElement();
                if (!this.nodeset.contains(parentElem)) {
                    this.populateMissingParents(parentElem);
                }
                if ((nObj = (NodeObject)this.elementToNodeObj.get(parentElem)) != null) continue;
                nObj = new NodeObject(parentElem);
                this.elementToNodeObj.put(parentElem, nObj);
                continue;
            }
            if (!isSparse || this.nodeset.contains(parent = n.getParentNode())) continue;
            this.populateMissingParents(parent);
        }
    }

    private void populateMissingParents(Node p) {
        while (p != null && !this.nodeset.contains(p) && !this.missingParents.containsKey(p)) {
            this.missingParents.put(p, DUMMY);
            p = p.getParentNode();
        }
    }

    @Override
    public final int next() {
        if (this.eof) {
            this.eventType = -1;
            return -1;
        }
        this.text = null;
        this.nextNode();
        while (!this.eof && !(!this.isSparse ? this.currentNode.getNodeType() == 1 || this.currentNode.getNodeType() == 9 || this.nodeset.contains(this.currentNode) : this.nodeset.contains(this.currentNode) || this.elementToNodeObj.containsKey(this.currentNode))) {
            this.nextNode();
        }
        return this.eventType;
    }

    private void pushNs() {
        if (this.areNamespacesMissing) {
            return;
        }
        if (this.nodeset.contains(this.currentNode)) {
            this.nsStack.add(IN_NODESET);
            return;
        }
        ArrayList<Attr> nsList = null;
        NamedNodeMap attrs = this.currentNode.getAttributes();
        if (attrs == null) {
            this.nsStack.add(null);
            return;
        }
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String prefix = NodeReaderForNodeset.getPrefix(attr.getName());
            if (prefix == null) continue;
            if (nsList == null) {
                nsList = new ArrayList<Attr>();
            }
            nsList.add(attr);
        }
        this.nsStack.add(nsList);
    }

    private void popNs() {
        if (this.areNamespacesMissing) {
            return;
        }
        this.nsStack.remove(this.nsStack.size() - 1);
    }

    public final int nextNode() {
        Node newNode;
        this.attrPopulated = false;
        if (this.eof) {
            return -1;
        }
        if (this.eventType == 8) {
            this.eof = true;
            this.currentNode = null;
            return -1;
        }
        if (this.eventType == 7 || this.eventType == 1) {
            Node newNode2 = this.currentNode.getFirstChild();
            if (newNode2 == null) {
                this.eventType = this.eventType == 7 ? 8 : 2;
                return this.eventType;
            }
            this.pushNs();
            this.currentNode = newNode2;
            this.setEventType();
            return this.eventType;
        }
        if (this.isSparse) {
            for (newNode = this.currentNode.getNextSibling(); newNode != null && !this.nodeset.contains(newNode) && !this.missingParents.containsKey(newNode); newNode = newNode.getNextSibling()) {
            }
        }
        if (newNode == null) {
            this.currentNode = this.currentNode.getParentNode();
            this.popNs();
            this.eventType = this.currentNode.getNodeType() == 9 ? 8 : 2;
            return this.eventType;
        }
        this.currentNode = newNode;
        this.setEventType();
        return this.eventType;
    }

    private final void setEventType() {
        if (this.currentNode.getNodeType() == 1) {
            this.eventType = 1;
        } else if (this.currentNode.getNodeType() == 8) {
            this.eventType = 5;
        } else if (this.currentNode.getNodeType() == 7) {
            this.eventType = 3;
        } else if (this.currentNode.getNodeType() == 3) {
            this.eventType = 4;
        } else if (this.currentNode.getNodeType() == 4) {
            this.eventType = 4;
        } else if (this.currentNode.getNodeType() == 10) {
            this.eventType = 11;
        } else if (this.currentNode.getNodeType() == 9) {
            this.eventType = 7;
        }
    }

    public final Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public final int getEventType() {
        return this.eventType;
    }

    private final void populateAttrList() {
        if (this.attrPopulated) {
            return;
        }
        this.attrMap = null;
        NamedNodeMap attrs = ((Element)this.currentNode).getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nsPrefix;
            Attr attr = (Attr)attrs.item(i);
            if (!this.nodeset.contains(attr) || (nsPrefix = NodeReaderForNodeset.getPrefix(attr.getNodeName())) != null) continue;
            if (this.attrMap == null) {
                this.attrMap = new TreeMap(aComparator);
            }
            this.attrMap.put(attr, DUMMY);
        }
        this.attrPopulated = true;
    }

    @Override
    public final String getLocalName() {
        Element elem = (Element)this.currentNode;
        return elem.getLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        Element elem = (Element)this.currentNode;
        return elem.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        Element elem = (Element)this.currentNode;
        return elem.getPrefix();
    }

    private static final String getPrefix(String attrName) {
        if (attrName.equals("xmlns")) {
            return "";
        }
        if (attrName.startsWith("xmlns:")) {
            return attrName.substring(6);
        }
        return null;
    }

    @Override
    public final String getPIData() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentNode;
        return pi.getData();
    }

    @Override
    public final String getPITarget() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentNode;
        return pi.getTarget();
    }

    @Override
    public final char[] getText() {
        if (this.text == null) {
            this.text = this.currentNode.getNodeValue().toCharArray();
        }
        return this.text;
    }

    @Override
    public final int getTextStart() {
        return 0;
    }

    @Override
    public final int getTextLength() {
        if (this.text == null) {
            this.text = this.currentNode.getNodeValue().toCharArray();
        }
        return this.text.length;
    }

    @Override
    public final boolean hasNext() {
        return !this.eof;
    }

    @Override
    public final boolean isElementIncluded() {
        return this.nodeset.contains(this.currentNode);
    }

    @Override
    public final Node getNode() {
        return this.currentNode;
    }

    @Override
    public final Iterator getAttributes() {
        if (!this.areNamespacesMissing) {
            this.iter.init(this.currentNode.getAttributes(), this.nodeset.contains(this.currentNode));
            return this.iter;
        }
        return null;
    }

    @Override
    public final SortedMap getSortedAttributes() {
        this.populateAttrList();
        return this.attrMap == null ? EMPTY_ATTRIB_MAP : this.attrMap;
    }

    @Override
    public final Map getNamespaces() {
        if (this.areNamespacesMissing) {
            NodeObject nObj = (NodeObject)this.elementToNodeObj.get(this.currentNode);
            return nObj == null || nObj.nsMap == null ? EMPTY_NS_MAP : nObj.nsMap;
        }
        return null;
    }

    @Override
    public boolean isElementAnOrphan() {
        if (this.currentNode.getNodeType() != 1) {
            return false;
        }
        if (!this.nodeset.contains(this.currentNode)) {
            return false;
        }
        if (this.currentNode.getParentNode() == null) {
            return false;
        }
        return !this.nodeset.contains(this.currentNode.getParentNode());
    }

    @Override
    public Collection getAncestorXmlAttributes(boolean c14n11) throws NodeReaderException {
        if (this.currentNode.getNodeType() != 1) {
            return null;
        }
        TreeMap<String, Attr> xmlAttribs = new TreeMap<String, Attr>();
        ArrayList<String> xmlBaseAttribs = null;
        boolean foundAncestorInNodeSet = false;
        Element e = (Element)this.currentNode;
        while (true) {
            if (e != this.currentNode && this.nodeset.contains(e)) {
                foundAncestorInNodeSet = true;
            }
            NamedNodeMap attrs = e.getAttributes();
            int n = attrs.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attrs.item(i);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:")) continue;
                if (c14n11) {
                    if (attrName.equals("xml:base")) {
                        if (foundAncestorInNodeSet) continue;
                        if (xmlBaseAttribs == null) {
                            xmlBaseAttribs = new ArrayList<String>();
                        }
                        xmlBaseAttribs.add(0, attr.getNodeValue());
                        continue;
                    }
                    if (!attrName.equals("xml:lang") && !attrName.equals("xml:space")) continue;
                }
                if (xmlAttribs.containsKey(attr.getLocalName())) continue;
                xmlAttribs.put(attr.getLocalName(), attr);
            }
            if (e.getParentNode() == null || e.getParentNode() == e.getOwnerDocument()) break;
            e = (Element)e.getParentNode();
        }
        if (xmlBaseAttribs != null && xmlBaseAttribs.size() > 0) {
            try {
                String fixedXmlBaseAttrib = XMLUtils.joinXmlBaseURI(xmlBaseAttribs);
                StreamingC14NImpl.AttrObj a = new StreamingC14NImpl.AttrObj("http://www.w3.org/XML/1998/namespace", "xml", "base", "xml:base", fixedXmlBaseAttrib);
                xmlAttribs.put("xml:base", a);
            }
            catch (URISyntaxException ex) {
                throw new NodeReaderException(ex);
            }
        }
        if (xmlAttribs.size() == 0) {
            return null;
        }
        return xmlAttribs.values();
    }

    @Override
    public boolean isElementInheritingNamespaces() {
        return !this.areNamespacesMissing;
    }

    @Override
    public Iterator getNamespacesForMissingAncestors() {
        if (!this.areNamespacesMissing) {
            this.iter.init(null, this.nodeset.contains(this.currentNode));
            return this.iter;
        }
        return null;
    }

    static {
        EMPTY_NS_MAP.put("", EMPTY_DEFAULTNS);
        aComparator = new StreamingC14NImpl.AttrComparator();
        IN_NODESET = new ArrayList();
    }

    private class AttributeIterator
    implements Iterator {
        int index = 0;
        int size;
        NamedNodeMap attribs;
        int nsStackFrame;
        int nsListIndex;
        int nsStackSize;
        Attr attr;

        private AttributeIterator() {
        }

        void init(NamedNodeMap attribs, boolean includeNsFromMissingAncestors) {
            this.attribs = attribs;
            this.index = 0;
            int n = this.size = attribs == null ? 0 : attribs.getLength();
            if (!includeNsFromMissingAncestors) {
                this.nsStackFrame = 0;
                this.nsStackSize = 0;
                this.nsListIndex = 0;
            } else {
                this.nsStackFrame = 0;
                this.nsStackSize = NodeReaderForNodeset.this.nsStack.size();
                this.nsListIndex = 0;
                for (int i = this.nsStackSize - 1; i >= 0; --i) {
                    if (NodeReaderForNodeset.this.nsStack.get(i) != IN_NODESET) continue;
                    this.nsStackFrame = i + 1;
                    break;
                }
                while (this.nsStackFrame < this.nsStackSize && NodeReaderForNodeset.this.nsStack.get(this.nsStackFrame) == null) {
                    ++this.nsStackFrame;
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.nsStackFrame < this.nsStackSize) {
                if (NodeReaderForNodeset.this.nsStack.get(this.nsStackFrame) == null) {
                    ++this.nsStackFrame;
                    continue;
                }
                ArrayList nsList = (ArrayList)NodeReaderForNodeset.this.nsStack.get(this.nsStackFrame);
                if (this.nsListIndex < nsList.size()) {
                    this.attr = (Attr)nsList.get(this.nsListIndex);
                    return true;
                }
                this.nsListIndex = 0;
                ++this.nsStackFrame;
            }
            while (this.index < this.size) {
                this.attr = (Attr)this.attribs.item(this.index);
                if (NodeReaderForNodeset.this.nodeset.contains(this.attr)) {
                    return true;
                }
                String nsPrefix = NodeReaderForNodeset.getPrefix(this.attr.getNodeName());
                if (nsPrefix != null) {
                    NamespaceNode ns = new NamespaceNode((Node)this.attr.getOwnerElement(), nsPrefix, this.attr.getNodeValue());
                    if (NodeReaderForNodeset.this.nodeset.contains(ns)) {
                        return true;
                    }
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            if (this.nsStackFrame < this.nsStackSize) {
                ++this.nsListIndex;
            } else {
                ++this.index;
            }
            return this.attr;
        }

        @Override
        public void remove() {
        }
    }

    private static class NodeObject {
        Node node;
        LinkedHashMap nsMap;
        NamespaceNode[] nsList;
        boolean included = true;
        int eventType;

        NodeObject(Node node) {
            this.node = node;
        }
    }
}

