/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.Iterator;
import oracle.security.xmlsec.transform.NodeFilterTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilteredNodeReader
extends NodeReader {
    private NodeReader nReader;
    private NodeFilterTransform nodeFilter;
    private Element elementWithAllDescendants = null;

    public FilteredNodeReader(NodeReader nReader, NodeFilterTransform nodeFilter) {
        this.nReader = nReader;
        this.nodeFilter = nodeFilter;
    }

    @Override
    public Iterator getAttributes() {
        return this.nReader.getAttributes();
    }

    @Override
    public int getEventType() {
        return this.nReader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.nReader.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.nReader.getNamespaceURI();
    }

    @Override
    public String getPIData() {
        return this.nReader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.nReader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.nReader.getPrefix();
    }

    @Override
    public char[] getText() {
        return this.nReader.getText();
    }

    @Override
    public int getTextLength() {
        return this.nReader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.nReader.getTextStart();
    }

    @Override
    public boolean hasNext() throws NodeReaderException {
        return this.nReader.hasNext();
    }

    @Override
    public Node getNode() {
        return this.nReader.getNode();
    }

    @Override
    public int next() throws NodeReaderException {
        int ret = this.nReader.next();
        if (ret == -1) {
            return ret;
        }
        if (this.getEventType() == 8) {
            return ret;
        }
        if (this.getEventType() == 2 && this.getNode() == this.elementWithAllDescendants) {
            this.elementWithAllDescendants = null;
            return ret;
        }
        if (this.elementWithAllDescendants != null) {
            return ret;
        }
        while (true) {
            int filterVal;
            if (this.getEventType() == 8 || this.getEventType() == -1) {
                return this.getEventType();
            }
            try {
                filterVal = this.nodeFilter.accept(this.getNode());
            }
            catch (TransformationException ex) {
                throw new NodeReaderException(ex);
            }
            if (filterVal == 1) {
                return ret;
            }
            if (filterVal == 3) {
                this.elementWithAllDescendants = (Element)this.getNode();
                return ret;
            }
            if (filterVal == 2) {
                this.nReader.next();
                continue;
            }
            if (this.getEventType() != 1) continue;
            if (filterVal == 4) break;
        }
        Element prunedElement = (Element)this.getNode();
        do {
            this.nReader.next();
            if (this.getEventType() != -1) continue;
            return -1;
        } while (this.nReader.getEventType() != 2 || this.getNode() != prunedElement);
        return this.nReader.next();
    }
}

