/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.util.AbstractList;
import java.util.List;
import oracle.security.xmlsec.transform.HereFunctionContextSupport;
import oracle.security.xmlsec.util.XMLUtils;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HereFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        Document xDoc;
        if (args != null && args.size() != 0) {
            throw new FunctionCallException("here() takes no arguments");
        }
        ContextSupport contextSupport = context.getContextSupport();
        if (contextSupport == null || !(contextSupport instanceof HereFunctionContextSupport)) {
            throw new FunctionCallException("here() requires oracle.security.xmlsec.transform.HereFunctionContextSupport");
        }
        Node xpathNode = (Node)((HereFunctionContextSupport)contextSupport).getXPathNode();
        if (xpathNode == null) {
            throw new FunctionCallException("Missing XPath expression node");
        }
        List contextNodes = context.getNodeSet();
        if (contextNodes == null || contextNodes.size() == 0) {
            return ImmutableList.EMPTY_LIST;
        }
        Node contextNode = (Node)contextNodes.get(0);
        Document cDoc = XMLUtils.getOwnerDocument(contextNode);
        if (cDoc != (xDoc = XMLUtils.getOwnerDocument(xpathNode))) {
            throw new FunctionCallException("Context node and XPath expression node in different documents");
        }
        short nodeType = xpathNode.getNodeType();
        if (nodeType == 3) {
            return new ImmutableList(xpathNode.getParentNode());
        }
        if (nodeType == 2 || nodeType == 7) {
            return new ImmutableList(xpathNode);
        }
        throw new FunctionCallException(XMLUtils.getNodeTypeName(nodeType) + " not allowed as XPath expression container for 'here()' function");
    }

    private static final class ImmutableList
    extends AbstractList {
        private final Object item;
        private static final ImmutableList EMPTY_LIST = new ImmutableList();

        private ImmutableList() {
            this.item = null;
        }

        private ImmutableList(Object obj) {
            this.item = obj;
        }

        @Override
        public Object get(int index) {
            if (index != 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return this.item;
        }

        @Override
        public int size() {
            return this.item != null ? 1 : 0;
        }
    }
}

