/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.NodeToStreamTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XPathException;
import org.xml.sax.SAXException;

public class C14NTransform
extends XSTransformer
implements NodeToStreamTransform {
    protected Canonicalizer c14n;

    public C14NTransform() {
        this.c14n = Canonicalizer.getInstance(true, false, false);
    }

    public C14NTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        try {
            this.c14n = Canonicalizer.getInstance(trans.getAlgorithm());
        }
        catch (AlgorithmIdentifierException ex) {
            throw new IllegalArgumentException("XML-C14N Transform required");
        }
        if (trans.getParameters().getLength() != 0) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
    }

    @Override
    public String getAlgorithmURI() {
        return this.c14n.getAlgorithURI();
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        byte[] res = null;
        try {
            res = source.subTreeAvailable() ? (("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(this.getAlgorithmURI()) || "http://www.w3.org/2006/12/xml-c14n11#WithComments".equals(this.getAlgorithmURI())) && !source.getWithComments() ? this.c14n.canonicalize(source.getNodeSet()) : this.c14n.canonicalize(source.getSubTree())) : (source.nodeSetAvailable() ? this.c14n.canonicalize(source.getNodeSet()) : this.c14n.canonicalize(source.getOctetStream(), source.getSystemId()));
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        if (res == null) {
            res = new byte[]{};
        }
        try {
            return new XMLContainer(new ByteArrayInputStream(res));
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
    }

    @Override
    public InputStream transformToStream(NodeReader source) throws TransformationException {
        StreamingC14NImpl sc14n = (StreamingC14NImpl)this.c14n;
        return sc14n.canonicalizeToStream(source);
    }

    public static class C14N11Transform
    extends C14NTransform {
        public C14N11Transform() {
            this.c14n = Canonicalizer.getInstance(true, false, true);
        }
    }
}

