/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys.retrieval;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.RecipientKeyInfo;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptedObject;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.keys.DHAgreementMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.keys.RawX509Cert;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyInfoTool
extends KeyRetriever {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublicKey retrievePublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        PublicKey pubKey = null;
        KeyInfoData kid = keyInfo;
        String type = kid.getType();
        if ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(type) && !XMLUtils.getAllowRetrievalMethodFlag()) {
            throw new KeyRetrievalException("RetrievalMethod cannot be used by default.To use it, change the JVM variable osdt.allow.retrievalMethod to true, but be aware of security risks by using RetrievalMethod.");
        }
        try {
            while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(type)) {
                kid = ((RetrievalMethod)kid).getKeyInfoData();
                type = kid.getType();
            }
        }
        catch (ReferenceException ex) {
            throw new KeyRetrievalException(ex);
        }
        if ("http://www.w3.org/2000/09/xmldsig#DSAKeyValue".equals(type) || "http://www.w3.org/2000/09/xmldsig#RSAKeyValue".equals(type) || "http://www.w3.org/2001/04/xmlenc#DHKeyValue".equals(type) || "http://www.w3.org/2001/04/xmldsig-more#ECDSAKeyValue".equals(type) || "http://www.w3.org/2009/xmldsig11#ECKeyValue".equals(type)) {
            if (!XMLUtils.getAllowUnvalidatedCertFlag()) throw new KeyRetrievalException("ERROR: DSA, RSA, DH or EC public keys are not allowed unless the JVM variable osdt.allow.unvalidatedCert  to true, or osdt.allow.all to true");
            return ((KeyValue)kid).getPublicKey();
        }
        if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(type)) {
            X509Certificate cert = KeyInfoTool.getCertFromX509Data((X509Data)kid);
            if (cert != null && !XMLUtils.getAllowUnvalidatedCertFlag()) {
                try {
                    Vector certs = null;
                    certs = ((X509Data)kid).getCertificates();
                    KeyInfoTool.validateCertificate(certs);
                }
                catch (IOException ex) {
                    throw new KeyRetrievalException(ex);
                }
            }
            if (cert == null) return pubKey;
            return cert.getPublicKey();
        }
        if (!"http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(type)) return pubKey;
        try {
            X509Certificate cert = ((RawX509Cert)kid).getCertificate();
            if (cert != null && !XMLUtils.getAllowUnvalidatedCertFlag()) {
                KeyInfoTool.validateCertificate(cert);
            }
            if (cert == null) return pubKey;
            return cert.getPublicKey();
        }
        catch (IOException ex) {
            throw new KeyRetrievalException(ex);
        }
    }

    @Override
    public SecretKey retrieveSymmetricKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        SecretKey symKey;
        block14: {
            XEEncryptedObject eo;
            XEEncryptionMethod em;
            Element eoNode;
            DHAgreementMethod dhAgreement;
            Element kiNode;
            String type;
            KeyInfoData kid;
            block15: {
                block13: {
                    symKey = null;
                    kid = keyInfo;
                    type = kid.getType();
                    if (XMLUtils.getAllowRetrievalMethodFlag()) {
                        try {
                            while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(type)) {
                                kid = ((RetrievalMethod)kid).getKeyInfoData();
                                type = kid.getType();
                            }
                        }
                        catch (ReferenceException ex) {
                            throw new KeyRetrievalException(ex);
                        }
                    }
                    if (!"http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(type)) break block13;
                    XEEncryptedKey ek = (XEEncryptedKey)kid;
                    try {
                        symKey = ek.getKey(null);
                    }
                    catch (XEException xEException) {}
                    break block14;
                }
                if (!"http://www.w3.org/2000/09/xmldsig-more#KeyName".equals(type)) break block15;
                KeyName keyName = (KeyName)kid;
                String keyNameStr = keyName.getName();
                if (keyNameStr == null) break block14;
                NodeList encKeyList = keyName.getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                int len = encKeyList.getLength();
                for (int i = 0; i < len && symKey == null; ++i) {
                    XEEncryptedKey encKey = new XEEncryptedKey((Element)encKeyList.item(i), keyName.getSystemId());
                    if (!keyNameStr.equals(encKey.getCarriedKeyName())) continue;
                    symKey = KeyRetriever.getSymmetricKey(encKey);
                }
                break block14;
            }
            if ("http://www.w3.org/2001/04/xmlenc#dh".equals(type) && (kiNode = (Element)(dhAgreement = (DHAgreementMethod)kid).getParentNode()) != null && "http://www.w3.org/2000/09/xmldsig#".equals(kiNode.getNamespaceURI()) && "KeyInfo".equals(kiNode.getLocalName()) && (eoNode = (Element)kiNode.getParentNode()) != null && "http://www.w3.org/2001/04/xmlenc#".equals(eoNode.getNamespaceURI()) && ("EncryptedKey".equals(eoNode.getLocalName()) || "EncryptedData".equals(eoNode.getLocalName())) && (em = (eo = XEEncryptedObject.getInstance(eoNode, dhAgreement.getSystemId())).getEncryptionMethod()) != null) {
                OriginatorKeyInfo oki = dhAgreement.getOriginatorKeyInfo();
                RecipientKeyInfo rki = dhAgreement.getRecipientKeyInfo();
                if (oki != null && rki != null) {
                    PublicKey other = KeyRetriever.getPublicKey(oki);
                    PrivateKey local = KeyRetriever.getPrivateKey(rki);
                    if (other != null && local != null) {
                        try {
                            symKey = new SecretKeySpec(dhAgreement.generateKeyMaterial(em, local, other), em.getJCEKeyAlgorithm());
                        }
                        catch (XECipherException ex) {
                            throw new KeyRetrievalException(ex);
                        }
                        catch (XESchemaException ex) {
                            throw new KeyRetrievalException(ex);
                        }
                    }
                }
            }
        }
        return symKey;
    }

    @Override
    public X509Certificate retrieveCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        X509Certificate cert = null;
        KeyInfoData kid = keyInfo;
        String type = kid.getType();
        if (XMLUtils.getAllowRetrievalMethodFlag()) {
            try {
                while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(type)) {
                    kid = ((RetrievalMethod)kid).getKeyInfoData();
                    type = kid.getType();
                }
            }
            catch (ReferenceException ex) {
                throw new KeyRetrievalException(ex);
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(type) && (cert = KeyInfoTool.getCertFromX509Data((X509Data)kid)) != null && !XMLUtils.getAllowUnvalidatedCertFlag()) {
            try {
                Vector certs = null;
                certs = ((X509Data)kid).getCertificates();
                KeyInfoTool.validateCertificate(certs);
            }
            catch (IOException ex) {
                throw new KeyRetrievalException(ex);
            }
        }
        return cert;
    }

    private static X509Certificate getCertFromX509Data(X509Data keyInfo) throws KeyRetrievalException {
        Vector certs = null;
        try {
            certs = keyInfo.getCertificates();
        }
        catch (IOException ex) {
            throw new KeyRetrievalException(ex);
        }
        if (certs.size() == 0) {
            return null;
        }
        if (certs.size() == 1) {
            return (X509Certificate)certs.elementAt(0);
        }
        Vector isnos = keyInfo.getIssuerSerials();
        Vector skids = keyInfo.getSubjectKeyIDs();
        Vector names = keyInfo.getSubjectNames();
        int n = certs.size();
        for (int i = 0; i < n; ++i) {
            X509Certificate cert = (X509Certificate)certs.elementAt(i);
            X509Data.IssuerAndSerialNo certIsno = new X509Data.IssuerAndSerialNo(cert.getIssuerX500Principal(), cert.getSerialNumber());
            int x = isnos.size();
            for (int j = 0; j < x; ++j) {
                X509Data.IssuerAndSerialNo isno = (X509Data.IssuerAndSerialNo)isnos.elementAt(j);
                if (!isno.equals(certIsno)) continue;
                return cert;
            }
            byte[] certSkid = XMLUtils.getSKI(cert);
            if (certSkid != null) {
                int x2 = skids.size();
                for (int j = 0; j < x2; ++j) {
                    byte[] skid = (byte[])skids.elementAt(j);
                    if (!Utils.areEqual((byte[])skid, (byte[])certSkid)) continue;
                    return cert;
                }
            }
            X500Principal certName = cert.getSubjectX500Principal();
            int x3 = names.size();
            for (int j = 0; j < x3; ++j) {
                X500Principal name = (X500Principal)names.elementAt(j);
                if (!name.equals(certName)) continue;
                return cert;
            }
        }
        return (X509Certificate)certs.elementAt(0);
    }
}

