/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class X509Data
extends XMLElement
implements KeyInfoData {
    public X509Data(Element element) throws DOMException {
        super(element);
    }

    public X509Data(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    X509Data(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public void addIssuerSerial(X500Principal issuer, BigInteger serialNumber) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element xin = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
        XMLUtils.copyNSPrefix((Element)this.node, xin);
        xin.appendChild(doc.createTextNode(issuer.toString()));
        Element xsn = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
        XMLUtils.copyNSPrefix((Element)this.node, xsn);
        xsn.appendChild(doc.createTextNode(serialNumber.toString()));
        Element xis = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
        XMLUtils.copyNSPrefix((Element)this.node, xis);
        xis.appendChild(xin);
        xis.appendChild(xsn);
        this.appendChild(xis);
    }

    public Vector getIssuerSerials() {
        Vector<IssuerAndSerialNo> list = new Vector<IssuerAndSerialNo>();
        NodeList isList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
        int n = isList.getLength();
        for (int i = 0; i < n; ++i) {
            Element xis = (Element)isList.item(i);
            X500Principal issuer = null;
            NodeList issuerList = XMLElement.getChildElementsByTagNameNS(xis, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
            if (issuerList.getLength() != 0) {
                issuer = new X500Principal(XMLUtils.collectText(issuerList.item(0)));
            }
            BigInteger serial = null;
            NodeList serialList = XMLElement.getChildElementsByTagNameNS(xis, "http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
            if (serialList.getLength() != 0) {
                serial = new BigInteger(XMLUtils.collectText(serialList.item(0)));
            }
            list.addElement(new IssuerAndSerialNo(issuer, serial));
        }
        return list;
    }

    public void addSubjectName(X500Principal subjectName) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element xsn = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
        XMLUtils.copyNSPrefix((Element)this.node, xsn);
        xsn.appendChild(doc.createTextNode(subjectName.toString()));
        this.appendChild(xsn);
    }

    public Vector getSubjectNames() {
        Vector<X500Principal> list = new Vector<X500Principal>();
        NodeList snList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
        int n = snList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new X500Principal(XMLUtils.collectText(snList.item(i))));
        }
        return list;
    }

    public void addSubjectKeyID(byte[] subjectKeyID) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element xski = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509SKI");
        XMLUtils.copyNSPrefix((Element)this.node, xski);
        xski.appendChild(doc.createTextNode(Base64.toBase64WithLFSeparator(subjectKeyID)));
        this.appendChild(xski);
    }

    public Vector getSubjectKeyIDs() {
        Vector<byte[]> list = new Vector<byte[]>();
        NodeList skiList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SKI");
        int n = skiList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(Base64.fromBase64(XMLUtils.collectText(skiList.item(i))));
        }
        return list;
    }

    public void addCertificate(X509Certificate cert) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element xc = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        XMLUtils.copyNSPrefix((Element)this.node, xc);
        try {
            xc.appendChild(doc.createTextNode(Base64.toBase64WithLFSeparator(cert.getEncoded())));
        }
        catch (CertificateEncodingException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Invalid certificate");
            ex1.initCause(ex);
            throw ex1;
        }
        this.appendChild(xc);
    }

    public Vector getCertificates() throws IOException {
        try {
            Vector<Certificate> list = new Vector<Certificate>();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            NodeList cList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            int n = cList.getLength();
            for (int i = 0; i < n; ++i) {
                byte[] certBytes = Base64.fromBase64(XMLUtils.collectText(cList.item(i)));
                if (certBytes.length <= 0) continue;
                list.addElement(cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(certBytes)));
            }
            return list;
        }
        catch (CertificateException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Invalid certificate");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    public void addCRL(X509CRL crl) throws DOMException {
        try {
            Document doc = this.getOwnerDocument();
            Element xc = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509CRL");
            XMLUtils.copyNSPrefix((Element)this.node, xc);
            xc.appendChild(doc.createTextNode(Base64.toBase64WithLFSeparator(crl.getEncoded())));
            this.appendChild(xc);
        }
        catch (CRLException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Invalid CRL");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    public Vector getCRLs() throws IOException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Vector<CRL> list = new Vector<CRL>();
            NodeList cList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509CRL");
            int n = cList.getLength();
            for (int i = 0; i < n; ++i) {
                list.addElement(cf.generateCRL((InputStream)new UnsyncByteArrayInputStream(Base64.fromBase64(XMLUtils.collectText(cList.item(i))))));
            }
            return list;
        }
        catch (CertificateException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("JCE does not support X509 Certificate factory");
            ex1.initCause(ex);
            throw ex1;
        }
        catch (CRLException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Invalid CRL");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#X509Data";
    }

    public boolean matches(X509Certificate cert) {
        byte[] certSkid;
        Vector names = this.getSubjectNames();
        Vector isnos = this.getIssuerSerials();
        Vector skids = this.getSubjectKeyIDs();
        Vector certs = null;
        try {
            certs = this.getCertificates();
        }
        catch (IOException ex) {
            certs = new Vector();
        }
        IssuerAndSerialNo certIsno = new IssuerAndSerialNo(cert.getIssuerX500Principal(), cert.getSerialNumber());
        if (isnos.size() > 0) {
            int z = isnos.size();
            for (int k = 0; k < z; ++k) {
                IssuerAndSerialNo isno = (IssuerAndSerialNo)isnos.elementAt(k);
                if (!isno.equals(certIsno)) continue;
                return true;
            }
        }
        if ((certSkid = XMLUtils.getSKI(cert)) != null && skids.size() > 0) {
            int z = skids.size();
            for (int k = 0; k < z; ++k) {
                byte[] skid = (byte[])skids.elementAt(k);
                if (!Utils.areEqual((byte[])certSkid, (byte[])skid)) continue;
                return true;
            }
        }
        X500Principal subject = cert.getSubjectX500Principal();
        if (names.size() > 0) {
            int z = names.size();
            for (int k = 0; k < z; ++k) {
                X500Principal name = (X500Principal)names.elementAt(k);
                if (!name.equals(subject)) continue;
                return true;
            }
        }
        int z = certs.size();
        for (int k = 0; k < z; ++k) {
            boolean match;
            X509Certificate c = (X509Certificate)certs.elementAt(k);
            boolean bl = match = subject.equals(c.getSubjectX500Principal()) && certIsno.equals(new IssuerAndSerialNo(c.getIssuerX500Principal(), c.getSerialNumber())) && Utils.areEqual((byte[])certSkid, (byte[])XMLUtils.getSKI(c));
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static class IssuerAndSerialNo {
        private X500Principal issuer;
        private BigInteger serial;

        public IssuerAndSerialNo(X500Principal issuer, BigInteger serial) {
            this.issuer = issuer;
            this.serial = serial;
        }

        public X500Principal getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IssuerAndSerialNo) {
                IssuerAndSerialNo o1 = (IssuerAndSerialNo)obj;
                return o1.issuer.equals(this.issuer) && o1.serial.equals(this.serial);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
            result = 31 * result + (this.serial == null ? 0 : this.serial.hashCode());
            return result;
        }
    }
}

