/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSAKeyValue
extends XMLElement
implements KeyValueData {
    public DSAKeyValue(Element element) throws DOMException {
        super(element);
    }

    public DSAKeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    DSAKeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue");
    }

    DSAKeyValue(Document owner, DSAPublicKey dsaKey) throws DOMException {
        this(owner);
        DSAParams params = dsaKey.getParams();
        BigInteger p = params.getP();
        BigInteger q = params.getQ();
        if (p != null && q != null) {
            this.setPQ(p, q);
            this.setJ(p.subtract(BigInteger.valueOf(1L)).divide(q));
        } else if (p != null || q != null) {
            throw new IllegalArgumentException("DSA params P and Q must both be either present or missing");
        }
        if (params.getG() != null) {
            this.setG(params.getG());
        }
        if (dsaKey.getY() == null) {
            throw new IllegalArgumentException("DSA value Y=G^X%P is missing");
        }
        this.setY(dsaKey.getY());
    }

    public void setPQ(BigInteger p, BigInteger q) throws DOMException {
        int i;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "P");
        for (i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Q");
        for (i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element pNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "P");
        XMLUtils.copyNSPrefix((Element)this.node, pNode);
        pNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)p))));
        Element qNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Q");
        XMLUtils.copyNSPrefix((Element)this.node, qNode);
        qNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)q))));
        nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(qNode, nList.item(0));
        } else {
            this.appendChild(qNode);
        }
        this.insertBefore(pNode, (Node)qNode);
    }

    public BigInteger getP() {
        String pString;
        BigInteger p = null;
        NodeList pList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "P");
        if (pList.getLength() != 0 && (pString = XMLUtils.collectText(pList.item(0))).length() != 0) {
            p = new BigInteger(1, Base64.fromBase64(pString));
        }
        return p;
    }

    public BigInteger getQ() {
        String qString;
        BigInteger q = null;
        NodeList qList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Q");
        if (qList.getLength() != 0 && (qString = XMLUtils.collectText(qList.item(0))).length() != 0) {
            q = new BigInteger(1, Base64.fromBase64(qString));
        }
        return q;
    }

    public void setG(BigInteger g) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "G");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element gNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "G");
        XMLUtils.copyNSPrefix((Element)this.node, gNode);
        gNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)g))));
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Y");
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "J");
        }
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        }
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        }
        if (nList.getLength() != 0) {
            this.insertBefore(gNode, nList.item(0));
        } else {
            this.appendChild(gNode);
        }
    }

    public BigInteger getG() {
        String gString;
        BigInteger g = null;
        NodeList gList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "G");
        if (gList.getLength() != 0 && (gString = XMLUtils.collectText(gList.item(0))).length() != 0) {
            g = new BigInteger(1, Base64.fromBase64(gString));
        }
        return g;
    }

    public void setY(BigInteger y) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Y");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element yNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Y");
        XMLUtils.copyNSPrefix((Element)this.node, yNode);
        yNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)y))));
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "J");
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        }
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        }
        if (nList.getLength() != 0) {
            this.insertBefore(yNode, nList.item(0));
        } else {
            this.appendChild(yNode);
        }
    }

    public BigInteger getY() {
        String yString;
        BigInteger y = null;
        NodeList yList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Y");
        if (yList.getLength() != 0 && (yString = XMLUtils.collectText(yList.item(0))).length() != 0) {
            y = new BigInteger(1, Base64.fromBase64(yString));
        }
        return y;
    }

    public void setJ(BigInteger j) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "J");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element jNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "J");
        XMLUtils.copyNSPrefix((Element)this.node, jNode);
        jNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)j))));
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        }
        if (nList.getLength() != 0) {
            this.insertBefore(jNode, nList.item(0));
        } else {
            this.appendChild(jNode);
        }
    }

    public BigInteger getJ() {
        String jString;
        BigInteger j = null;
        NodeList jList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "J");
        if (jList.getLength() != 0 && (jString = XMLUtils.collectText(jList.item(0))).length() != 0) {
            j = new BigInteger(1, Base64.fromBase64(jString));
        }
        return j;
    }

    public void setPrimeGen(byte[] seed, BigInteger counter) throws DOMException {
        NodeList sList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        for (int i = sList.getLength(); i > 0; --i) {
            this.removeChild(sList.item(i - 1));
        }
        NodeList cList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        for (int i = cList.getLength(); i > 0; --i) {
            this.removeChild(cList.item(i - 1));
        }
        Element sNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        XMLUtils.copyNSPrefix((Element)this.node, sNode);
        sNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(seed)));
        this.appendChild(sNode);
        Element cNode = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        XMLUtils.copyNSPrefix((Element)this.node, cNode);
        cNode.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(Utils.toByteArray((BigInteger)counter))));
        this.appendChild(cNode);
    }

    public byte[] getPGenSeed() throws DOMException {
        String sString;
        byte[] seed = null;
        NodeList sList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Seed");
        if (sList.getLength() != 0 && (sString = XMLUtils.collectText(sList.item(0))).length() != 0) {
            seed = Base64.fromBase64(sString);
        }
        return seed;
    }

    public BigInteger getPGenCounter() {
        String cString;
        BigInteger counter = null;
        NodeList cList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PgenCounter");
        if (cList.getLength() != 0 && (cString = XMLUtils.collectText(cList.item(0))).length() != 0) {
            counter = new BigInteger(1, Base64.fromBase64(cString));
        }
        return counter;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            KeyFactory dsakf = KeyFactory.getInstance("DSA");
            return dsakf.generatePublic(new DSAPublicKeySpec(this.getY(), this.getP(), this.getQ(), this.getG()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#DSAKeyValue";
    }
}

