/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.RecipientKeyInfo;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.keys.DHAgreementMethod;
import oracle.security.xmlsec.keys.DHExplicitAgreementMethod;
import oracle.security.xmlsec.keys.ECDHESAgreementMethod;
import oracle.security.xmlsec.keys.KeyDerivationMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AgreementMethod
extends XMLElement
implements KeyInfoData {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2001/04/xmlenc#"};
    private static final String[] localNames = new String[]{"KA-Nonce", "DigestMethod", "KeyDerivationMethod", "OriginatorKeyInfo", "RecipientKeyInfo"};

    protected AgreementMethod(Element element) throws DOMException {
        super(element);
    }

    protected AgreementMethod(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected AgreementMethod(Document doc, String algURI) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
        if (algURI != null) {
            this.setAlgorithm(algURI);
        }
    }

    public static AgreementMethod getInstance(Document doc, String algURI) throws DOMException {
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#dh")) {
            return new DHAgreementMethod(doc);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#dh-es")) {
            return new DHExplicitAgreementMethod(doc);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#ECDH-ES")) {
            return new ECDHESAgreementMethod(doc);
        }
        throw new IllegalArgumentException("Unsupported key agreement algorithm: " + algURI);
    }

    public static AgreementMethod getInstance(Element element) throws DOMException {
        String algURI = element.getAttribute("Algorithm");
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#dh")) {
            return new DHAgreementMethod(element);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#dh-es")) {
            return new DHExplicitAgreementMethod(element);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#ECDH-ES")) {
            return new ECDHESAgreementMethod(element);
        }
        throw new IllegalArgumentException("Unsupported key agreement algorithm: " + algURI);
    }

    public static AgreementMethod getInstance(Element element, String systemId) throws DOMException {
        String algURI = element.getAttribute("Algorithm");
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#dh")) {
            return new DHAgreementMethod(element, systemId);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#dh-es")) {
            return new DHExplicitAgreementMethod(element, systemId);
        }
        if (algURI.equals("http://www.w3.org/2009/xmlenc11#ECDH-ES")) {
            return new ECDHESAgreementMethod(element, systemId);
        }
        throw new IllegalArgumentException("Unsupported key agreement algorithm: " + algURI);
    }

    public abstract void setAlgorithm(String var1);

    public String getAlgorithm() {
        if (this.hasAttribute("Algorithm")) {
            return this.getAttribute("Algorithm");
        }
        return null;
    }

    public void setKANonce(byte[] nonce) throws DOMException {
        String nonceStr = Base64.toBase64(nonce, false);
        XMLUtils.insertChildElementWithText(this, "http://www.w3.org/2001/04/xmlenc#", "KA-Nonce", nsURIs, localNames, nonceStr, true);
    }

    public byte[] getKANonce() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KA-Nonce");
        if (nodes.getLength() != 0) {
            return Base64.fromBase64(XMLUtils.collectText(nodes.item(0)));
        }
        return null;
    }

    public void setDigestMethod(String digestMethod) throws DOMException {
        this.setDigestMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "DigestMethod", digestMethod));
    }

    public void setDigestMethod(XSAlgorithmIdentifier digestMethod) throws DOMException {
        XMLUtils.removeChildren(this.getElement(), digestMethod.getNamespaceURI(), digestMethod.getLocalName());
        XMLUtils.insertChild(this, digestMethod, nsURIs, localNames);
    }

    public XSAlgorithmIdentifier getDigestMethod() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (nodes.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setKeyDerivationMethod(KeyDerivationMethod keyDerivationMethod) {
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod");
        XMLUtils.insertChild(this, keyDerivationMethod, nsURIs, localNames);
    }

    public KeyDerivationMethod getKeyDerivationMethod() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "KeyDerivationMethod");
        if (nodes.getLength() != 0) {
            return new KeyDerivationMethod((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setOriginatorKeyInfo(OriginatorKeyInfo oriKeyInfo) {
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo");
        XMLUtils.insertChild(this, oriKeyInfo, nsURIs, localNames);
    }

    public OriginatorKeyInfo getOriginatorKeyInfo() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo");
        if (nodes.getLength() != 0) {
            return new OriginatorKeyInfo((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setRecipientKeyInfo(RecipientKeyInfo reciKeyInfo) {
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo");
        XMLUtils.insertChild(this, reciKeyInfo, nsURIs, localNames);
    }

    public RecipientKeyInfo getRecipientKeyInfo() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo");
        if (nodes.getLength() != 0) {
            return new RecipientKeyInfo((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public abstract byte[] generateKeyMaterial(XEEncryptionMethod var1, PrivateKey var2, PublicKey var3) throws XESchemaException, XECipherException;

    public abstract KeyPair setToDefaultParameters(KeyPair var1, PublicKey var2, String var3) throws XECipherException;
}

