/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XEEncryptionMethod
extends XSAlgorithmIdentifier {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2001/04/xmlenc#", "http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2009/xmlenc11#"};
    private static final String[] localNames = new String[]{"KeySize", "OAEPparams", "DigestMethod", "MGF"};

    public XEEncryptionMethod(Element encMethod) throws DOMException {
        super(encMethod);
    }

    public XEEncryptionMethod(Element encMethod, String systemId) throws DOMException {
        super(encMethod, systemId);
    }

    public XEEncryptionMethod(Document doc, String algorithm) throws DOMException {
        this(doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod"));
        String prefix = XMLElement.getDefaultNSPrefix("http://www.w3.org/2001/04/xmlenc#");
        if (prefix != null && prefix.length() > 0) {
            this.setPrefix(prefix);
        }
        if (algorithm != null) {
            this.setAlgorithm(algorithm);
        }
    }

    public void setKeySize(int keySize) throws DOMException {
        Document owner = this.getOwnerDocument();
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size cannot be a non-positive value: " + keySize);
        }
        Element ks = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "KeySize");
        XMLUtils.copyNSPrefix((Element)this.node, ks);
        ks.appendChild(owner.createTextNode(String.valueOf(keySize)));
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2001/04/xmlenc#", "KeySize");
        XMLUtils.insertChild(this.getElement(), ks, nsURIs, localNames);
    }

    public int getKeySize() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize");
        if (nodes.getLength() != 0) {
            return Integer.parseInt(XMLUtils.collectText(nodes.item(0)).trim());
        }
        return 0;
    }

    public void setDigestMethod(String digestMethod) throws DOMException {
        this.setDigestMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "DigestMethod", digestMethod));
    }

    public void setDigestMethod(XSAlgorithmIdentifier digestMethod) throws DOMException {
        String prefix = digestMethod.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            digestMethod.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            digestMethod.addNSPrefixAttr(prefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        XMLUtils.insertChild(this.getElement(), digestMethod.getElement(), nsURIs, localNames);
    }

    public XSAlgorithmIdentifier getDigestMethod() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (nodes.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setOAEPParams(byte[] params) throws DOMException {
        Document owner = this.getOwnerDocument();
        Element op = owner.createElementNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams");
        XMLUtils.copyNSPrefix((Element)this.node, op);
        op.appendChild(owner.createTextNode(Base64.toBase64WithLFSeparator(params)));
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2001/04/xmlenc#", "OAEPparams");
        XMLUtils.insertChild(this.getElement(), op, nsURIs, localNames);
    }

    public byte[] getOAEPParams() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams");
        if (nodes.getLength() != 0) {
            return Base64.fromBase64(XMLUtils.collectText(nodes.item(0)));
        }
        return null;
    }

    public void setMGF(String mgf) {
        this.setMGF(new XSAlgorithmIdentifier(this.getOwnerDocument(), "http://www.w3.org/2009/xmlenc11#", "MGF", mgf));
    }

    public XSAlgorithmIdentifier getMGF() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "MGF");
        if (nodes.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setMGF(XSAlgorithmIdentifier mgf) {
        String prefix = mgf.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            mgf.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2009/xmlenc11#");
        } else {
            mgf.addNSPrefixAttr(prefix, "http://www.w3.org/2009/xmlenc11#");
        }
        XMLUtils.removeChildren(this.getElement(), "http://www.w3.org/2009/xmlenc11#", "MGF");
        XMLUtils.insertChild(this.getElement(), mgf.getElement(), nsURIs, localNames);
    }

    public String getJCEAlgorithm() throws XESchemaException, XECipherException {
        String algURI = this.getAlgorithm();
        if (algURI == null) {
            throw new XESchemaException("Missing algorithm URI.");
        }
        String alg = URIManager.getURIManager().getJCEAlgorithm(algURI);
        if (alg == null) {
            throw new XECipherException("Unsupported encryption algorithm " + algURI);
        }
        return alg;
    }

    public String getJCEKeyAlgorithm() throws XESchemaException, XECipherException {
        String alg = this.getJCEAlgorithm();
        if (alg == null) {
            return null;
        }
        int i = alg.indexOf(47);
        if (i > -1) {
            alg = alg.substring(0, i);
        }
        return alg;
    }

    public int keySize() throws XESchemaException, XECipherException {
        String algURI = this.getAlgorithm();
        if (algURI == null) {
            throw new XESchemaException("Missing algorithm URI.");
        }
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes") || algURI.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 192;
        }
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128") || algURI.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algURI.equals("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
            return 128;
        }
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192") || algURI.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algURI.equals("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
            return 192;
        }
        if (algURI.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256") || algURI.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || algURI.equals("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
            return 256;
        }
        int keySize = this.getKeySize();
        if (keySize == 0) {
            throw new XESchemaException("Key size can't be determined");
        }
        return keySize;
    }
}

