/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import oracle.security.xmlsec.dsig.ReferenceList;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSSignedInfo
extends ReferenceList {
    public XSSignedInfo(Element element) throws DOMException {
        super(element);
    }

    public XSSignedInfo(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XSSignedInfo(Document owner) throws DOMException {
        super(owner, "SignedInfo");
    }

    public XSSignedInfo(Document owner, String id) {
        this(owner);
        if (id != null) {
            this.setId(id);
        }
    }

    public XSSignedInfo(Document owner, String c14nMethod, String signatureMethod) {
        this(owner);
        this.setC14NMethod(c14nMethod);
        this.setSignatureMethod(signatureMethod);
    }

    public XSSignedInfo(Document owner, String c14nMethod, String signatureMethod, String id) {
        this(owner, c14nMethod, signatureMethod);
        if (id != null) {
            this.setId(id);
        }
    }

    public void setC14NMethod(String c14nMethod) throws DOMException {
        this.setC14NMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "CanonicalizationMethod", c14nMethod));
    }

    public void setC14NMethod(XSAlgorithmIdentifier c14nMethod) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(c14nMethod, nList.item(0));
        } else {
            this.appendChild(c14nMethod);
        }
    }

    public XSAlgorithmIdentifier getC14NMethod() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        if (nList.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void setSignatureMethod(String signatureMethod) throws DOMException {
        this.setSignatureMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "SignatureMethod", signatureMethod));
    }

    public void setSignatureMethod(XSAlgorithmIdentifier signatureMethod) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        if (nList.getLength() != 0) {
            this.insertBefore(signatureMethod, nList.item(0));
        } else {
            this.appendChild(signatureMethod);
        }
    }

    public XSAlgorithmIdentifier getSignatureMethod() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
        if (nList.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nList.item(0), this.systemId);
        }
        return null;
    }
}

