/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.xmlsec.dsig.Referable;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.KeyUtils;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.keys.MgmtData;
import oracle.security.xmlsec.keys.PGPData;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.SPKIData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSKeyInfo
extends XMLElement
implements Referable {
    public XSKeyInfo(Element element) throws DOMException {
        super(element);
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    public XSKeyInfo(Element element, String systemId) throws DOMException {
        super(element, systemId);
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    public XSKeyInfo(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    public XSKeyInfo(Document owner, String id) throws DOMException {
        this(owner);
        if (id != null) {
            this.setId(id);
        }
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    public KeyName createKeyName(String name) throws DOMException {
        KeyName kn = KeyUtils.createKeyName(this.getOwnerDocument());
        kn.setName(name);
        return kn;
    }

    public KeyValue createKeyValue() throws DOMException {
        return KeyUtils.createKeyValue(this.getOwnerDocument());
    }

    public KeyValue createKeyValue(PublicKey publicKey) throws DOMException, InvalidKeyException {
        return KeyUtils.createKeyValue(this.getOwnerDocument(), publicKey);
    }

    public X509Data createX509Data() throws DOMException {
        return KeyUtils.createX509Data(this.getOwnerDocument());
    }

    public X509Data createX509Data(X509Certificate cert) throws DOMException {
        X509Data xd = KeyUtils.createX509Data(this.getOwnerDocument());
        xd.addCertificate(cert);
        xd.addIssuerSerial(cert.getIssuerX500Principal(), cert.getSerialNumber());
        xd.addSubjectName(cert.getSubjectX500Principal());
        byte[] ski = XMLUtils.getSKI(cert);
        if (ski != null) {
            xd.addSubjectKeyID(ski);
        }
        return xd;
    }

    public MgmtData createMgmtData() throws DOMException {
        return KeyUtils.createMgmtData(this.getOwnerDocument());
    }

    public MgmtData createMgmtData(String data) throws DOMException {
        MgmtData md = KeyUtils.createMgmtData(this.getOwnerDocument());
        md.setData(data);
        return md;
    }

    public PGPData createPGPData() throws DOMException {
        return KeyUtils.createPGPData(this.getOwnerDocument());
    }

    public SPKIData createSPKIData() throws DOMException {
        return KeyUtils.createSPKIData(this.getOwnerDocument());
    }

    public SPKIData createSPKIData(byte[] sExp) throws DOMException {
        SPKIData sd = KeyUtils.createSPKIData(this.getOwnerDocument());
        sd.setSExpression(sExp);
        return sd;
    }

    public RetrievalMethod createRetrievalMethod() throws DOMException {
        return KeyUtils.createRetrievalMethod(this.getOwnerDocument());
    }

    public RetrievalMethod createRetrievalMethod(String uri, String type) throws DOMException {
        RetrievalMethod rm = KeyUtils.createRetrievalMethod(this.getOwnerDocument());
        rm.setURI(uri);
        rm.setObjectType(type);
        return rm;
    }

    public void addKeyInfoData(XMLElement keyInfoData) throws DOMException {
        if (!(keyInfoData instanceof KeyInfoData)) {
            throw new IllegalArgumentException("oracle.security.xmlsec.keys.KeyInfoData required");
        }
        this.appendChild(keyInfoData);
    }

    public Vector getKeyInfoData() {
        NodeList nList = this.getChildElementsByTagName("*");
        Vector<KeyInfoData> list = new Vector<KeyInfoData>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(KeyUtils.createKeyInfoData((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getKeyNames() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
        Vector<KeyName> list = new Vector<KeyName>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new KeyName((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getKeyValues() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        Vector<KeyValue> list = new Vector<KeyValue>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new KeyValue((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getX509Data() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Data");
        Vector<X509Data> list = new Vector<X509Data>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new X509Data((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getMgmtData() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
        Vector<MgmtData> list = new Vector<MgmtData>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new MgmtData((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getPGPData() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "PGPData");
        Vector<PGPData> list = new Vector<PGPData>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new PGPData((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getSPKIData() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
        Vector<SPKIData> list = new Vector<SPKIData>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new SPKIData((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public Vector getRetrievalMethods() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
        Vector<RetrievalMethod> list = new Vector<RetrievalMethod>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new RetrievalMethod((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    @Override
    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    @Override
    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    @Override
    public String getType() {
        return null;
    }
}

