/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.util.Vector;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ObjectReference
extends XMLElement {
    static CIDResolver cidResolver;

    protected ObjectReference(Element element) throws DOMException {
        super(element);
    }

    protected ObjectReference(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected ObjectReference(Document owner, String tagName) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", tagName);
    }

    protected ObjectReference(Document owner, String tagName, String uri) throws DOMException {
        this(owner, "http://www.w3.org/2000/09/xmldsig#", tagName, uri);
    }

    protected ObjectReference(Document owner, String nsURI, String tagName, String uri) throws DOMException {
        super(owner, nsURI, tagName);
        if (uri != null) {
            this.setURI(uri);
        }
    }

    public static XMLContainer dereference(String uri, Document doc, Element refElem, String systemId) throws ReferenceException {
        if (uri == null) {
            return null;
        }
        XMLContainer result = null;
        if (uri.length() == 0 || uri.startsWith("#")) {
            Node node = null;
            if (uri.startsWith("#") && !uri.equals("#xpointer(/)")) {
                String id = XMLUtils.getIdFromURI(uri);
                if (id != null) {
                    node = XMLUtils.getElementById(doc, id);
                }
                if (node == null) {
                    throw new ReferenceException("Cannot find node with @Id=\"" + id + "\"");
                }
            } else {
                node = doc;
            }
            result = new XMLContainer(node, uri.startsWith("#xpointer("));
        } else if (uri.startsWith("cid:")) {
            result = cidResolver.resolveReference(uri, refElem);
        } else {
            if (!XMLUtils.getAllowAllFlag() && !XMLUtils.getExternalRefFlag()) {
                throw new ReferenceException("External reference cannot be used by default.To use it, change the JVM variable osdt.allow.externalRef to true, but be aware of security risks by using external references");
            }
            result = new XMLContainer(XMLUtils.fixURL(uri, systemId));
        }
        return result;
    }

    protected Object dereference() throws ReferenceException {
        XMLContainer result = ObjectReference.dereference(this.getURI(), this.getOwnerDocument(), this.getElement(), this.getSystemId());
        Vector transforms = this.getTransforms();
        if (transforms.size() > 0) {
            try {
                result = XSTransformer.applyTransforms(result, transforms);
            }
            catch (TransformationException ex) {
                throw new ReferenceException(ex);
            }
        }
        return result;
    }

    public void setURI(String uri) throws DOMException {
        this.setAttribute("URI", uri);
    }

    public String getURI() {
        if (this.hasAttribute("URI")) {
            return this.getAttribute("URI");
        }
        return null;
    }

    public void addTransform(XSAlgorithmIdentifier trans) throws DOMException {
        String name = trans.getLocalName();
        if (name == null) {
            String tn = trans.getTagName();
            int i = tn.indexOf(":");
            String string = name = i == -1 ? tn : tn.substring(i + 1);
        }
        if (!"Transform".equals(name)) {
            throw new IllegalArgumentException("Tag name \"" + name + "\" not allowed for Transform");
        }
        NodeList tsList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transforms");
        Element ts = null;
        if (tsList.getLength() != 0) {
            ts = (Element)tsList.item(0);
        } else {
            ts = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "Transforms");
            XMLUtils.copyNSPrefix((Element)this.node, ts);
            NodeList nList = this.getChildNodes();
            if (nList.getLength() != 0) {
                this.insertBefore(ts, nList.item(0));
            } else {
                this.appendChild(ts);
            }
        }
        ts.appendChild(trans.getNode());
    }

    public Vector getTransforms() {
        NodeList tsList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transforms");
        Vector<XSAlgorithmIdentifier> list = new Vector<XSAlgorithmIdentifier>();
        if (tsList.getLength() != 0) {
            NodeList tList = XMLElement.getChildElementsByTagNameNS((Element)tsList.item(0), "http://www.w3.org/2000/09/xmldsig#", "Transform");
            int n = tList.getLength();
            for (int i = 0; i < n; ++i) {
                list.addElement(new XSAlgorithmIdentifier((Element)tList.item(i), this.systemId));
            }
        }
        return list;
    }

    public static void setCIDResolver(CIDResolver cidResolver) {
        ObjectReference.cidResolver = cidResolver;
    }

    public static interface CIDResolver {
        public XMLContainer resolveReference(String var1, Element var2) throws ReferenceException;
    }
}

