/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.ParserConfigurationException;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSObject;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSigUtils {
    private DSigUtils() {
    }

    public static Document signDetached(String url, PrivateKey privKey, X509Certificate cert) throws IOException, SigningException {
        try {
            boolean useExplicitC14n11 = XMLUtils.getProperty("osdt.useExcplitC14n11") != null;
            XSSignature sig = XSSignature.newInstance(null);
            XSKeyInfo ki = sig.createKeyInfo();
            ki.addKeyInfoData(ki.createX509Data(cert));
            sig.setKeyInfo(ki);
            XSSignedInfo si = sig.createSignedInfo(useExplicitC14n11 ? "http://www.w3.org/2006/12/xml-c14n11" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", DSigUtils.getSigMethodURI(privKey), null);
            sig.setSignedInfo(si);
            XSReference ref = sig.createReference();
            ref.setURI(url);
            ref.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
            if (useExplicitC14n11) {
                ref.addTransform(sig.createTransform("http://www.w3.org/2006/12/xml-c14n11"));
            }
            si.addReference(ref);
            sig.sign(privKey, null);
            return sig.getOwnerDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new SigningException(ex);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex);
        }
    }

    public static Document signEnveloped(Document doc, PrivateKey privKey, X509Certificate cert) throws SigningException {
        boolean useExplicitC14n11 = XMLUtils.getProperty("osdt.useExcplitC14n11") != null;
        Node root = doc.getDocumentElement();
        if (root == null) {
            root = doc;
        }
        XSSignature sig = XSSignature.newInstance(doc, null);
        sig.appendTo(root);
        XSKeyInfo ki = sig.createKeyInfo();
        ki.addKeyInfoData(ki.createX509Data(cert));
        sig.setKeyInfo(ki);
        XSSignedInfo si = sig.createSignedInfo(useExplicitC14n11 ? "http://www.w3.org/2006/12/xml-c14n11" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", DSigUtils.getSigMethodURI(privKey), null);
        sig.setSignedInfo(si);
        XSReference ref = sig.createReference();
        ref.setURI("");
        ref.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        if (useExplicitC14n11) {
            ref.addTransform(sig.createTransform("http://www.w3.org/2006/12/xml-c14n11"));
        }
        si.addReference(ref);
        XSAlgorithmIdentifier est = sig.createTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        ref.addTransform(est);
        try {
            sig.sign(privKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex);
        }
        return doc;
    }

    public static Document signEnveloping(Document doc, PrivateKey privKey, X509Certificate cert) throws SigningException {
        try {
            boolean useExplicitC14n11 = XMLUtils.getProperty("osdt.useExcplitC14n11") != null;
            NodeList tbsList = doc.getChildNodes();
            if (tbsList.getLength() == 0) {
                throw new IllegalArgumentException("Input document contains no data");
            }
            XSSignature sig = XSSignature.newInstance(null);
            Document sigDoc = sig.getOwnerDocument();
            String objId = "DSig.Object_" + XMLUtils.randomName();
            XSObject obj = sig.createObject(objId, "text/xml", null);
            int len = tbsList.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = tbsList.item(i);
                if (n.getNodeType() == 10) continue;
                obj.appendChild(sigDoc.importNode(n, true));
            }
            sig.addObject(obj);
            XSKeyInfo ki = sig.createKeyInfo();
            ki.addKeyInfoData(ki.createX509Data(cert));
            sig.setKeyInfo(ki);
            XSSignedInfo si = sig.createSignedInfo(useExplicitC14n11 ? "http://www.w3.org/2006/12/xml-c14n11" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", DSigUtils.getSigMethodURI(privKey), null);
            sig.setSignedInfo(si);
            XSReference ref = sig.createReference(null, "#" + objId, "http://www.w3.org/2000/09/xmldsig#Object", "http://www.w3.org/2000/09/xmldsig#sha1");
            if (useExplicitC14n11) {
                ref.addTransform(sig.createTransform("http://www.w3.org/2006/12/xml-c14n11"));
            }
            si.addReference(ref);
            sig.sign(privKey, null);
            return sigDoc;
        }
        catch (TransformationException ex) {
            throw new SigningException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new SigningException(ex);
        }
    }

    public static Document signSubTree(Element subTree, String idAttrName, PrivateKey privKey, X509Certificate cert) throws SigningException {
        boolean useExplicitC14n11 = XMLUtils.getProperty("osdt.useExcplitC14n11") != null;
        Document doc = subTree.getOwnerDocument();
        Element root = doc.getDocumentElement();
        if (root == null || root == subTree) {
            throw new SigningException("Sub-tree may not be rooted in document root element");
        }
        XSSignature sig = XSSignature.newInstance(doc, null);
        sig.appendTo(root);
        XSKeyInfo ki = sig.createKeyInfo();
        ki.addKeyInfoData(ki.createX509Data(cert));
        sig.setKeyInfo(ki);
        XSSignedInfo si = sig.createSignedInfo(useExplicitC14n11 ? "http://www.w3.org/2006/12/xml-c14n11" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", DSigUtils.getSigMethodURI(privKey), null);
        sig.setSignedInfo(si);
        String uri = subTree.getAttribute(idAttrName);
        if (uri == null || uri.length() == 0) {
            throw new SigningException("Reference target ID attribute value not found");
        }
        XSReference ref = sig.createReference();
        ref.setURI(uri);
        ref.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        if (useExplicitC14n11) {
            ref.addTransform(sig.createTransform("http://www.w3.org/2006/12/xml-c14n11"));
        }
        si.addReference(ref);
        try {
            sig.sign(privKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex);
        }
        return doc;
    }

    public static boolean verify(Document doc) throws VerifyException {
        return DSigUtils.verify(doc, null);
    }

    public static boolean verify(Document doc, PublicKey pubKey) throws VerifyException {
        NodeList sigList = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (sigList.getLength() == 0) {
            throw new IllegalArgumentException("No XML-DSIG Signature elements found.");
        }
        int n = sigList.getLength();
        for (int s = 0; s < n; ++s) {
            XSSignature sig = new XSSignature((Element)sigList.item(s));
            if (!(pubKey == null ? !sig.verify() : !sig.verify(pubKey))) continue;
            return false;
        }
        return true;
    }

    private static String getSigMethodURI(PrivateKey privKey) throws SigningException {
        String keyAlg = privKey.getAlgorithm();
        if ("RSA".equals(keyAlg)) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if ("DSA".equals(keyAlg)) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        throw new SigningException("Unsupported key algorithm " + keyAlg);
    }
}

