/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.reports.CheckResultDescription;
import com.oracle.premigration.reports.text.TextReport;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import com.oracle.premigration.reports.text.serialization.TextReportTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TextReportResultDescriptionTable
extends TextReportTable {
    private Map<String, TextValueHint> valueHints;

    public TextReportResultDescriptionTable(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
    }

    @Override
    public List<Map<String, String>> getMapValues() {
        List resultDescriptions = (List)this.value;
        ArrayList<Map<String, String>> mapValues = new ArrayList<Map<String, String>>();
        this.valueHints = new HashMap<String, TextValueHint>();
        for (CheckResultDescription resultDescription : resultDescriptions) {
            EnumMap<TextReportSectionName, TextReportSection> checkResultSections = new EnumMap<TextReportSectionName, TextReportSection>(TextReportSectionName.class);
            TextReport.scanFieldsToCreateSections(this.reportContext, checkResultSections, resultDescription);
            TreeMap<String, String> mapRow = new TreeMap<String, String>();
            TextReportSection descriptionSection = (TextReportSection)checkResultSections.get((Object)TextReportSectionName.RESULT_LEGEND);
            for (String key : descriptionSection.getFieldListKeySet()) {
                TextReportLabeledValue reportField = (TextReportLabeledValue)descriptionSection.getField(key);
                mapRow.put(reportField.getLabelText(), reportField.getValue().toString());
                this.valueHints.put(reportField.getLabelText(), reportField.getValueHint());
            }
            mapValues.add(mapRow);
        }
        return mapValues;
    }

    @Override
    public Map<String, TextValueHint> getMapHints() {
        return this.valueHints;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportResultDescriptionTable)) {
            return false;
        }
        TextReportResultDescriptionTable other = (TextReportResultDescriptionTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, TextValueHint> this$valueHints = this.valueHints;
        Map<String, TextValueHint> other$valueHints = other.valueHints;
        return !(this$valueHints == null ? other$valueHints != null : !((Object)this$valueHints).equals(other$valueHints));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportResultDescriptionTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, TextValueHint> $valueHints = this.valueHints;
        result = result * 59 + ($valueHints == null ? 43 : ((Object)$valueHints).hashCode());
        return result;
    }
}

