/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextValueHint;
import java.text.BreakIterator;

public class TextReportDisplayElement {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportDisplayElement.class.getName());
    private String value;
    private TextValueHint valueTypeHint;

    public TextReportDisplayElement(String value, TextValueHint valueTypeHint) {
        this.value = valueTypeHint == TextValueHint.SQL_TEXT ? value.replace("\n", " ") : value;
        this.valueTypeHint = valueTypeHint;
    }

    public boolean hasDataRemaining() {
        return this.value.length() > 0;
    }

    public String getSomeText(int amountOfText) {
        return this.getSomeText(amountOfText, false);
    }

    public String getSomeText(int amountOfText, boolean applyPadding) {
        String text;
        if (!this.hasDataRemaining()) {
            if (applyPadding) {
                return Utilities.padRight("", amountOfText);
            }
            return "";
        }
        if (this.valueTypeHint == TextValueHint.NATURAL_LANGUAGE && this.value.length() > amountOfText) {
            BreakIterator bi = BreakIterator.getWordInstance();
            bi.setText(this.value);
            if (bi.isBoundary(amountOfText)) {
                text = this.value.substring(0, amountOfText);
            } else {
                int preceding = bi.preceding(amountOfText);
                if (preceding < 2) {
                    preceding = amountOfText + 1;
                }
                text = this.value.substring(0, preceding - 1);
            }
            bi.setText(text);
            int start = bi.first();
            int previous = bi.last();
            while (start < previous && previous > 0) {
                char testChar = text.charAt(previous - 1);
                if (testChar == '(') {
                    --previous;
                    break;
                }
                if (testChar == ')') {
                    if (previous == text.length() && previous < this.value.length() && this.value.charAt(previous) == ',') {
                        --previous;
                    } else if (previous < text.length() && text.charAt(previous) == ',') {
                        ++previous;
                        break;
                    }
                }
                if ((previous = bi.preceding(previous)) == -1 || !Character.isWhitespace(text.charAt(previous))) continue;
                break;
            }
            if (previous > 0) {
                text = this.value.substring(0, previous);
            }
            this.value = this.value.substring(text.length()).trim();
        } else {
            text = this.value.substring(0, Math.min(this.value.length(), amountOfText));
            if (this.value.length() >= amountOfText) {
                int preceding;
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText(this.value);
                if (!bi.isBoundary(amountOfText) && (preceding = bi.preceding(amountOfText)) > 1) {
                    text = this.value.substring(0, preceding - 1);
                }
            }
            this.value = this.value.substring(text.length());
        }
        if (applyPadding && amountOfText > text.length()) {
            text = Utilities.padRight(text, amountOfText);
        }
        return text;
    }

    public String getValue() {
        return this.value;
    }

    public TextValueHint getValueTypeHint() {
        return this.valueTypeHint;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueTypeHint(TextValueHint valueTypeHint) {
        this.valueTypeHint = valueTypeHint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportDisplayElement)) {
            return false;
        }
        TextReportDisplayElement other = (TextReportDisplayElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        TextValueHint this$valueTypeHint = this.getValueTypeHint();
        TextValueHint other$valueTypeHint = other.getValueTypeHint();
        return !(this$valueTypeHint == null ? other$valueTypeHint != null : !((Object)((Object)this$valueTypeHint)).equals((Object)other$valueTypeHint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportDisplayElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        TextValueHint $valueTypeHint = this.getValueTypeHint();
        result = result * 59 + ($valueTypeHint == null ? 43 : ((Object)((Object)$valueTypeHint)).hashCode());
        return result;
    }

    public String toString() {
        return "TextReportDisplayElement(value=" + this.getValue() + ", valueTypeHint=" + (Object)((Object)this.getValueTypeHint()) + ")";
    }
}

