/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.helpers.Utilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TextReportContext {
    private PrintWriter printWriter;
    private int reportWidth;
    private Integer maxRelevantDataRows;
    private boolean sqlExcluded;
    String textReportPath;
    private String dashedLine;
    private String solidLine;
    private String parallelDashedLine;

    private TextReportContext(PrintWriter printWriter, int reportWidth, boolean isSqlInTextReport, Integer maxTextRows) {
        this.printWriter = printWriter;
        this.reportWidth = reportWidth;
        this.maxRelevantDataRows = maxTextRows == null ? Integer.MAX_VALUE : maxTextRows;
        this.sqlExcluded = !isSqlInTextReport;
        this.dashedLine = Utilities.repeatCharacter(reportWidth, '~');
        this.solidLine = Utilities.repeatCharacter(reportWidth, '-');
        this.parallelDashedLine = Utilities.repeatCharacter(reportWidth, '=');
    }

    public static TextReportContext createTextReportContext(CommandLineArgs cla, String textPath) throws IOException {
        File reportFile = new File(textPath);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(reportFile)));
        TextReportContext reportContext = new TextReportContext(printWriter, 132, cla.isSqlInTextReport(), cla.getMaxTextRows());
        reportContext.setTextReportPath(reportFile.getCanonicalPath());
        return reportContext;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public int getReportWidth() {
        return this.reportWidth;
    }

    public Integer getMaxRelevantDataRows() {
        return this.maxRelevantDataRows;
    }

    public boolean isSqlExcluded() {
        return this.sqlExcluded;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setReportWidth(int reportWidth) {
        this.reportWidth = reportWidth;
    }

    public void setMaxRelevantDataRows(Integer maxRelevantDataRows) {
        this.maxRelevantDataRows = maxRelevantDataRows;
    }

    public void setSqlExcluded(boolean sqlExcluded) {
        this.sqlExcluded = sqlExcluded;
    }

    public void setDashedLine(String dashedLine) {
        this.dashedLine = dashedLine;
    }

    public void setSolidLine(String solidLine) {
        this.solidLine = solidLine;
    }

    public void setParallelDashedLine(String parallelDashedLine) {
        this.parallelDashedLine = parallelDashedLine;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportContext)) {
            return false;
        }
        TextReportContext other = (TextReportContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReportWidth() != other.getReportWidth()) {
            return false;
        }
        if (this.isSqlExcluded() != other.isSqlExcluded()) {
            return false;
        }
        Integer this$maxRelevantDataRows = this.getMaxRelevantDataRows();
        Integer other$maxRelevantDataRows = other.getMaxRelevantDataRows();
        if (this$maxRelevantDataRows == null ? other$maxRelevantDataRows != null : !((Object)this$maxRelevantDataRows).equals(other$maxRelevantDataRows)) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        if (this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter)) {
            return false;
        }
        String this$textReportPath = this.getTextReportPath();
        String other$textReportPath = other.getTextReportPath();
        if (this$textReportPath == null ? other$textReportPath != null : !this$textReportPath.equals(other$textReportPath)) {
            return false;
        }
        String this$dashedLine = this.getDashedLine();
        String other$dashedLine = other.getDashedLine();
        if (this$dashedLine == null ? other$dashedLine != null : !this$dashedLine.equals(other$dashedLine)) {
            return false;
        }
        String this$solidLine = this.getSolidLine();
        String other$solidLine = other.getSolidLine();
        if (this$solidLine == null ? other$solidLine != null : !this$solidLine.equals(other$solidLine)) {
            return false;
        }
        String this$parallelDashedLine = this.getParallelDashedLine();
        String other$parallelDashedLine = other.getParallelDashedLine();
        return !(this$parallelDashedLine == null ? other$parallelDashedLine != null : !this$parallelDashedLine.equals(other$parallelDashedLine));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReportWidth();
        result = result * 59 + (this.isSqlExcluded() ? 79 : 97);
        Integer $maxRelevantDataRows = this.getMaxRelevantDataRows();
        result = result * 59 + ($maxRelevantDataRows == null ? 43 : ((Object)$maxRelevantDataRows).hashCode());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        String $textReportPath = this.getTextReportPath();
        result = result * 59 + ($textReportPath == null ? 43 : $textReportPath.hashCode());
        String $dashedLine = this.getDashedLine();
        result = result * 59 + ($dashedLine == null ? 43 : $dashedLine.hashCode());
        String $solidLine = this.getSolidLine();
        result = result * 59 + ($solidLine == null ? 43 : $solidLine.hashCode());
        String $parallelDashedLine = this.getParallelDashedLine();
        result = result * 59 + ($parallelDashedLine == null ? 43 : $parallelDashedLine.hashCode());
        return result;
    }

    public String toString() {
        return "TextReportContext(printWriter=" + this.getPrintWriter() + ", reportWidth=" + this.getReportWidth() + ", maxRelevantDataRows=" + this.getMaxRelevantDataRows() + ", sqlExcluded=" + this.isSqlExcluded() + ", textReportPath=" + this.getTextReportPath() + ", dashedLine=" + this.getDashedLine() + ", solidLine=" + this.getSolidLine() + ", parallelDashedLine=" + this.getParallelDashedLine() + ")";
    }

    public String getTextReportPath() {
        return this.textReportPath;
    }

    public void setTextReportPath(String textReportPath) {
        this.textReportPath = textReportPath;
    }

    public String getDashedLine() {
        return this.dashedLine;
    }

    public String getSolidLine() {
        return this.solidLine;
    }

    public String getParallelDashedLine() {
        return this.parallelDashedLine;
    }
}

