/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.ResultSetProcessor;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SqlUtils {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SqlUtils.class.getName());

    private SqlUtils() {
    }

    public static String getSingleString(String sqlQuery, ExecutionContext exeCtx) throws SQLException {
        return SqlUtils.getSingleString(sqlQuery, "", exeCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSingleString(String sqlQuery, String defaultValue, ExecutionContext exeCtx) throws SQLException {
        String result = defaultValue;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, sqlQuery);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSingleLong(String sqlQuery, ExecutionContext exeCtx) throws SQLException {
        long result = 0L;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, sqlQuery);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.Date getSingleDate(String sqlQuery, ExecutionContext exeCtx) throws SQLException {
        java.util.Date result = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, sqlQuery);
            rs = stmt.executeQuery();
            if (rs.next()) {
                Date sqlDate = rs.getDate(1);
                result = new java.util.Date(sqlDate.getTime());
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStringList(String sqlQuery, ExecutionContext exeCtx) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, sqlQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return result;
    }

    public static List<Map<String, String>> resultSetToListMap(ResultSet rs) throws SQLException {
        ResultSetProcessor.RSProcessorInputs inputs = ResultSetProcessor.RSProcessorInputs.builder().resultSet(rs).maxRelevantObjects(null).filter(null).filterCriteria(null).build();
        ResultSetProcessor.RSProcessorOutputs outputs = ResultSetProcessor.processResultSet(inputs);
        return outputs.getRelevantObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, String>> getMaps(ExecutionContext exeCtx, String versionDataSQL) throws SQLException {
        List<Map<String, String>> list;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, versionDataSQL);
            rs = stmt.executeQuery();
            list = SqlUtils.resultSetToListMap(rs);
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return list;
    }

    public static List<String> getAnalysedSchemaNames(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String sqlQuery = "SELECT USERNAME FROM SYS.ALL_USERS " + whereClause;
        return SqlUtils.getStringList(sqlQuery, exeCtx);
    }

    public static List<String> getExcludedSchemaDefaults(ExecutionContext exeCtx) throws SQLException {
        List<String> excludeList;
        List<String> noOracleMaintainedNames = Arrays.asList("ANONYMOUS", "APEX_PUBLIC_USER", "CTXSYS", "DBSNMP", "DIP", "EXFSYS", "FLOWS_040100", "FLOWS_FILES", "LBACSYS", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORACLE_OCM", "ORDDATA", "ORDPLUGINS", "ORDSYS", "OUTLN", "OWBSYS", "SI_INFORMTN_SCHEMA", "SPATIAL_CSW_ADMIN_USR", "SPATIAL_WFS_ADMIN_USR", "SYS", "SYSMAN", "SYSTEM", "WKPROXY", "WKSYS", "WK_TEST", "WMSYS", "XDB", "XS$NULL");
        boolean dbaUsersHasOracleMaintained = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_USERS").column("ORACLE_MAINTAINED").build());
        if (dbaUsersHasOracleMaintained) {
            excludeList = SqlUtils.getStringList("SELECT NAME AS USERNAME FROM SYS.KU_NOEXP_VIEW WHERE OBJ_TYPE='SCHEMA' UNION SELECT USERNAME FROM SYS.DBA_USERS WHERE ORACLE_MAINTAINED = 'Y'", exeCtx);
        } else {
            excludeList = SqlUtils.getStringList("SELECT NAME AS USERNAME FROM SYS.KU_NOEXP_VIEW WHERE OBJ_TYPE='SCHEMA'", exeCtx);
            excludeList.removeAll(noOracleMaintainedNames);
            excludeList.addAll(noOracleMaintainedNames);
        }
        if (exeCtx.isAutonomousSource()) {
            List<String> adbExludedNames = Arrays.asList("ADMIN", "DS$ADMIN", "GGADMIN", "ORDS_METADATA");
            for (String schemaName : adbExludedNames) {
                if (excludeList.contains(schemaName)) continue;
                excludeList.add(schemaName);
            }
        }
        return excludeList;
    }

    public static List<Map<String, String>> getPatchInfo(ExecutionContext exeCtx) throws SQLException {
        String patchInfoQuery;
        String dbaRegistryHistory = "SELECT RH.COMMENTS, RH.VERSION AS SOURCE_VERSION, NULL AS TARGET_VERSION, RH.ACTION, TO_CHAR(RH.ACTION_TIME, 'DD-MON-YYYY HH24:MI:SS') AS ACTION_TIME FROM SYS.DBA_REGISTRY_HISTORY RH";
        long count = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_VIEWS WHERE VIEW_NAME='DBA_REGISTRY_SQLPATCH' AND OWNER='SYS'", exeCtx);
        if (count > 0L) {
            count = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='DBA_REGISTRY_SQLPATCH' AND COLUMN_NAME='VERSION' AND OWNER='SYS'", exeCtx);
            String versionColumn = count > 0L ? "RSP.VERSION AS SOURCE_VERSION" : ((count = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='DBA_REGISTRY_SQLPATCH' AND COLUMN_NAME='SOURCE_VERSION' AND OWNER='SYS'", exeCtx)) > 0L ? "RSP.SOURCE_VERSION" : "NULL AS SOURCE_VERSION");
            count = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='DBA_REGISTRY_SQLPATCH' AND COLUMN_NAME='TARGET_VERSION' AND OWNER='SYS'", exeCtx);
            String targetVersionColumn = count > 0L ? "RSP.TARGET_VERSION" : "NULL AS TARGET_VERSION";
            String dbaRegistrySqlPatch = "SELECT RSP.DESCRIPTION, " + versionColumn + "," + targetVersionColumn + ",RSP.ACTION, TO_CHAR(RSP.ACTION_TIME, 'DD-MON-YYYY HH24:MI:SS') AS ACTION_TIME FROM SYS.DBA_REGISTRY_SQLPATCH RSP";
            patchInfoQuery = "SELECT RH.COMMENTS, RH.VERSION AS SOURCE_VERSION, NULL AS TARGET_VERSION, RH.ACTION, TO_CHAR(RH.ACTION_TIME, 'DD-MON-YYYY HH24:MI:SS') AS ACTION_TIME FROM SYS.DBA_REGISTRY_HISTORY RH UNION ALL " + dbaRegistrySqlPatch;
        } else {
            patchInfoQuery = "SELECT RH.COMMENTS, RH.VERSION AS SOURCE_VERSION, NULL AS TARGET_VERSION, RH.ACTION, TO_CHAR(RH.ACTION_TIME, 'DD-MON-YYYY HH24:MI:SS') AS ACTION_TIME FROM SYS.DBA_REGISTRY_HISTORY RH";
        }
        return SqlUtils.getMaps(exeCtx, patchInfoQuery);
    }

    public static List<Map<String, String>> getVersionData(ExecutionContext exeCtx) throws SQLException {
        long count = SqlUtils.getSingleLong("SELECT COUNT(*) AS COUNT FROM SYS.DBA_TAB_COLS WHERE TABLE_NAME='PRODUCT_COMPONENT_VERSION' AND COLUMN_NAME='VERSION_FULL' AND OWNER='SYS'", exeCtx);
        String versionDataSQL = count > 0L ? "SELECT PRODUCT, VERSION, VERSION_FULL, STATUS FROM SYS.PRODUCT_COMPONENT_VERSION" : "SELECT PRODUCT, VERSION, STATUS FROM SYS.PRODUCT_COMPONENT_VERSION";
        return SqlUtils.getMaps(exeCtx, versionDataSQL);
    }

    public static String getDatabaseForceLogging(ExecutionContext exeCtx) {
        String dbForceLogging;
        try {
            dbForceLogging = SqlUtils.getSingleString("SELECT NVL(FORCE_LOGGING,'NO') FROM V$DATABASE", "NO", exeCtx);
        }
        catch (SQLException e) {
            log.warning("Error encountered querying FORCE_LOGGING; defaulting to 'NO'", e);
            dbForceLogging = "NO";
        }
        return dbForceLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getInvalidSchemaNames(List<String> schemaNames, ExecutionContext exeCtx) throws SQLException {
        if (schemaNames == null || schemaNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> foundNames = new ArrayList<String>();
        List<String> bindPlaceholders = Collections.nCopies(schemaNames.size(), "?");
        String whereClause = SqlUtils.createWhereClause("USERNAME", true, bindPlaceholders);
        String whereClauseBind = whereClause.replace("'", "");
        String sqlQuery = "SELECT USERNAME FROM SYS.ALL_USERS " + whereClauseBind;
        log.fine("Query to fetch usernames: " + sqlQuery);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, sqlQuery);
            int index = 1;
            for (String schemaName : schemaNames) {
                stmt.setString(index++, schemaName);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                foundNames.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        ArrayList<String> schemaNamesList = new ArrayList<String>(schemaNames);
        schemaNamesList.removeAll(foundNames);
        return schemaNamesList;
    }

    public static List<String> quotifySqlNames(List<String> rawSqlNames) {
        if (rawSqlNames == null || rawSqlNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> quotedSqlNames = new ArrayList<String>();
        for (String name : rawSqlNames) {
            String quotedName = "'" + name.replace("'", "''") + "'";
            quotedSqlNames.add(quotedName);
        }
        return quotedSqlNames;
    }

    private static String createClause(String conjunction, String columnName, boolean inClause, List<String> rawSqlNames) {
        if (rawSqlNames == null || rawSqlNames.isEmpty()) {
            return " " + conjunction + " 1=1 ";
        }
        int maxTermsAllowed = 1000;
        int numberOfTerms = rawSqlNames.size();
        List<String> enquotedNames = SqlUtils.quotifySqlNames(rawSqlNames);
        StringBuilder sqlClauseBuilder = new StringBuilder(" ").append(conjunction).append(" ");
        if (numberOfTerms > 1000) {
            sqlClauseBuilder.append("(");
        }
        int termCounter = 0;
        int numberRemaining = numberOfTerms;
        do {
            sqlClauseBuilder.append(columnName).append(inClause ? " IN " : " NOT IN ").append("(");
            int subListCount = Math.min(1000, numberRemaining);
            String commaSeparatedList = Utilities.join(",", enquotedNames.subList(termCounter, termCounter + subListCount));
            sqlClauseBuilder.append(commaSeparatedList);
            sqlClauseBuilder.append(")");
            numberRemaining -= subListCount;
            if ((termCounter += subListCount) >= numberOfTerms) continue;
            sqlClauseBuilder.append(" OR ");
        } while (numberRemaining > 0);
        if (numberOfTerms > 1000) {
            sqlClauseBuilder.append(")");
        }
        String sqlClause = sqlClauseBuilder.toString();
        log.trace("createClause: " + sqlClause);
        return sqlClause;
    }

    public static String createAndClause(String columnName, boolean andIn, List<String> rawSqlNames) {
        return SqlUtils.createClause("AND", columnName, andIn, rawSqlNames);
    }

    public static String createWhereClause(String columnName, boolean whereIn, List<String> rawSqlNames) {
        return SqlUtils.createClause("WHERE", columnName, whereIn, rawSqlNames);
    }

    public static String createWhereInClause(String columnName, List<String> rawSqlNames) {
        return SqlUtils.createWhereClause(columnName, true, rawSqlNames);
    }

    public static String createWhereNotInClause(String columnName, List<String> rawSqlNames) {
        return SqlUtils.createWhereClause(columnName, false, rawSqlNames);
    }

    public static String createWhereClauseForOwnerColumn(ExecutionContext exeCtx) {
        return SqlUtils.createWhereClauseForColumn(exeCtx, "OWNER");
    }

    public static String createWhereClauseForColumn(ExecutionContext exeCtx, String columnText) {
        List<String> targetSchemas = exeCtx.getSourceSchemas();
        List<String> excludeSchemas = exeCtx.getExcludeSchemas();
        boolean includeWhere = targetSchemas != null && !targetSchemas.isEmpty();
        return includeWhere ? SqlUtils.createWhereInClause(columnText, targetSchemas) : SqlUtils.createWhereNotInClause(columnText, excludeSchemas);
    }

    public static String createAndOfOrClauses(List<String> columnNames, boolean orIn, List<String> rawSqlNames) {
        ArrayList<String> orClauses = new ArrayList<String>();
        for (String columnName : columnNames) {
            String orClause = SqlUtils.createClause("", columnName, orIn, rawSqlNames);
            orClauses.add(orClause);
        }
        String joinedOrClauses = Utilities.join(" OR ", orClauses);
        String completeClause = " AND ( " + joinedOrClauses + ")";
        log.trace("createAndOfOrClauses: " + completeClause);
        return completeClause;
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String sqlQuery) throws SQLException {
        return conn.prepareStatement(sqlQuery, 1003, 1007);
    }

    public static List<String> getDirectoryNamesNotOnTarget(ExecutionContext exeCtx, List<String> srcDirectories) throws SQLException {
        List<String> srcDirectoryList = SqlUtils.getStringList("SELECT DIRECTORY_NAME FROM SYS.DBA_DIRECTORIES", exeCtx);
        srcDirectories.clear();
        srcDirectories.addAll(srcDirectoryList);
        String targetDirectoriesString = exeCtx.getAnalysisProperty(SourceAnalysisProp.DIRECTORIES.getKey());
        return Utilities.getNamesNotInString(srcDirectoryList, targetDirectoriesString);
    }

    public static List<String> cleanAndValidateTablespaceNamesValue(List<String> tablespaceList, ExecutionContext exeCtx, String propertyName) {
        ArrayList<String> cleanTablespaceNames = new ArrayList<String>();
        ArrayList<String> invalidNames = new ArrayList<String>();
        for (String tablespace : tablespaceList) {
            String trimTablespace = tablespace.trim();
            if (exeCtx.getTablespacesNames().contains(trimTablespace)) {
                cleanTablespaceNames.add(trimTablespace);
                continue;
            }
            invalidNames.add(trimTablespace);
        }
        if (!invalidNames.isEmpty()) {
            String invalidTablespaces = Utilities.join(",", invalidNames);
            String errorMessage = "Tablespace name(s) in analysis property '" + propertyName + "' not found on source instance: " + invalidTablespaces;
            log.warning(errorMessage);
        }
        return cleanTablespaceNames;
    }

    public static String getTableAndColumnNameQuery(DatabaseObject dbObj) {
        StringBuilder sqlQueryBuilder = new StringBuilder("SELECT COUNT(*) AS COUNT FROM ");
        sqlQueryBuilder.append(" SYS.DBA_TAB_COLS WHERE TABLE_NAME='").append(dbObj.getTable()).append("' ");
        if (dbObj.getColumn() != null) {
            sqlQueryBuilder.append(" AND COLUMN_NAME='").append(dbObj.getColumn()).append("'");
        }
        if (dbObj.getSchema() != null) {
            sqlQueryBuilder.append(" AND OWNER='").append(dbObj.getSchema()).append("'");
        }
        return sqlQueryBuilder.toString();
    }

    public static String getViewAndColumnNameQuery(DatabaseObject dbObj) {
        StringBuilder sqlQueryBuilder = new StringBuilder("SELECT COUNT(*) AS COUNT FROM ");
        if (dbObj.getColumn() == null) {
            sqlQueryBuilder.append(" SYS.DBA_VIEWS WHERE VIEW_NAME='").append(dbObj.getView()).append("' ");
            if (dbObj.getSchema() != null) {
                sqlQueryBuilder.append(" AND OWNER='").append(dbObj.getSchema()).append("'");
            }
        } else {
            sqlQueryBuilder.append(" SYS.DBA_VIEWS V, SYS.DBA_TAB_COLS C WHERE V.VIEW_NAME='").append(dbObj.getView()).append("' ");
            sqlQueryBuilder.append(" AND C.TABLE_NAME=V.VIEW_NAME");
            sqlQueryBuilder.append(" AND C.COLUMN_NAME='").append(dbObj.getColumn()).append("'");
            if (dbObj.getSchema() != null) {
                sqlQueryBuilder.append(" AND C.OWNER='").append(dbObj.getSchema()).append("'");
                sqlQueryBuilder.append(" AND V.OWNER='").append(dbObj.getSchema()).append("'");
            }
        }
        return sqlQueryBuilder.toString();
    }
}

