/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class timezone_table_compatibility_higher
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(timezone_table_compatibility_higher.class.getName());
    private String targetTzVersion;

    public timezone_table_compatibility_higher() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.targetTzVersion = exeCtx.getAnalysisProperty(TargetInstanceProp.TZ_VERSION.getKey());
        if (this.targetTzVersion == null || !Utilities.isInteger(this.targetTzVersion)) {
            this.setAction(this.lang.txt("CHECK.TIMEZONE_TABLE_COMPATIBILITY_HIGHER.ACTION_NO_TARGET_TZ"));
            this.skipCheck(this.lang.txt("CHECK.TIMEZONE_TABLE_COMPATIBILITY_HIGHER.SKIPPED_NO_TARGET_TZ"), CheckResult.WARNING);
        } else {
            this.setSqlQuery("SELECT '" + this.targetTzVersion + "' AS TARGET_TZ_VERSION, CAST(VERSION AS VARCHAR2(100)) AS SOURCE_TZ_VERSION FROM V$TIMEZONE_FILE");
        }
    }

    @Override
    public CheckResult determineResult() {
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().size() != 1) {
            return CheckResult.BLOCKER;
        }
        try {
            String srcTzStr = this.getRelevantObjectsData().get(0).get("SOURCE_TZ_VERSION");
            int srcTzNum = Integer.parseInt(srcTzStr);
            int targetTzNum = Integer.parseInt(this.targetTzVersion);
            log.info("using " + targetTzNum + " as target TZ_VERSION");
            if (srcTzNum <= targetTzNum) {
                return CheckResult.PASS;
            }
            return CheckResult.BLOCKER;
        }
        catch (Exception e) {
            String checkFailMsg = Utilities.getErrorText("ERROR2001", e, "TZ_VERSION", this.getName());
            this.setErrorMessage(checkFailMsg);
            log.severe(checkFailMsg, e);
            return CheckResult.BLOCKER;
        }
    }
}

