/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class nls_character_set_conversion
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(nls_character_set_conversion.class.getName());
    private static final String SYS = "SYS";
    private static final String SYSTEM = "SYSTEM";
    private static final String DUM$DATABASE = "DUM$DATABASE";
    private static final String DUM$COLUMNS = "DUM$COLUMNS";
    private String scanDateTime = null;

    public nls_character_set_conversion() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare(ExecutionContext exeCtx) {
        String schemaDUM$COLUMNS;
        block25: {
            String databaseCharsetMessage;
            block24: {
                String sqlQuery;
                String schemaDUM$DATABASE;
                block23: {
                    String sourceDatabaseCharacterSet;
                    try {
                        String sqlQuery2 = "SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_CHARACTERSET'";
                        sourceDatabaseCharacterSet = SqlUtils.getSingleString("SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_CHARACTERSET'", exeCtx);
                    }
                    catch (Exception e) {
                        log.severe("error fetching NLS_CHARACTERSET", e);
                        this.skipCheck(e.getMessage(), CheckResult.FATAL);
                        return;
                    }
                    String targetDatabaseCharacterSet = exeCtx.getAnalysisProperty(TargetInstanceProp.NLS_CHARACTERSET.getKey(), "AL32UTF8");
                    databaseCharsetMessage = this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.SOURCE_TARGET_DBCS", sourceDatabaseCharacterSet, targetDatabaseCharacterSet);
                    if (targetDatabaseCharacterSet.equals(sourceDatabaseCharacterSet)) {
                        String message = this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.SAME_DBCS", targetDatabaseCharacterSet);
                        this.skipCheck(message, CheckResult.PASS);
                        return;
                    }
                    if (!"AL32UTF8".equals(targetDatabaseCharacterSet) && !"UTF8".equals(targetDatabaseCharacterSet)) {
                        String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.NON_UNICODE_TARGET"));
                        this.skipCheck(message, CheckResult.WARNING);
                        return;
                    }
                    if (exeCtx.hasDatabaseObject(DatabaseObject.builder().schema(SYS).table(DUM$DATABASE).column("DDBCS_ID").build())) {
                        schemaDUM$DATABASE = "SYS.DUM$DATABASE";
                    } else {
                        if (!exeCtx.hasDatabaseObject(DatabaseObject.builder().schema(SYSTEM).table(DUM$DATABASE).column("DDBCS_ID").build())) {
                            String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.DMU_REPO_NOT_FOUND"));
                            this.skipCheck(message, CheckResult.BLOCKER);
                            return;
                        }
                        schemaDUM$DATABASE = "SYSTEM.DUM$DATABASE";
                    }
                    if (exeCtx.hasDatabaseObject(DatabaseObject.builder().schema(SYS).table(DUM$COLUMNS).column("SCAN_STATUS").build())) {
                        schemaDUM$COLUMNS = "SYS.DUM$COLUMNS";
                    } else {
                        if (!exeCtx.hasDatabaseObject(DatabaseObject.builder().schema(SYSTEM).table(DUM$COLUMNS).column("SCAN_STATUS").build())) {
                            String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.DMU_REPO_NOT_FOUND"));
                            this.skipCheck(message, CheckResult.BLOCKER);
                            return;
                        }
                        schemaDUM$COLUMNS = "SYSTEM.DUM$COLUMNS";
                    }
                    try {
                        sqlQuery = "SELECT NLS_CHARSET_NAME(UDBCS_ID) FROM " + schemaDUM$DATABASE;
                        String dmuTargetCharacterSet = SqlUtils.getSingleString(sqlQuery, exeCtx);
                        if (!targetDatabaseCharacterSet.equals(dmuTargetCharacterSet)) {
                            String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.TARGET_DBCS_MISMATCH", dmuTargetCharacterSet, targetDatabaseCharacterSet));
                            this.skipCheck(message, CheckResult.BLOCKER);
                            return;
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        log.severe(e.toString(), e);
                        this.skipCheck(e.getMessage(), CheckResult.FATAL);
                    }
                    return;
                }
                try {
                    sqlQuery = "SELECT NLS_CHARSET_NAME(DDBCS_ID) FROM " + schemaDUM$DATABASE;
                    String assumedCharacterSet = SqlUtils.getSingleString(sqlQuery, exeCtx);
                    if (assumedCharacterSet != null && assumedCharacterSet.length() > 0) {
                        String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.ASSUMED_DBCS", assumedCharacterSet));
                        this.skipCheck(message, CheckResult.BLOCKER);
                        return;
                    }
                    break block24;
                }
                catch (Exception e) {
                    log.severe(e.toString(), e);
                    this.skipCheck(e.getMessage(), CheckResult.FATAL);
                }
                return;
            }
            try {
                String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "O.OWNER");
                String sqlQuery = "SELECT COUNT(*) FROM " + schemaDUM$COLUMNS + " DC, DBA_OBJECTS O" + whereClause + " AND DC.OBJ# = O.OBJECT_ID AND DC.SCAN_STATUS != 1";
                long notScannedColumnCount = SqlUtils.getSingleLong(sqlQuery, exeCtx);
                if (notScannedColumnCount != 0L) {
                    String message = MessageFormat.format("{0} {1}", databaseCharsetMessage, this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.DMU_NOT_SCANNED"));
                    this.skipCheck(message, CheckResult.BLOCKER);
                    return;
                }
                break block25;
            }
            catch (Exception e) {
                log.severe(e.toString(), e);
                this.skipCheck(e.getMessage(), CheckResult.FATAL);
            }
            return;
        }
        boolean canSelectSysCol$ = exeCtx.canSelectDatabaseObject(DatabaseObject.builder().schema(SYS).table("COL$").build());
        if (!canSelectSysCol$) {
            String message = this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_NOT_ACCESSIBLE", this.getName(), "SYS.COL$");
            this.skipCheck(message, CheckResult.WARNING);
            return;
        } else {
            String whereClauseMain = SqlUtils.createWhereClauseForColumn(exeCtx, "O.OWNER");
            String sqlQueryMain = "SELECT O.OWNER, O.OBJECT_NAME TABLE_NAME, C.NAME COLUMN_NAME, DC.DCCS_ID, DC.TOO_LARGE, DC.OVER_LIMIT, DC.INVALID, (DC.SCHEDULED_TOO_LARGE+DC.SCHEDULED_OVER_LIMIT+DC.SCHEDULED_INVALID) SCHEDULED_ISSUES FROM " + schemaDUM$COLUMNS + " DC, DBA_OBJECTS O, SYS.COL$ C" + whereClauseMain + " AND DC.OBJ# = O.OBJECT_ID AND DC.OBJ# = C.OBJ# AND DC.INTCOL# = C.INTCOL# AND (NVL(DC.DCCS_ID,0) > 0 OR DC.TOO_LARGE + DC.OVER_LIMIT + DC.INVALID > 0)";
            this.setSqlQuery(sqlQueryMain);
            try {
                String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "O.OWNER");
                String sqlQuery = "SELECT TO_CHAR(MIN(DC.SCAN_START),'YYYY-MM-DD HH24:MI:SS') FROM " + schemaDUM$COLUMNS + " DC, DBA_OBJECTS O" + whereClause + " AND DC.OBJ# = O.OBJECT_ID";
                this.scanDateTime = SqlUtils.getSingleString(sqlQuery, exeCtx);
                return;
            }
            catch (Exception e) {
                log.severe(e.toString(), e);
                this.skipCheck(e.getMessage(), CheckResult.FATAL);
            }
        }
    }

    @Override
    public CheckResult determineResult() {
        CheckResult result;
        List<Map<String, String>> relevantObjectsData = this.getRelevantObjectsData();
        if (relevantObjectsData.isEmpty()) {
            result = CheckResult.PASS;
            this.setErrorMessage(this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.NO_ISSUES", this.scanDateTime));
        } else {
            result = CheckResult.BLOCKER;
            boolean scheduledClean = true;
            for (Map<String, String> map : relevantObjectsData) {
                if ("0".equals(map.get("SCHEDULED_ISSUES"))) continue;
                scheduledClean = false;
                break;
            }
            if (scheduledClean) {
                this.setErrorMessage(this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.SCHEDULED_CLEAN", this.scanDateTime));
            } else {
                this.setErrorMessage(this.lang.txt("CHECK.NLS_CHARACTER_SET_CONVERSION.NOT_SCHEDULED_CLEAN", this.scanDateTime));
            }
        }
        return result;
    }
}

