/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_java_source
extends FilterableCheck {
    public has_java_source() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeFixed("JAVA SOURCE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if ("VALID".equalsIgnoreCase(exeCtx.getAnalysisProperty(TargetInstanceProp.JAVAVM_STATUS.getKey(), "NOPE"))) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_JAVA_STATUS_VALID", this.getName()), CheckResult.PASS);
        } else {
            String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
            String hasJavaSourcesSql = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE, STATUS FROM SYS.DBA_OBJECTS " + whereClause + " AND OBJECT_TYPE ='JAVA SOURCE' ORDER BY 1, 2";
            this.setSqlQuery(hasJavaSourcesSql);
        }
    }
}

