/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.AnalysisPropHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;
import java.util.Collections;

public abstract class has_data_in_other_tablespaces
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_data_in_other_tablespaces.class.getName());
    private static final String SELECT_FROM = "SELECT S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE FROM DBA_SEGMENTS S, DBA_OBJECTS O ";
    private static final String COMMON_PREDICATES = " AND S.SEGMENT_NAME=O.OBJECT_NAME AND S.OWNER = O.OWNER ";
    private static final String GROUP_AND_ORDER = " GROUP BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ORDER BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ";

    protected has_data_in_other_tablespaces() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.NONE, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeColumn("OBJECT_TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        AnalysisPropHelper propHelper = new AnalysisPropHelper(exeCtx, Collections.singletonList("DATA"), Collections.singletonList("TABLESPACE_NAME"));
        if (propHelper.isMigrationMethodMappingAll()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_MIGRATION_METHOD_TABLESPACE_MAPPING_ALL", this.getName()), CheckResult.PASS);
        }
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String andClause = propHelper.getTablespaceAndClause();
        String sqlQuery = SELECT_FROM + whereClause + andClause + COMMON_PREDICATES + GROUP_AND_ORDER;
        this.setSqlQuery(sqlQuery);
    }
}

