/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

public final class DatabaseObject {
    private final String schema;
    private final String table;
    private final String view;
    private final String column;

    DatabaseObject(String schema, String table, String view, String column) {
        this.schema = schema;
        this.table = table;
        this.view = view;
        this.column = column;
    }

    public static DatabaseObjectBuilder builder() {
        return new DatabaseObjectBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getView() {
        return this.view;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseObject)) {
            return false;
        }
        DatabaseObject other = (DatabaseObject)o;
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseObject(schema=" + this.getSchema() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ")";
    }

    public static class DatabaseObjectBuilder {
        private String schema;
        private String table;
        private String view;
        private String column;

        DatabaseObjectBuilder() {
        }

        public DatabaseObjectBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public DatabaseObjectBuilder table(String table) {
            this.table = table;
            return this;
        }

        public DatabaseObjectBuilder view(String view) {
            this.view = view;
            return this;
        }

        public DatabaseObjectBuilder column(String column) {
            this.column = column;
            return this;
        }

        public DatabaseObject build() {
            return new DatabaseObject(this.schema, this.table, this.view, this.column);
        }

        public String toString() {
            return "DatabaseObject.DatabaseObjectBuilder(schema=" + this.schema + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ")";
        }
    }
}

