/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.reports.CheckResultDescription;

public enum CheckResult {
    PASS(0, 0),
    INFORMATIONAL(1, 1),
    WARNING(2, 2),
    BLOCKER(3, 3),
    FATAL(4, 255);

    final Language lang = Language.getInstance();
    private final int severityLevel;
    private final int commandLineExitCode;
    private String friendlyName;

    private CheckResult(int severityLevel, int commandLineExitCode) {
        this.severityLevel = severityLevel;
        this.commandLineExitCode = commandLineExitCode;
    }

    public static CheckResult max(CheckResult a, CheckResult b) {
        if (a.severityLevel > b.severityLevel) {
            return a;
        }
        return b;
    }

    public int compareSeverityTo(CheckResult checkResult) {
        return this.severityLevel - checkResult.severityLevel;
    }

    public int getExitCode() {
        return this.commandLineExitCode;
    }

    public CheckResultDescription toCheckResultDescription(Language lang) {
        return new CheckResultDescription(this, this.toString(), this.severityLevel, lang.txt("CHECK_RESULT_" + this.name() + "_DESCRIPTION"));
    }

    public String toString() {
        if (this.friendlyName == null) {
            this.friendlyName = this.lang.txt("FRIENDLY_NAME_FOR_" + this.name());
        }
        return this.friendlyName;
    }
}

