/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.io;

import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.helpers.Utilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class OutputFilenamesContainer {
    private final String logOutputFilename;
    private final String jsonOutputFilename;
    private final String textOutputFilename;
    private final String propsOutputFilename;
    private final String outDir;

    public OutputFilenamesContainer(String outFilePrefix, String outDir) {
        String prefix = this.processOutFilePrefix(outFilePrefix);
        this.outDir = outDir;
        String baseOutputFilename = "premigration_advisor";
        this.logOutputFilename = prefix + "premigration_advisor" + ".log";
        this.jsonOutputFilename = prefix + "premigration_advisor" + "_report.json";
        this.textOutputFilename = prefix + "premigration_advisor" + "_report.txt";
        this.propsOutputFilename = prefix + "premigration_advisor" + "_analysis.properties";
    }

    private String processOutFilePrefix(String outFilePrefix) {
        String defaultPrefix = "";
        if (outFilePrefix == null) {
            return "";
        }
        String prefix = this.getValidFilePrefix(outFilePrefix);
        if (prefix == null) {
            String errorMsg = Utilities.getErrorText("ERROR1011", new String[0]);
            System.out.println(errorMsg);
            return "";
        }
        if (prefix.length() > 0) {
            return prefix + "_";
        }
        return "";
    }

    private String getValidatedFilePath(String fileName) throws IOException, AccessDeniedException {
        String validatedPath = this.getOutdirValidated(this.outDir);
        Path path = Paths.get(validatedPath, new String[0]).resolve(fileName);
        String pathString = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isWritable(path)) {
                throw new AccessDeniedException(pathString);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException(Utilities.getErrorText("ERROR3001", pathString));
            }
        }
        return pathString;
    }

    public String getValidatedLogFilePath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.logOutputFilename);
    }

    public String getValidatedTextReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.textOutputFilename);
    }

    public String getValidatedJSONReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.jsonOutputFilename);
    }

    public String getValidatedPropertiesFilePath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.propsOutputFilename);
    }

    private String getValidFilePrefix(String fileName) {
        String name = fileName.replaceAll("[^-_.A-Za-z0-9]", "").trim();
        if (name.length() == 0) {
            return "";
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            return null;
        }
        if (name.length() > 200) {
            name = name.substring(0, 199);
        }
        return name;
    }

    private String getOutdirValidated(String outDir) throws IOException, AccessDeniedException {
        File file = this.getOutDirFile(outDir);
        if (file.canWrite()) {
            return file.getCanonicalPath();
        }
        throw new AccessDeniedException("Cannot write on " + file.getCanonicalPath());
    }

    private File getOutDirFile(String outDir) throws IOException {
        File file = new File(outDir);
        if (file.exists()) {
            return file;
        }
        if (file.mkdirs()) {
            return file;
        }
        throw new IOException("Cannot create dir " + outDir);
    }

    public String getLogOutputFilename() {
        return this.logOutputFilename;
    }

    public String getJsonOutputFilename() {
        return this.jsonOutputFilename;
    }

    public String getTextOutputFilename() {
        return this.textOutputFilename;
    }

    public String getPropsOutputFilename() {
        return this.propsOutputFilename;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputFilenamesContainer)) {
            return false;
        }
        OutputFilenamesContainer other = (OutputFilenamesContainer)o;
        String this$logOutputFilename = this.getLogOutputFilename();
        String other$logOutputFilename = other.getLogOutputFilename();
        if (this$logOutputFilename == null ? other$logOutputFilename != null : !this$logOutputFilename.equals(other$logOutputFilename)) {
            return false;
        }
        String this$jsonOutputFilename = this.getJsonOutputFilename();
        String other$jsonOutputFilename = other.getJsonOutputFilename();
        if (this$jsonOutputFilename == null ? other$jsonOutputFilename != null : !this$jsonOutputFilename.equals(other$jsonOutputFilename)) {
            return false;
        }
        String this$textOutputFilename = this.getTextOutputFilename();
        String other$textOutputFilename = other.getTextOutputFilename();
        if (this$textOutputFilename == null ? other$textOutputFilename != null : !this$textOutputFilename.equals(other$textOutputFilename)) {
            return false;
        }
        String this$propsOutputFilename = this.getPropsOutputFilename();
        String other$propsOutputFilename = other.getPropsOutputFilename();
        if (this$propsOutputFilename == null ? other$propsOutputFilename != null : !this$propsOutputFilename.equals(other$propsOutputFilename)) {
            return false;
        }
        String this$outDir = this.getOutDir();
        String other$outDir = other.getOutDir();
        return !(this$outDir == null ? other$outDir != null : !this$outDir.equals(other$outDir));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logOutputFilename = this.getLogOutputFilename();
        result = result * 59 + ($logOutputFilename == null ? 43 : $logOutputFilename.hashCode());
        String $jsonOutputFilename = this.getJsonOutputFilename();
        result = result * 59 + ($jsonOutputFilename == null ? 43 : $jsonOutputFilename.hashCode());
        String $textOutputFilename = this.getTextOutputFilename();
        result = result * 59 + ($textOutputFilename == null ? 43 : $textOutputFilename.hashCode());
        String $propsOutputFilename = this.getPropsOutputFilename();
        result = result * 59 + ($propsOutputFilename == null ? 43 : $propsOutputFilename.hashCode());
        String $outDir = this.getOutDir();
        result = result * 59 + ($outDir == null ? 43 : $outDir.hashCode());
        return result;
    }

    public String toString() {
        return "OutputFilenamesContainer(logOutputFilename=" + this.getLogOutputFilename() + ", jsonOutputFilename=" + this.getJsonOutputFilename() + ", textOutputFilename=" + this.getTextOutputFilename() + ", propsOutputFilename=" + this.getPropsOutputFilename() + ", outDir=" + this.getOutDir() + ")";
    }
}

