/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

public enum TargetInstanceProp {
    CPAT_VERSION(null, null, null),
    ALLOW_ROWID_COLUMN_TYPE("SELECT VALUE AS VALUE FROM V$PARAMETER WHERE LOWER(NAME)='allow_rowid_column_type'", "FALSE"),
    CLOUD_SERVICE("SELECT UPPER(SYS_CONTEXT('USERENV', 'CLOUD_SERVICE')) AS CLOUD_SERVICE FROM DUAL", "", true),
    DB_BLOCK_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'db_block_size'", ""),
    DB_PLATFORM_ID("SELECT PLATFORM_ID FROM V$DATABASE", ""),
    DIRECTORIES("SELECT LISTAGG(DIRECTORY_NAME, ',') WITHIN GROUP (ORDER BY DIRECTORY_NAME) FROM (SELECT DIRECTORY_NAME FROM SYS.DBA_DIRECTORIES)", "", "[^a-zA-Z0-9.,_#$\\s]"),
    JAVAVM_STATUS("SELECT STATUS AS JAVAVM_STATUS FROM SYS.DBA_REGISTRY WHERE comp_id = 'JAVAVM'", ""),
    NLS_NCHAR_CHARACTERSET("SELECT  VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_nchar_characterset'", "AL16UTF16"),
    MAX_STRING_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'max_string_size'", "EXTENDED"),
    PDB_LOCKDOWN("SELECT UPPER(VALUE) AS PDB_LOCKDOWN FROM V$PARAMETER WHERE UPPER(NAME) = 'PDB_LOCKDOWN'", ""),
    PROFILES("SELECT LISTAGG(PROFILE,',') WITHIN GROUP( ORDER BY PROFILE) FROM (SELECT DISTINCT PROFILE FROM SYS.DBA_PROFILES) ", ""),
    ROLEPRIVILEGE("SELECT LISTAGG(GRANTED_ROLE, ',') WITHIN GROUP (ORDER BY GRANTED_ROLE) FROM (SELECT DISTINCT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS START WITH GRANTEE IN ('ADMIN') CONNECT BY PRIOR GRANTED_ROLE = GRANTEE AND ADMIN_OPTION='YES')", ""),
    SYSPRIVILEGE("SELECT LISTAGG(PRIVILEGE,',') WITHIN GROUP( ORDER BY PRIVILEGE) FROM (SELECT PRIVILEGE FROM SYS.DBA_SYS_PRIVS WHERE GRANTEE='ADMIN' AND ADMIN_OPTION='YES') ", ""),
    TABLESPACES("SELECT LISTAGG(TABLESPACE_NAME, ',') WITHIN GROUP (ORDER BY TABLESPACE_NAME)   FROM (SELECT TABLESPACE_NAME FROM SYS.DBA_TABLESPACES) ", ""),
    TZ_VERSION("SELECT CAST(VERSION AS VARCHAR2(100)) AS TZ_VERSION FROM V$TIMEZONE_FILE", ""),
    NLS_CHARACTERSET("SELECT VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_characterset'", "AL32UTF8"),
    DB_VERSION(null, ""),
    TABLESPACE_BLOCK_SIZE(null, "");

    private final String propertyKey = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    private final String sqlQuery;
    private final String defaultValue;
    private final String regexFilter;
    private final boolean ignoreSQLException;

    private TargetInstanceProp(String sqlQuery, String defaultValue, String regexFilter, boolean ignoreSQLException) {
        this.defaultValue = defaultValue;
        this.sqlQuery = sqlQuery;
        this.regexFilter = regexFilter;
        this.ignoreSQLException = ignoreSQLException;
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue, String regexFilter) {
        this(sqlQuery, defaultValue, regexFilter, false);
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue, boolean ignoreSQLException) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]", ignoreSQLException);
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]", false);
    }

    public boolean getIgnoreSQLException() {
        return this.ignoreSQLException;
    }

    public String toString() {
        return this.propertyKey;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public String getKey(String suffix) {
        return this.propertyKey + "." + suffix;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }
}

