/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.ideimpl.inspector.InspectorWindowImpl;

final class TargetMonitor
implements Observer {
    private final List<Subject> targets = new ArrayList<Subject>();
    private final List<Subject> hotTargets = new ArrayList<Subject>();
    private final InspectorWindowImpl inspectorWindow;
    private String title;

    TargetMonitor(InspectorWindowImpl inspectorWindow) {
        this.inspectorWindow = inspectorWindow;
    }

    void reset() {
        for (Subject s : this.targets) {
            s.detach((Observer)this);
        }
        this.targets.clear();
        for (Subject s : this.hotTargets) {
            s.detach((Observer)this);
        }
        this.hotTargets.clear();
        this.title = null;
    }

    String title() {
        return this.title;
    }

    void title(String title) {
        this.title = title;
    }

    boolean isMonitoring() {
        return this.targets.size() > 0 || this.hotTargets.size() > 0;
    }

    void monitor(Subject target) {
        this.monitor(target, false);
    }

    void monitor(Subject target, boolean notify) {
        if (target != null) {
            if (notify) {
                if (this.targets.contains(target)) {
                    this.targets.remove(target);
                }
                if (!this.hotTargets.contains(target)) {
                    this.hotTargets.add(target);
                }
            } else if (!this.hotTargets.contains(target)) {
                this.targets.add(target);
            }
            if (target != null) {
                target.attach((Observer)this);
            }
        }
    }

    public void update(Object observed, UpdateMessage msg) {
        if (msg.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
            URL url;
            List list = msg.getAddObjects();
            Node subject = null;
            URL oldURL = null;
            if (!list.isEmpty()) {
                subject = (Subject)list.get(0);
            } else {
                subject = RenameMessage.getRenamedNode((UpdateMessage)msg);
                if (subject != null) {
                    try {
                        oldURL = (URL)msg.getModifyObjects().get(0);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                } else {
                    subject = (Subject)observed;
                    try {
                        oldURL = (URL)msg.getModifyObjects().get(0);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                }
            }
            if (oldURL != null && subject instanceof Locatable && (url = ((Locatable)subject).getURL()) != oldURL && !url.equals(oldURL)) {
                this.inspectorWindow.updateURL(url, oldURL);
            }
            if (!this.targets.contains(subject)) {
                this.targets.remove(observed);
                this.monitor((Subject)subject);
            }
            if (this.inspectorWindow.isVisible()) {
                this.inspectorWindow.restorePinTarget(false);
            }
        } else if (msg.getMessageID() != UpdateMessage.OBJECT_CLOSING) {
            if (msg.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
                this.inspectorWindow.disposeURLs();
                this.inspectorWindow.clearPinTargets();
                this.reset();
                this.inspectorWindow.clear();
            } else if (this.inspectorWindow.isVisible() && this.hotTargets.contains(observed)) {
                this.inspectorWindow.restorePinTarget(false);
            }
        }
    }
}

