/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.layout;

import javax.ide.util.MetaClass;
import oracle.ide.inspector.layout.AutoExpandPreferredSize;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.Extensible;

public abstract class PropertyFormLayout
implements Element {
    public static final String PROPERTY_FORM_LAYOUT = "property-form-layout";
    public static final String PROPERTY_MODEL_CLASS = "property-model-class";
    public static final String AUTO_EXTEND_PREFERRED_SIZE = "auto-extend-preferred-size";

    public abstract MetaClass getPropertyModelClass();

    public AutoExpandPreferredSize getAutoExtendPreferredSize() {
        return AutoExpandPreferredSize.DEFAULT;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean isExtensible() {
        return false;
    }

    @Override
    public Extensible getExtensible() {
        return null;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (Element layout : this.getChildren()) {
                buffer.append(layout.toString());
            }
            MetaClass mclass = this.getPropertyModelClass();
            return String.format("<%s %s=\"%s\">\n%s</%s>\n", PROPERTY_FORM_LAYOUT, PROPERTY_MODEL_CLASS, mclass != null ? mclass.getClassName() : null, buffer.toString(), PROPERTY_FORM_LAYOUT);
        }
        catch (Exception e) {
            return String.format("%s at line %d of %s\n", e.toString(), e.getStackTrace()[0].getLineNumber(), e.getStackTrace()[0].getFileName());
        }
    }
}

