/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.find;

import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import javax.swing.JComponent;
import oracle.ide.inspector.find.SearchIterator;
import oracle.ide.inspector.find.SearchableContainer;
import oracle.ide.inspector.find.SearchableLabel;
import oracle.ide.inspector.find.SearchableText;
import oracle.ide.inspector.layout.CustomGUIComponent;

public class ContainerSearch {
    private Container _container;
    private SearchableContainer foundContainer;
    private SearchableLabel foundLabel;
    private static int _instanceCounter;
    private String _identifier;
    private static final String CLIENT_PROPERTY = "oracle.ide.inspector.find.ContainerSearch";

    public ContainerSearch(Container container) {
        this._container = container;
        this._identifier = "CS#" + _instanceCounter++;
    }

    public String toString() {
        return this._identifier;
    }

    public boolean findText(String searchText, boolean searchForward, boolean searchRepeat) {
        if (this.foundLabel != null) {
            this.foundLabel.getSearchableText().removeFoundTextEffect();
        }
        if (searchText.length() == 0) {
            this.foundLabel = null;
            if (this.foundContainer != null) {
                this.foundContainer.findText("", true, false);
                this.foundContainer = null;
            }
            return false;
        }
        Iterator<Component> children = this.createSearchIterator(this._container, searchForward);
        while (children.hasNext()) {
            CustomGUIComponent guiComponent;
            Component c = children.next();
            if (c == this._container || !((guiComponent = this.customGUIComponentFrom(c)) != null ? this.findIn(guiComponent, searchText, searchForward, searchRepeat) : c instanceof SearchableLabel && this.findIn((SearchableLabel)((Object)c), searchText, searchRepeat, false))) continue;
            return true;
        }
        if (this.foundLabel != null || this.foundContainer != null) {
            this.foundLabel = null;
            this.foundContainer = null;
            return this.findText(searchText, searchForward, searchRepeat);
        }
        return false;
    }

    private CustomGUIComponent customGUIComponentFrom(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        return CustomGUIComponent.getCustomGUIComponent((JComponent)c);
    }

    private boolean findIn(CustomGUIComponent guiComponent, String searchText, boolean searchForward, boolean searchRepeat) {
        SearchableContainer searchable;
        if (this.foundLabel != null) {
            return false;
        }
        if (this.foundContainer != null && guiComponent == this.foundContainer) {
            SearchableContainer searchable2 = (SearchableContainer)((Object)guiComponent);
            if (searchable2.findText(searchText, searchForward, searchRepeat)) {
                return true;
            }
            this.foundContainer = null;
            return false;
        }
        if (guiComponent instanceof SearchableContainer && (searchable = (SearchableContainer)((Object)guiComponent)).findText(searchText, searchForward, searchRepeat)) {
            this.foundContainer = (SearchableContainer)((Object)guiComponent);
            return true;
        }
        return false;
    }

    private boolean findIn(SearchableLabel searchableLabel, String searchText, boolean searchRepeat, boolean matchCase) {
        if (this.foundContainer != null) {
            return false;
        }
        SearchableText label = searchableLabel.getSearchableText();
        if (this.foundLabel != null) {
            if (searchableLabel == this.foundLabel) {
                this.foundLabel = null;
                if (searchRepeat) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (label.findText(searchText, matchCase)) {
            this.foundLabel = searchableLabel;
            this.makeFoundComponentVisible((Component)((Object)searchableLabel));
            return true;
        }
        return false;
    }

    public Iterator<Component> createSearchIterator(Container root, boolean forward) {
        return new SearchIterator(root, forward);
    }

    public void makeFoundComponentVisible(Component c) {
        Container parent = c.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).scrollRectToVisible(c.getBounds());
        }
    }

    public static ContainerSearch fromContainer(JComponent container) {
        return (ContainerSearch)container.getClientProperty(CLIENT_PROPERTY);
    }

    public void attachTo(JComponent container) {
        container.putClientProperty(CLIENT_PROPERTY, this);
    }
}

