/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.editor;

import java.awt.Component;
import javax.swing.JTextField;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.TextFieldEditorFactory;
import oracle.ide.inspector.DisplayValues;
import oracle.ide.inspector.PropertyInfo;
import oracle.javatools.ui.ExtendedTextField;

public final class ExtendedTextFieldEditorFactory
extends TextFieldEditorFactory {
    public boolean canCreateEditorFrom(Object creationInfo) {
        if (creationInfo instanceof EditorComponentInfo) {
            Object initialValue = ((EditorComponentInfo)creationInfo).initialValue();
            return this.isNullOrString(initialValue);
        }
        return this.isNullOrString(creationInfo);
    }

    public ExtendedTextField createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        return this.textField((String)initialValue);
    }

    public JTextField updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        JTextField editor = this.textField(current, (String)initialValue, propertyEditor);
        return editor;
    }

    protected JTextField textField(Component c, String initialValue, PropertyEditorFactory2 propertyEditor) {
        if (c instanceof JTextField) {
            String propertyEditorText;
            PropertyInfo property;
            String displayValue;
            PropertyValueApplier applier;
            JTextField textField = (JTextField)c;
            String currentValue = textField.getText();
            if (currentValue == null) {
                currentValue = "";
            }
            if ((applier = propertyEditor.getPropertyValueApplier()) instanceof PropertyInfo && (currentValue.equals(displayValue = DisplayValues.displayValue(property = (PropertyInfo)applier)) || currentValue.equals(initialValue))) {
                return textField;
            }
            if (initialValue == null && currentValue.equals(propertyEditorText = propertyEditor.getAsText())) {
                return textField;
            }
            if (!currentValue.equals(initialValue)) {
                textField.setText(initialValue);
            }
            return textField;
        }
        return null;
    }

    protected ExtendedTextField textField(String initialValue) {
        ExtendedTextField editor = new ExtendedTextField();
        editor.setText(initialValue);
        return editor;
    }
}

