/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.PropertyEditorListeners;

final class ScrollToVisibleFocusListeners {
    public static final String AUTO_SCROLL_ENABLED = "ScrollToVisible.AutoScrollEnabled";

    static void addScrollToVisibleFocusListener(Component c) {
        ScrollToVisibleFocusListeners.addScrollToVisibleFocusListener(c, false);
    }

    static void addScrollToVisibleFocusListener(final Component c, final boolean onlyIfOppositeIsNotNull) {
        FocusAdapter l = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!ScrollToVisibleFocusListeners.isAutoScrollEnabled(c)) {
                    ScrollToVisibleFocusListeners.enableAutoScroll(c);
                    return;
                }
                if (onlyIfOppositeIsNotNull && e.getOppositeComponent() == null) {
                    return;
                }
                Container parent = c.getParent();
                if (!(parent instanceof JComponent)) {
                    return;
                }
                Rectangle bounds = c.getBounds();
                ScrollToVisibleFocusListeners.constrainBoundsToViewportWidth(bounds, parent);
                ((JComponent)parent).scrollRectToVisible(bounds);
            }
        };
        PropertyEditorListeners.addFocusListenerToEditor(c, l);
    }

    private static void constrainBoundsToViewportWidth(Rectangle bounds, Component c) {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, c);
        if (viewport != null) {
            bounds.width = Math.min(bounds.width, viewport.getWidth());
        }
    }

    static void addScrollToVisibleFocusAdapter(LabelAndEditor labelAndEditor) {
        JLabel label = labelAndEditor.labelContainer().label();
        EditorContainer editorContainer = labelAndEditor.editorContainer();
        Component editor = editorContainer.editor();
        if (!(editor instanceof JComponent)) {
            ScrollToVisibleFocusListeners.addScrollToVisibleFocusListener(editor);
            return;
        }
        ScrollToVisibleFocusListeners.addScrollToVisibleFocusAdapter(label, editorContainer, (JComponent)editor);
    }

    static void addScrollToVisibleFocusAdapter(final JLabel label, final EditorContainer editorContainer, final JComponent editor) {
        FocusAdapter l = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!ScrollToVisibleFocusListeners.isAutoScrollEnabled(editor)) {
                    ScrollToVisibleFocusListeners.enableAutoScroll(editor);
                    return;
                }
                Container parent = editorContainer.getParent();
                if (!(parent instanceof JComponent)) {
                    return;
                }
                Rectangle visible = editorContainer.getVisibleRect();
                if (visible != null && visible.getWidth() > 0.0 && visible.getHeight() > 0.0 && visible.getX() == 0.0 && visible.getY() == 0.0) {
                    return;
                }
                Rectangle bounds = visible.getX() > 0.0 ? label.getBounds() : editorContainer.getBounds();
                ((JComponent)parent).scrollRectToVisible(bounds);
            }
        };
        PropertyEditorListeners.addFocusListenerToEditor(editor, l);
    }

    private static boolean isAutoScrollEnabled(Component c) {
        if (!(c instanceof JComponent)) {
            return true;
        }
        Object autoScrollEnabled = ((JComponent)c).getClientProperty(AUTO_SCROLL_ENABLED);
        return autoScrollEnabled == null || Boolean.TRUE.equals(autoScrollEnabled);
    }

    static void enableAutoScroll(Component c) {
        ScrollToVisibleFocusListeners.setAutoScrollEnabled(c, true);
    }

    static void disableAutoScroll(Component c) {
        ScrollToVisibleFocusListeners.setAutoScrollEnabled(c, false);
    }

    private static void setAutoScrollEnabled(Component c, boolean enabled) {
        if (!(c instanceof JComponent)) {
            return;
        }
        ((JComponent)c).putClientProperty(AUTO_SCROLL_ENABLED, enabled);
    }

    private ScrollToVisibleFocusListeners() {
    }
}

