/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.PropertyInspector;

public class PropertyHelpTextArea {
    private static final String EMPTY = "";

    public static FocusListener focusListenerToShowPropertyDescription(final Component inlineEditor, final PropertyModel model, final int row) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PropertyHelpTextArea.setPropertyHelpText(inlineEditor, model, row);
            }

            @Override
            public void focusLost(FocusEvent e) {
                PropertyHelpTextArea.clearHelpText(inlineEditor);
            }
        };
    }

    public static void setPropertyHelpText(Component source, PropertyModel model, int row) {
        String text = model.getPropertyDescription(row);
        PropertyHelpTextArea.setText(source, text);
    }

    public static void clearHelpText(Component source) {
        PropertyHelpTextArea.setText(source, EMPTY);
    }

    private static void setText(Component source, String text) {
        PropertyInspector inspector = PropertyHelpTextArea.ancestor(PropertyInspector.class, source);
        if (inspector == null) {
            return;
        }
        inspector.setStatusText(text);
    }

    private static <T extends Container> T ancestor(Class<T> type, Component c) {
        Container parent;
        if (c == null || type == null) {
            return null;
        }
        for (parent = c.getParent(); parent != null && !type.isInstance(parent); parent = parent.getParent()) {
        }
        return (T)parent;
    }

    private PropertyHelpTextArea() {
    }
}

